/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.yapbam.data.Category;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.transactiontable.TransactionTableUtils;

class StatementTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Transaction[] transactions;

    StatementTableModel(JTable table, Transaction[] transactions) {
        if (transactions == null) {
            throw new NullPointerException();
        }
        this.transactions = transactions;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return LocalizationData.get("Transaction.date");
        }
        if (columnIndex == 1) {
            return LocalizationData.get("Transaction.description");
        }
        if (columnIndex == 2) {
            return LocalizationData.get("Transaction.category");
        }
        if (columnIndex == 3) {
            return LocalizationData.get("Transaction.mode");
        }
        if (columnIndex == 4) {
            return LocalizationData.get("Transaction.number");
        }
        if (columnIndex == 5) {
            return LocalizationData.get("Transaction.valueDate");
        }
        if (columnIndex == 6) {
            return LocalizationData.get("StatementView.debt");
        }
        if (columnIndex == 7) {
            return LocalizationData.get("StatementView.receipt");
        }
        return "?";
    }

    @Override
    public int getRowCount() {
        return this.transactions.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == 5) {
            return Date.class;
        }
        if (columnIndex == 6 || columnIndex == 7) {
            return Double.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Transaction transaction = this.transactions[rowIndex];
        if (columnIndex == 0) {
            return transaction.getDate();
        }
        if (columnIndex == 1) {
            return TransactionTableUtils.getDescription(transaction, false, true, false);
        }
        if (columnIndex == 2) {
            Category category = transaction.getCategory();
            return category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName();
        }
        if (columnIndex == 3) {
            Mode mode = transaction.getMode();
            return mode.equals(Mode.UNDEFINED) ? LocalizationData.get("Mode.undefined") : mode.getName();
        }
        if (columnIndex == 4) {
            return transaction.getNumber();
        }
        if (columnIndex == 5) {
            return transaction.getValueDate();
        }
        if (columnIndex == 6) {
            return transaction.getAmount() < 0.0 ? Double.valueOf(-transaction.getAmount()) : null;
        }
        if (columnIndex == 7) {
            return transaction.getAmount() >= 0.0 ? Double.valueOf(transaction.getAmount()) : null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 && columnIndex >= 0;
    }

    public void setTransactions(Transaction[] transactions) {
        if (transactions == null) {
            throw new NullPointerException();
        }
        this.transactions = transactions;
        this.fireTableDataChanged();
    }

    public Transaction[] getTransactions() {
        return this.transactions;
    }

    public int find(Transaction transaction) {
        for (int i = 0; i < this.transactions.length; ++i) {
            if (this.transactions[i].getId() != transaction.getId()) continue;
            return i;
        }
        return -1;
    }
}

