/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTableListener;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import net.yapbam.data.AbstractTransactionUpdater;
import net.yapbam.data.Account;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Statement;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.actions.DeleteTransactionAction;
import net.yapbam.gui.actions.DuplicateTransactionAction;
import net.yapbam.gui.actions.EditTransactionAction;
import net.yapbam.gui.statementview.BalancePanel;
import net.yapbam.gui.statementview.ChangeValueDatePanel;
import net.yapbam.gui.statementview.CheckTransactionAction;
import net.yapbam.gui.statementview.StatementRenameDialog;
import net.yapbam.gui.statementview.StatementSelectionPanel;
import net.yapbam.gui.statementview.StatementTable;
import net.yapbam.gui.util.FriendlyTable;
import net.yapbam.gui.util.SplitPane;
import net.yapbam.util.DateUtils;

public class StatementViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String CHECK_MODE_READY_PROPERTY = "CheckModeReady";
    private static final Cursor CHECK_CURSOR;
    private static final Cursor UNCHECK_CURSOR;
    private StatementSelectionPanel statementSelectionPanel;
    private JPanel statementPanel = null;
    private BalancePanel balancePanel;
    private JLabel detail;
    private StatementTable uncheckedTransactionsTable;
    private StatementTable transactionsTable;
    private JCheckBox checkModeChkbx;
    private FilteredData data;
    CheckTransactionAction checkAction;
    private JPanel menuPanel;
    private JLabel lblNewLabel;
    private SplitPane splitPane;
    private JScrollPane notCheckedJScrollPane;
    private JLabel notCheckedColumns;
    private boolean checkModeReady = false;
    private JPanel notCheckedPanel;
    private ChangeValueDatePanel changeValueDatePanel;
    private JLabel summaryLabel;
    private JButton btnRename;
    private JPanel northPanel;
    private JPanel panel1;

    public StatementViewPanel(FilteredData data) {
        this.data = data;
        this.initialize();
        this.setTables();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getNorthPanel(), "North");
        this.add(this.getSplitPane());
    }

    private StatementSelectionPanel getStatementSelectionPanel() {
        if (this.statementSelectionPanel == null) {
            this.statementSelectionPanel = new StatementSelectionPanel(this.data);
            this.statementSelectionPanel.addPropertyChangeListener("SelectedStatement", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Statement selectedStatement = StatementViewPanel.this.getStatementSelectionPanel().getSelectedStatement();
                    if (selectedStatement == null || selectedStatement.getId() != null) {
                        StatementViewPanel.this.getCheckModeChkbx().setSelected(false);
                    }
                    StatementViewPanel.this.setTables();
                }
            });
        }
        return this.statementSelectionPanel;
    }

    private JPanel getStatementPanel() {
        if (this.statementPanel == null) {
            this.statementPanel = new JPanel();
            Border border = BorderFactory.createLineBorder(Color.gray, 3);
            border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), border);
            this.statementPanel.setBorder(border);
            this.statementPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbcBalance = new GridBagConstraints();
            gbcBalance.fill = 2;
            gbcBalance.weightx = 1.0;
            this.statementPanel.add((Component)this.getBalancePanel(), gbcBalance);
            GridBagConstraints gbcMenuPanel = new GridBagConstraints();
            gbcMenuPanel.anchor = 11;
            gbcMenuPanel.fill = 2;
            gbcMenuPanel.gridx = 0;
            gbcMenuPanel.gridy = 1;
            this.statementPanel.add((Component)this.getColumnsMenuPanel(), gbcMenuPanel);
            GridBagConstraints gbcJScrollPane = new GridBagConstraints();
            gbcJScrollPane.weighty = 1.0;
            gbcJScrollPane.weightx = 1.0;
            gbcJScrollPane.fill = 1;
            gbcJScrollPane.gridx = 0;
            gbcJScrollPane.gridy = 2;
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.getTransactionsTable());
            this.statementPanel.add((Component)jScrollPane, gbcJScrollPane);
            GridBagConstraints gbcDetail = new GridBagConstraints();
            gbcDetail.insets = new Insets(0, 0, 5, 0);
            gbcDetail.weightx = 1.0;
            gbcDetail.fill = 2;
            gbcDetail.gridx = 0;
            gbcDetail.gridy = 3;
            this.statementPanel.add((Component)this.getDetail(), gbcDetail);
        }
        return this.statementPanel;
    }

    private BalancePanel getBalancePanel() {
        if (this.balancePanel == null) {
            this.balancePanel = new BalancePanel();
            this.balancePanel.addPropertyChangeListener("editedStatement", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    StatementViewPanel.this.setTables();
                    StatementViewPanel.this.getTransactionsTable().setCursor(StatementViewPanel.this.balancePanel.getEditedStatement() != null ? UNCHECK_CURSOR : Cursor.getDefaultCursor());
                }
            });
        }
        return this.balancePanel;
    }

    private JLabel getDetail() {
        if (this.detail == null) {
            this.detail = new JLabel();
            this.detail.setHorizontalAlignment(0);
        }
        return this.detail;
    }

    StatementTable getTransactionsTable() {
        if (this.transactionsTable == null) {
            this.transactionsTable = new StatementTable(this.data);
            EditTransactionAction edit = new EditTransactionAction(this.transactionsTable);
            DeleteTransactionAction delete = new DeleteTransactionAction(this.transactionsTable);
            DuplicateTransactionAction duplicate = new DuplicateTransactionAction(this.transactionsTable);
            CheckTransactionAction checkAction = new CheckTransactionAction(this, this.transactionsTable, this.getUncheckedTransactionsTable(), false);
            this.transactionsTable.addMouseListener(new MyListener(new Action[]{edit, duplicate, delete}, edit, checkAction));
        }
        return this.transactionsTable;
    }

    StatementTable getUncheckedTransactionsTable() {
        if (this.uncheckedTransactionsTable == null) {
            this.uncheckedTransactionsTable = new StatementTable(this.data);
            EditTransactionAction edit = new EditTransactionAction(this.uncheckedTransactionsTable);
            DeleteTransactionAction delete = new DeleteTransactionAction(this.uncheckedTransactionsTable);
            DuplicateTransactionAction duplicate = new DuplicateTransactionAction(this.uncheckedTransactionsTable);
            this.checkAction = new CheckTransactionAction(this, this.uncheckedTransactionsTable, this.getTransactionsTable(), true);
            this.uncheckedTransactionsTable.addMouseListener(new MyListener(new Action[]{edit, duplicate, delete}, edit, this.checkAction));
        }
        return this.uncheckedTransactionsTable;
    }

    private JCheckBox getCheckModeChkbx() {
        if (this.checkModeChkbx == null) {
            this.checkModeChkbx = new JCheckBox(LocalizationData.get("CheckModePanel.title"));
            this.checkModeChkbx.setToolTipText(LocalizationData.get("CheckModePanel.title.tooltip"));
            this.checkModeChkbx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StatementViewPanel.this.setTables();
                }
            });
        }
        return this.checkModeChkbx;
    }

    public Printable getPrintable() {
        return this.transactionsTable.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
    }

    private JPanel getColumnsMenuPanel() {
        if (this.menuPanel == null) {
            this.menuPanel = new JPanel();
            this.menuPanel.setBorder(null);
            GridBagLayout gblMenuPanel = new GridBagLayout();
            this.menuPanel.setLayout(gblMenuPanel);
            GridBagConstraints gbcColumnsMenu = new GridBagConstraints();
            gbcColumnsMenu.weightx = 1.0;
            gbcColumnsMenu.insets = new Insets(0, 0, 0, 5);
            gbcColumnsMenu.anchor = 13;
            gbcColumnsMenu.gridx = 0;
            gbcColumnsMenu.gridy = 0;
            this.menuPanel.add((Component)this.getColumnsMenu(), gbcColumnsMenu);
        }
        return this.menuPanel;
    }

    private JLabel getColumnsMenu() {
        if (this.lblNewLabel == null) {
            this.lblNewLabel = new FriendlyTable.ShowHideColumsMenu(this.getTransactionsTable(), LocalizationData.get("MainFrame.showColumns"));
        }
        return this.lblNewLabel;
    }

    private SplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new SplitPane(0, true);
            this.splitPane.setTopComponent(this.getNotCheckedPanel());
            this.splitPane.setBottomComponent(this.getStatementPanel());
            this.setTables();
        }
        return this.splitPane;
    }

    protected JPanel getNotCheckedPanel() {
        if (this.notCheckedPanel == null) {
            this.notCheckedPanel = new JPanel(new GridBagLayout());
            Border border = BorderFactory.createLineBorder(Color.gray, 3);
            border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), border);
            this.notCheckedPanel.setBorder(border);
            GridBagConstraints gbcPanel = new GridBagConstraints();
            gbcPanel.insets = new Insets(0, 0, 5, 0);
            gbcPanel.gridwidth = 0;
            gbcPanel.weightx = 1.0;
            gbcPanel.fill = 2;
            gbcPanel.gridx = 0;
            gbcPanel.gridy = 0;
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            panel.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, Color.GRAY));
            GridBagLayout gblPanel = new GridBagLayout();
            panel.setLayout(gblPanel);
            this.notCheckedPanel.add((Component)panel, gbcPanel);
            JLabel label = new JLabel(LocalizationData.get("CheckModePanel.notChecked.title"));
            label.setHorizontalAlignment(2);
            GridBagConstraints gbcLabel = new GridBagConstraints();
            gbcLabel.weightx = 1.0;
            gbcLabel.insets = new Insets(0, 5, 0, 0);
            gbcLabel.anchor = 17;
            gbcLabel.gridx = 0;
            gbcLabel.gridy = 0;
            Font font = label.getFont();
            font = label.getFont().deriveFont(14 * label.getFont().getSize() / 12);
            label.setFont(font);
            panel.add((Component)label, gbcLabel);
            GridBagConstraints gbcNotCheckedColumns = new GridBagConstraints();
            gbcNotCheckedColumns.anchor = 13;
            gbcNotCheckedColumns.gridx = 0;
            gbcNotCheckedColumns.gridy = 1;
            gbcNotCheckedColumns.gridwidth = 0;
            this.notCheckedPanel.add((Component)this.getNotCheckedColumns(), gbcNotCheckedColumns);
            this.notCheckedJScrollPane = new JScrollPane();
            this.notCheckedJScrollPane.setViewportView(this.getUncheckedTransactionsTable());
            GridBagConstraints gbcNotCheckedJScrollPane = new GridBagConstraints();
            gbcNotCheckedJScrollPane.gridwidth = 0;
            gbcNotCheckedJScrollPane.weighty = 1.0;
            gbcNotCheckedJScrollPane.weightx = 1.0;
            gbcNotCheckedJScrollPane.fill = 1;
            gbcNotCheckedJScrollPane.gridy = 2;
            gbcNotCheckedJScrollPane.gridx = 0;
            this.notCheckedPanel.add((Component)this.notCheckedJScrollPane, gbcNotCheckedJScrollPane);
            GridBagConstraints gbcChangeValueDatePanel = new GridBagConstraints();
            gbcChangeValueDatePanel.anchor = 17;
            gbcChangeValueDatePanel.insets = new Insets(0, 5, 0, 0);
            gbcChangeValueDatePanel.gridx = 0;
            gbcChangeValueDatePanel.gridy = 3;
            this.notCheckedPanel.add((Component)this.getChangeValueDatePanel(), gbcChangeValueDatePanel);
            GridBagConstraints gbcSummaryLabel = new GridBagConstraints();
            gbcSummaryLabel.anchor = 13;
            gbcSummaryLabel.insets = new Insets(0, 0, 0, 5);
            gbcSummaryLabel.gridx = 1;
            gbcSummaryLabel.gridy = 3;
            this.notCheckedPanel.add((Component)this.getSummaryLabel(), gbcSummaryLabel);
        }
        return this.notCheckedPanel;
    }

    private JLabel getNotCheckedColumns() {
        if (this.notCheckedColumns == null) {
            this.notCheckedColumns = new FriendlyTable.ShowHideColumsMenu(this.getUncheckedTransactionsTable(), LocalizationData.get("MainFrame.showColumns"));
        }
        return this.notCheckedColumns;
    }

    private JLabel getSummaryLabel() {
        if (this.summaryLabel == null) {
            this.summaryLabel = new JLabel();
            this.getUncheckedTransactionsTable().addPropertyChangeListener("selectedTransaction", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Transaction[] transactions = StatementViewPanel.this.getUncheckedTransactionsTable().getSelectedTransactions();
                    StatementViewPanel.this.summaryLabel.setVisible(transactions.length > 0);
                    if (transactions.length > 0) {
                        String message;
                        if (transactions.length == 1) {
                            message = Formatter.format(LocalizationData.get("CheckModePanel.selectedSummarySingular"), LocalizationData.getCurrencyInstance().format(transactions[0].getAmount()));
                        } else {
                            double total = 0.0;
                            for (Transaction transaction : transactions) {
                                total += transaction.getAmount();
                            }
                            message = Formatter.format(LocalizationData.get("CheckModePanel.selectedSummaryPlural"), transactions.length, LocalizationData.getCurrencyInstance().format(total));
                        }
                        StatementViewPanel.this.summaryLabel.setText(message);
                    }
                }
            });
        }
        return this.summaryLabel;
    }

    private void setTables() {
        Transaction[] transactions;
        Statement statement = this.getStatementSelectionPanel().getSelectedStatement();
        boolean statementSelected = statement != null;
        boolean checkModeAvailable = statementSelected && statement.getId() == null;
        boolean checkMode = checkModeAvailable && this.getCheckModeChkbx().isSelected();
        this.getCheckModeChkbx().setVisible(checkModeAvailable);
        this.getBtnRename().setVisible(statementSelected && statement.getId() != null);
        this.getNotCheckedPanel().setVisible(checkMode);
        if (checkMode) {
            if (!this.getSplitPane().isDividerVisible()) {
                this.getSplitPane().setDividerLocation(0.5);
            }
        } else {
            this.getSplitPane().setDividerLocation(0.0);
        }
        this.getSplitPane().setDividerVisible(checkMode);
        DecimalFormat ci = LocalizationData.getCurrencyInstance();
        if (checkMode) {
            this.getUncheckedTransactionsTable().setTransactions(this.getTransactions(this.statementSelectionPanel.getAccount(), null));
            String statementId = this.getBalancePanel().getEditedStatement();
            double uncheckedStart = statement.getStartBalance();
            statement = statementId == null ? null : this.getStatementSelectionPanel().getStatement(statementId);
            boolean showWarningMessage = false;
            if (statement == null) {
                statement = new Statement(statementId, uncheckedStart);
                transactions = new Transaction[]{};
            } else {
                showWarningMessage = this.getStatementSelectionPanel().isThereANewerStatement(statementId);
                transactions = this.getTransactions(this.statementSelectionPanel.getAccount(), statementId);
            }
            this.getBalancePanel().setAlertVisible(showWarningMessage);
        } else {
            transactions = statementSelected ? this.getTransactions(this.statementSelectionPanel.getAccount(), statement.getId()) : new Transaction[]{};
        }
        this.getTransactionsTable().setTransactions(transactions);
        this.getBalancePanel().setCheckMode(checkMode);
        this.getBalancePanel().setStatement(statementSelected ? statement : null);
        this.getDetail().setText(Formatter.format(LocalizationData.get("StatementView.statementSummary"), statementSelected ? statement.getNbTransactions() : 0, statementSelected ? ci.format(statement.getNegativeBalance()) : Double.valueOf(0.0), statementSelected ? ci.format(statement.getPositiveBalance()) : Double.valueOf(0.0)));
        this.getUncheckedTransactionsTable().setCursor(this.isCheckModeReady() ? CHECK_CURSOR : Cursor.getDefaultCursor());
        this.getTransactionsTable().setCursor(this.isCheckModeReady() ? UNCHECK_CURSOR : Cursor.getDefaultCursor());
        if (this.isCheckModeReady() != this.checkModeReady) {
            this.checkModeReady = !this.checkModeReady;
            this.firePropertyChange(CHECK_MODE_READY_PROPERTY, !this.isCheckModeReady(), this.isCheckModeReady());
        }
    }

    boolean isCheckModeReady() {
        return this.getCheckModeChkbx().isSelected() && this.getBalancePanel().getEditedStatement() != null;
    }

    String getEditedStatement() {
        return this.getBalancePanel().getEditedStatement();
    }

    private Transaction[] getTransactions(Account account, String statementId) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (int i = 0; i < this.data.getGlobalData().getTransactionsNumber(); ++i) {
            Transaction transaction = this.data.getGlobalData().getTransaction(i);
            if (!transaction.getAccount().equals(account) || !NullUtils.areEquals(statementId, transaction.getStatement())) continue;
            transactions.add(transaction);
        }
        Collections.sort(transactions, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction o1, Transaction o2) {
                int result = DateUtils.dateToInteger(o1.getValueDate()) - DateUtils.dateToInteger(o2.getValueDate());
                if (result == 0) {
                    result = DateUtils.dateToInteger(o1.getDate()) - DateUtils.dateToInteger(o2.getDate());
                }
                return result;
            }
        });
        return transactions.toArray(new Transaction[transactions.size()]);
    }

    private ChangeValueDatePanel getChangeValueDatePanel() {
        if (this.changeValueDatePanel == null) {
            this.changeValueDatePanel = new ChangeValueDatePanel(this.getUncheckedTransactionsTable());
        }
        return this.changeValueDatePanel;
    }

    FilteredData getFilteredData() {
        return this.data;
    }

    public boolean isCheckMode() {
        return this.getCheckModeChkbx().isSelected();
    }

    private boolean hasStatement(GlobalData gData, String accountName, String statement) {
        for (int i = 0; i < gData.getTransactionsNumber(); ++i) {
            Transaction transaction = gData.getTransaction(i);
            if (!accountName.equals(transaction.getAccount().getName()) || !statement.equals(transaction.getStatement())) continue;
            return true;
        }
        return false;
    }

    private void renameStatement(GlobalData gData, final String accountName, final String newStatement, final String currentStatement) {
        AbstractTransactionUpdater updater = new AbstractTransactionUpdater(gData){

            @Override
            protected Transaction change(Transaction t) {
                if (accountName.equals(t.getAccount().getName()) && currentStatement.equals(t.getStatement())) {
                    return new Transaction(t.getDate(), t.getNumber(), t.getDescription(), t.getComment(), t.getAmount(), t.getAccount(), t.getMode(), t.getCategory(), t.getValueDate(), newStatement, Arrays.asList(t.getSubTransactions()));
                }
                return null;
            }
        };
        updater.doIt();
    }

    private JButton getBtnRename() {
        if (this.btnRename == null) {
            this.btnRename = new JButton(LocalizationData.get("StatementDialog.button.name"));
            this.btnRename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GlobalData gData = StatementViewPanel.this.data.getGlobalData();
                    Window owner = Utils.getOwnerWindow(StatementViewPanel.this.btnRename);
                    StatementRenameDialog dialog = new StatementRenameDialog(owner, gData);
                    dialog.setVisible(true);
                    String newStatement = (String)dialog.getResult();
                    String currentStatement = StatementViewPanel.this.getStatementSelectionPanel().getSelectedStatement().getId();
                    if (newStatement != null && !newStatement.equals(currentStatement)) {
                        String message;
                        int choice;
                        String accountName = StatementViewPanel.this.statementSelectionPanel.getAccount().getName();
                        if (StatementViewPanel.this.hasStatement(gData, accountName, newStatement) && (choice = JOptionPane.showConfirmDialog(owner, message = Formatter.format(LocalizationData.get("StatementDialog.existing.message"), newStatement, currentStatement), LocalizationData.get("StatementDialog.existing.title"), 2, 2)) == 2) {
                            return;
                        }
                        StatementViewPanel.this.renameStatement(gData, accountName, newStatement, currentStatement);
                        StatementViewPanel.this.getStatementSelectionPanel().select(newStatement);
                    }
                }
            });
            this.btnRename.setToolTipText(LocalizationData.get("StatementDialog.button.tooltip"));
        }
        return this.btnRename;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            GridBagLayout gblNorthPanel = new GridBagLayout();
            this.northPanel.setLayout(gblNorthPanel);
            GridBagConstraints gbcPanel1 = new GridBagConstraints();
            gbcPanel1.anchor = 17;
            gbcPanel1.weightx = 1.0;
            gbcPanel1.fill = 3;
            gbcPanel1.gridx = 1;
            gbcPanel1.gridy = 0;
            this.northPanel.add((Component)this.getPanel1(), gbcPanel1);
            GridBagConstraints gbcCheckModeChkbx = new GridBagConstraints();
            gbcCheckModeChkbx.insets = new Insets(0, 0, 0, 5);
            gbcCheckModeChkbx.weightx = 1.0;
            gbcCheckModeChkbx.anchor = 13;
            gbcCheckModeChkbx.gridx = 2;
            gbcCheckModeChkbx.gridy = 0;
            this.northPanel.add((Component)this.getCheckModeChkbx(), gbcCheckModeChkbx);
        }
        return this.northPanel;
    }

    private JPanel getPanel1() {
        if (this.panel1 == null) {
            this.panel1 = new JPanel();
            this.panel1.setLayout(new FlowLayout(1, 5, 5));
            this.panel1.add(this.getStatementSelectionPanel());
            this.panel1.add(this.getBtnRename());
        }
        return this.panel1;
    }

    Account getSelectedAccount() {
        return this.getStatementSelectionPanel().getAccount();
    }

    static {
        URL imgURL = LocalizationData.class.getResource("images/checkCursor.png");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        CHECK_CURSOR = toolkit.createCustomCursor(toolkit.getImage(imgURL), new Point(5, 13), "checked");
        imgURL = LocalizationData.class.getResource("images/uncheckCursor.png");
        UNCHECK_CURSOR = toolkit.createCustomCursor(toolkit.getImage(imgURL), new Point(8, 8), "unchecked");
    }

    private static class MyListener
    extends JTableListener {
        private Action checkAction;

        public MyListener(Action[] actions, Action defaultAction, Action checkAction) {
            super(actions, defaultAction);
            this.checkAction = checkAction;
        }

        @Override
        protected void fillPopUp(JPopupMenu popup) {
            if (this.checkAction.isEnabled()) {
                popup.add(new JMenuItem(this.checkAction));
                popup.addSeparator();
            }
            super.fillPopUp(popup);
        }

        @Override
        protected Action getDoubleClickAction() {
            if (this.checkAction.isEnabled()) {
                return this.checkAction;
            }
            return super.getDoubleClickAction();
        }
    }
}

