/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statistics;

import com.fathzer.jlocal.Formatter;
import net.yapbam.gui.LocalizationData;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.PieDataset;

class OptimizedToolTipGenerator
implements PieToolTipGenerator {
    Double total = null;

    OptimizedToolTipGenerator() {
    }

    @Override
    public String generateToolTip(PieDataset dataset, Comparable key) {
        if (this.total == null) {
            this.total = 0.0;
            for (int i = 0; i < dataset.getItemCount(); ++i) {
                this.total = this.total + (Double)dataset.getValue(i);
            }
        }
        Double amount = (Double)dataset.getValue(key);
        String amountString = LocalizationData.getCurrencyInstance().format(amount);
        return this.total == 0.0 ? Formatter.format("{0} : {1}", key, amountString) : Formatter.format("{0} : {1} ({2,number,#.#}%)", key, amountString, amount / this.total * 100.0);
    }

    public void clear() {
        this.total = null;
    }
}

