/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.calculator;

import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.DoubleEvaluator;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.util.BigDecimalEvaluator;

public class CalculatorPanel
extends JPanel {
    private static final char CLEAR = 'C';
    private static final char EQUAL = '=';
    private static final Character PLUS = Character.valueOf(DoubleEvaluator.PLUS.getSymbol().charAt(0));
    private static final Character MINUS = Character.valueOf(DoubleEvaluator.MINUS.getSymbol().charAt(0));
    private static final Character MULTIPLY = Character.valueOf(DoubleEvaluator.MULTIPLY.getSymbol().charAt(0));
    private static final Character DIVIDE = Character.valueOf(DoubleEvaluator.DIVIDE.getSymbol().charAt(0));
    private static final Character OPEN = Character.valueOf(BracketPair.PARENTHESES.getOpen().charAt(0));
    private static final Character CLOSE = Character.valueOf(BracketPair.PARENTHESES.getClose().charAt(0));
    private static final char POINT = '.';
    private static final int PRECISION = 20;
    private JTextField result;
    private CalculatorButton openBracket;
    private CalculatorButton closeBracket;
    private CalculatorButton btn7;
    private CalculatorButton btn6;
    private CalculatorButton btn5;
    private CalculatorButton btn4;
    private CalculatorButton btn3;
    private CalculatorButton btn2;
    private CalculatorButton btn8;
    private CalculatorButton btn9;
    private CalculatorButton btn1;
    private CalculatorButton btn0;
    private CalculatorButton btnDecimal;
    private CalculatorButton btnPlus;
    private CalculatorButton btnMinus;
    private CalculatorButton btnMultiply;
    private CalculatorButton btnDivide;
    private CalculatorButton btnErase;
    private CalculatorButton btnEquals;
    private CalculatorButton btnClear;
    private Map<Character, JButton> map;
    private char decimalSeparator;
    private StringBuilder formula;
    private StringBuilder internalFormula;
    private BigDecimal value;
    private BigDecimalEvaluator evaluator = new BigDecimalEvaluator(new MathContext(23));
    private Color validColor;
    private Color invalidColor;
    private boolean formulaIsResult = false;
    private KeyAdapter keyListener;

    public CalculatorPanel() {
        this(Locale.getDefault());
    }

    public CalculatorPanel(Locale locale) {
        this.formula = new StringBuilder();
        this.internalFormula = new StringBuilder();
        this.validColor = this.getResult().getForeground();
        this.invalidColor = this.halfContrast(this.validColor, this.getResult().getBackground());
        this.initCharToButton();
        this.initialize();
        this.setLocale(locale);
        this.setPointIsADecimalSeparator(true);
    }

    private Color halfContrast(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    @Override
    public void setLocale(Locale locale) {
        this.map.remove(Character.valueOf(this.decimalSeparator));
        this.decimalSeparator = ((DecimalFormat)NumberFormat.getNumberInstance(locale)).getDecimalFormatSymbols().getDecimalSeparator();
        this.map.put(Character.valueOf(this.decimalSeparator), this.getBtnDecimal());
        this.getBtnDecimal().setText(new String(new char[]{this.decimalSeparator}));
        super.setLocale(locale);
    }

    public void setPointIsADecimalSeparator(boolean always) {
        if (this.decimalSeparator != '.') {
            if (always) {
                this.map.put(Character.valueOf('.'), this.getBtnDecimal());
            } else {
                this.map.remove(Character.valueOf('.'));
            }
        }
    }

    private void initCharToButton() {
        this.addKeyListener(this.getKeyListener());
        this.setFocusable(true);
        this.map = new HashMap<Character, JButton>();
        this.map.put(Character.valueOf('0'), this.getBtn0());
        this.map.put(Character.valueOf('1'), this.getBtn1());
        this.map.put(Character.valueOf('2'), this.getBtn2());
        this.map.put(Character.valueOf('3'), this.getBtn3());
        this.map.put(Character.valueOf('4'), this.getBtn4());
        this.map.put(Character.valueOf('5'), this.getBtn5());
        this.map.put(Character.valueOf('6'), this.getBtn6());
        this.map.put(Character.valueOf('7'), this.getBtn7());
        this.map.put(Character.valueOf('8'), this.getBtn8());
        this.map.put(Character.valueOf('9'), this.getBtn9());
        this.map.put(OPEN, this.getOpenBracket());
        this.map.put(CLOSE, this.getCloseBracket());
        this.map.put(Character.valueOf('C'), this.getBtnClear());
        this.map.put(Character.valueOf('\b'), this.getBtnErase());
        this.map.put(Character.valueOf('\u007f'), this.getBtnErase());
        this.map.put(Character.valueOf('='), this.getBtnEquals());
        this.map.put(Character.valueOf('\n'), this.getBtnEquals());
        this.map.put(PLUS, this.getBtnPlus());
        this.map.put(MINUS, this.getBtnMinus());
        this.map.put(DIVIDE, this.getBtnDivide());
        this.map.put(MULTIPLY, this.getBtnMultiply());
    }

    private KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    JButton btn;
                    int modifiers = e.getModifiers();
                    if ((modifiers & 0xFFFFFFFE) == 0 && (btn = (JButton)CalculatorPanel.this.map.get(Character.valueOf(Character.toUpperCase(e.getKeyChar())))) != null) {
                        btn.doClick();
                    }
                    super.keyTyped(e);
                }
            };
        }
        return this.keyListener;
    }

    private void doChar(char character) {
        if (character == '\n') {
            character = (char)61;
        }
        if (character >= '0' && character <= '9') {
            if (this.formulaIsResult) {
                this.erase();
            }
            this.add(character);
        } else if (character == this.decimalSeparator) {
            if (this.formulaIsResult) {
                this.erase();
            }
            this.add(character);
        } else if (character == PLUS.charValue() || character == MINUS.charValue() || character == MULTIPLY.charValue() || character == DIVIDE.charValue() || character == OPEN.charValue() || character == CLOSE.charValue()) {
            this.add(character);
        } else if (character == '\b' || character == '\u007f') {
            if (this.formula.length() > 0) {
                this.formula.delete(this.formula.length() - 1, this.formula.length());
                this.internalFormula.delete(0, this.internalFormula.length());
                this.internalFormula.append((CharSequence)this.formula);
            }
        } else if (Character.toUpperCase(character) == 'C') {
            this.erase();
        } else if (character == '=' && this.value != null) {
            this.internalFormula.delete(0, this.internalFormula.length());
            this.internalFormula.append(this.value.toString());
            this.formula.delete(0, this.formula.length());
            DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
            format.setMinimumFractionDigits(0);
            int availableWidth = this.getResult().getSize().width - this.getResult().getInsets().left - this.getResult().getInsets().right;
            FontMetrics fontMetrics = this.getResult().getFontMetrics(this.getResult().getFont());
            for (int precision = 0; precision < 20; ++precision) {
                format.setMaximumFractionDigits(precision);
                if (fontMetrics.stringWidth(format.format(this.value)) <= availableWidth) continue;
                if (precision <= 0) break;
                format.setMaximumFractionDigits(precision - 1);
                break;
            }
            this.formula.append(format.format(this.value).replace('.', this.decimalSeparator));
        }
        try {
            String evaluatedString = this.internalFormula.toString().replace(this.decimalSeparator, '.');
            this.value = (BigDecimal)this.evaluator.evaluate(evaluatedString);
        }
        catch (IllegalArgumentException e) {
            this.value = null;
        }
        catch (ArithmeticException e) {
            this.value = null;
        }
        this.formulaIsResult = this.value != null && character == '=';
        this.getResult().setForeground(this.value == null ? this.invalidColor : this.validColor);
        this.getBtnEquals().setEnabled(this.value != null);
        this.getResult().setText(this.formula.toString());
    }

    private void erase() {
        this.internalFormula.delete(0, this.internalFormula.length());
        this.formula.delete(0, this.formula.length());
    }

    private void add(char character) {
        this.formula.append(character);
        this.internalFormula.append(character);
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcResult = new GridBagConstraints();
        gbcResult.insets = new Insets(0, 0, 5, 0);
        gbcResult.weightx = 1.0;
        gbcResult.gridwidth = 0;
        gbcResult.fill = 2;
        gbcResult.anchor = 11;
        gbcResult.gridx = 0;
        gbcResult.gridy = 0;
        this.add((Component)this.getResult(), gbcResult);
        GridBagConstraints gbcOpenBracket = new GridBagConstraints();
        gbcOpenBracket.fill = 2;
        gbcOpenBracket.insets = new Insets(0, 0, 5, 5);
        gbcOpenBracket.weightx = 1.0;
        gbcOpenBracket.gridx = 0;
        gbcOpenBracket.gridy = 1;
        this.add((Component)this.getOpenBracket(), gbcOpenBracket);
        GridBagConstraints gbcCloseBracket = new GridBagConstraints();
        gbcCloseBracket.fill = 2;
        gbcCloseBracket.insets = new Insets(0, 0, 5, 5);
        gbcCloseBracket.weightx = 1.0;
        gbcCloseBracket.gridx = 1;
        gbcCloseBracket.gridy = 1;
        this.add((Component)this.getCloseBracket(), gbcCloseBracket);
        GridBagConstraints gbcBtnErase = new GridBagConstraints();
        gbcBtnErase.fill = 1;
        gbcBtnErase.gridwidth = 2;
        gbcBtnErase.insets = new Insets(0, 0, 5, 5);
        gbcBtnErase.gridx = 2;
        gbcBtnErase.gridy = 1;
        this.add((Component)this.getBtnErase(), gbcBtnErase);
        GridBagConstraints gbcBtnClear = new GridBagConstraints();
        gbcBtnClear.gridheight = 2;
        gbcBtnClear.fill = 1;
        gbcBtnClear.insets = new Insets(0, 0, 5, 0);
        gbcBtnClear.gridx = 4;
        gbcBtnClear.gridy = 1;
        this.add((Component)this.getBtnClear(), gbcBtnClear);
        GridBagConstraints gbcBtnDivide = new GridBagConstraints();
        gbcBtnDivide.fill = 2;
        gbcBtnDivide.insets = new Insets(0, 0, 5, 5);
        gbcBtnDivide.gridx = 3;
        gbcBtnDivide.gridy = 2;
        this.add((Component)this.getBtnDivide(), gbcBtnDivide);
        GridBagConstraints gbcBtnMultiply = new GridBagConstraints();
        gbcBtnMultiply.fill = 2;
        gbcBtnMultiply.insets = new Insets(0, 0, 5, 5);
        gbcBtnMultiply.gridx = 3;
        gbcBtnMultiply.gridy = 3;
        this.add((Component)this.getBtnMultiply(), gbcBtnMultiply);
        GridBagConstraints gbcBtnMinus = new GridBagConstraints();
        gbcBtnMinus.fill = 2;
        gbcBtnMinus.weightx = 1.0;
        gbcBtnMinus.insets = new Insets(0, 0, 5, 5);
        gbcBtnMinus.gridx = 3;
        gbcBtnMinus.gridy = 4;
        this.add((Component)this.getBtnMinus(), gbcBtnMinus);
        GridBagConstraints gbcBtnPlus = new GridBagConstraints();
        gbcBtnPlus.insets = new Insets(0, 0, 0, 5);
        gbcBtnPlus.fill = 2;
        gbcBtnPlus.gridx = 3;
        gbcBtnPlus.gridy = 5;
        this.add((Component)this.getBtnPlus(), gbcBtnPlus);
        GridBagConstraints gbcBtn7 = new GridBagConstraints();
        gbcBtn7.fill = 2;
        gbcBtn7.insets = new Insets(0, 0, 5, 5);
        gbcBtn7.gridx = 0;
        gbcBtn7.gridy = 2;
        this.add((Component)this.getBtn7(), gbcBtn7);
        GridBagConstraints gbcBtn8 = new GridBagConstraints();
        gbcBtn8.fill = 2;
        gbcBtn8.insets = new Insets(0, 0, 5, 5);
        gbcBtn8.gridx = 1;
        gbcBtn8.gridy = 2;
        this.add((Component)this.getBtn8(), gbcBtn8);
        GridBagConstraints gbcBtn9 = new GridBagConstraints();
        gbcBtn9.fill = 2;
        gbcBtn9.insets = new Insets(0, 0, 5, 5);
        gbcBtn9.gridx = 2;
        gbcBtn9.gridy = 2;
        this.add((Component)this.getBtn9(), gbcBtn9);
        GridBagConstraints gbcBtn4 = new GridBagConstraints();
        gbcBtn4.fill = 2;
        gbcBtn4.insets = new Insets(0, 0, 5, 5);
        gbcBtn4.gridx = 0;
        gbcBtn4.gridy = 3;
        this.add((Component)this.getBtn4(), gbcBtn4);
        GridBagConstraints gbcBtn5 = new GridBagConstraints();
        gbcBtn5.fill = 2;
        gbcBtn5.insets = new Insets(0, 0, 5, 5);
        gbcBtn5.weightx = 1.0;
        gbcBtn5.gridx = 1;
        gbcBtn5.gridy = 3;
        this.add((Component)this.getBtn5(), gbcBtn5);
        GridBagConstraints gbcBtn6 = new GridBagConstraints();
        gbcBtn6.fill = 2;
        gbcBtn6.weightx = 1.0;
        gbcBtn6.insets = new Insets(0, 0, 5, 5);
        gbcBtn6.gridx = 2;
        gbcBtn6.gridy = 3;
        this.add((Component)this.getBtn6(), gbcBtn6);
        GridBagConstraints gbcBtn1 = new GridBagConstraints();
        gbcBtn1.fill = 2;
        gbcBtn1.insets = new Insets(0, 0, 5, 5);
        gbcBtn1.gridx = 0;
        gbcBtn1.gridy = 4;
        this.add((Component)this.getBtn1(), gbcBtn1);
        GridBagConstraints gbcBtn2 = new GridBagConstraints();
        gbcBtn2.fill = 2;
        gbcBtn2.insets = new Insets(0, 0, 5, 5);
        gbcBtn2.gridx = 1;
        gbcBtn2.gridy = 4;
        this.add((Component)this.getBtn2(), gbcBtn2);
        GridBagConstraints gbcBtn3 = new GridBagConstraints();
        gbcBtn3.fill = 2;
        gbcBtn3.insets = new Insets(0, 0, 5, 5);
        gbcBtn3.gridx = 2;
        gbcBtn3.gridy = 4;
        this.add((Component)this.getBtn3(), gbcBtn3);
        GridBagConstraints gbcBtn0 = new GridBagConstraints();
        gbcBtn0.fill = 2;
        gbcBtn0.gridwidth = 2;
        gbcBtn0.insets = new Insets(0, 0, 0, 5);
        gbcBtn0.gridx = 0;
        gbcBtn0.gridy = 5;
        this.add((Component)this.getBtn0(), gbcBtn0);
        GridBagConstraints gbcBtnDecimal = new GridBagConstraints();
        gbcBtnDecimal.insets = new Insets(0, 0, 0, 5);
        gbcBtnDecimal.fill = 2;
        gbcBtnDecimal.gridx = 2;
        gbcBtnDecimal.gridy = 5;
        this.add((Component)this.getBtnDecimal(), gbcBtnDecimal);
        GridBagConstraints gbcBtnEquals = new GridBagConstraints();
        gbcBtnEquals.fill = 3;
        gbcBtnEquals.gridheight = 3;
        gbcBtnEquals.gridx = 4;
        gbcBtnEquals.gridy = 3;
        this.add((Component)this.getBtnEquals(), gbcBtnEquals);
    }

    private JTextField getResult() {
        if (this.result == null) {
            this.result = new JTextField();
            this.result.setEditable(false);
            this.result.setHorizontalAlignment(4);
            this.result.addKeyListener(this.getKeyListener());
        }
        return this.result;
    }

    private CalculatorButton getOpenBracket() {
        if (this.openBracket == null) {
            this.openBracket = new CalculatorButton(OPEN.charValue());
        }
        return this.openBracket;
    }

    private CalculatorButton getCloseBracket() {
        if (this.closeBracket == null) {
            this.closeBracket = new CalculatorButton(CLOSE.charValue());
        }
        return this.closeBracket;
    }

    private CalculatorButton getBtn7() {
        if (this.btn7 == null) {
            this.btn7 = new CalculatorButton('7');
            this.btn7.setFocusable(false);
        }
        return this.btn7;
    }

    private CalculatorButton getBtn6() {
        if (this.btn6 == null) {
            this.btn6 = new CalculatorButton('6');
        }
        return this.btn6;
    }

    private CalculatorButton getBtn5() {
        if (this.btn5 == null) {
            this.btn5 = new CalculatorButton('5');
        }
        return this.btn5;
    }

    private CalculatorButton getBtn4() {
        if (this.btn4 == null) {
            this.btn4 = new CalculatorButton('4');
        }
        return this.btn4;
    }

    private CalculatorButton getBtn3() {
        if (this.btn3 == null) {
            this.btn3 = new CalculatorButton('3');
        }
        return this.btn3;
    }

    private CalculatorButton getBtn2() {
        if (this.btn2 == null) {
            this.btn2 = new CalculatorButton('2');
        }
        return this.btn2;
    }

    private CalculatorButton getBtn8() {
        if (this.btn8 == null) {
            this.btn8 = new CalculatorButton('8');
        }
        return this.btn8;
    }

    private CalculatorButton getBtn9() {
        if (this.btn9 == null) {
            this.btn9 = new CalculatorButton('9');
        }
        return this.btn9;
    }

    private CalculatorButton getBtn1() {
        if (this.btn1 == null) {
            this.btn1 = new CalculatorButton('1');
        }
        return this.btn1;
    }

    private CalculatorButton getBtn0() {
        if (this.btn0 == null) {
            this.btn0 = new CalculatorButton('0');
        }
        return this.btn0;
    }

    private CalculatorButton getBtnDecimal() {
        if (this.btnDecimal == null) {
            this.btnDecimal = new CalculatorButton('.');
        }
        return this.btnDecimal;
    }

    private CalculatorButton getBtnPlus() {
        if (this.btnPlus == null) {
            this.btnPlus = new CalculatorButton(PLUS.charValue());
        }
        return this.btnPlus;
    }

    private CalculatorButton getBtnMinus() {
        if (this.btnMinus == null) {
            this.btnMinus = new CalculatorButton(MINUS.charValue());
        }
        return this.btnMinus;
    }

    private CalculatorButton getBtnMultiply() {
        if (this.btnMultiply == null) {
            this.btnMultiply = new CalculatorButton(MULTIPLY.charValue());
        }
        return this.btnMultiply;
    }

    private CalculatorButton getBtnDivide() {
        if (this.btnDivide == null) {
            this.btnDivide = new CalculatorButton(DIVIDE.charValue());
        }
        return this.btnDivide;
    }

    private CalculatorButton getBtnErase() {
        if (this.btnErase == null) {
            this.btnErase = new CalculatorButton('<');
            URL imgURL = this.getClass().getResource("backspace.png");
            if (imgURL != null) {
                this.btnErase.setText("");
                this.btnErase.setIcon(new ImageIcon(imgURL));
            }
            this.btnErase.character = '\b';
        }
        return this.btnErase;
    }

    private CalculatorButton getBtnEquals() {
        if (this.btnEquals == null) {
            this.btnEquals = new CalculatorButton('=');
        }
        return this.btnEquals;
    }

    private CalculatorButton getBtnClear() {
        if (this.btnClear == null) {
            this.btnClear = new CalculatorButton('C');
        }
        return this.btnClear;
    }

    private class CalculatorButton
    extends JButton {
        private char character;

        public CalculatorButton(char name) {
            this.setText(new String(new char[]{name}));
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalculatorPanel.this.doChar(CalculatorButton.this.character);
                }
            });
        }

        @Override
        public void setText(String text) {
            if (text.length() > 0) {
                this.character = text.charAt(0);
            }
            super.setText(text);
        }
    }
}

