/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.currencyconverter;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.ToolsFrame;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.worker.DefaultWorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressFrame;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.Worker;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.currency.ECBCurrencyConverter;
import net.yapbam.currency.YahooCurrencyConverter;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.tools.Messages;
import net.yapbam.gui.tools.currencyconverter.DialogMainPanel;
import net.yapbam.gui.tools.currencyconverter.FileCache;
import net.yapbam.gui.tools.currencyconverter.Source;
import net.yapbam.gui.tools.currencyconverter.SourceManager;
import net.yapbam.util.Portable;

public class Dialog
extends ToolsFrame {
    private DialogMainPanel panel = (DialogMainPanel)this.getContentPane();

    public Dialog(Window owner) {
        super(owner, new DialogMainPanel());
        this.panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("CurrencySource".equals(evt.getPropertyName())) {
                    Dialog.this.setSource((Source)((Object)evt.getNewValue()));
                }
            }
        });
        this.setTitle(Messages.getString("ToolsPlugIn.currencyConverter.title"));
    }

    private void setSource(Source source) {
        final AbstractCurrencyConverter converter = this.getConverter(source);
        SourceManager.setSource(source);
        final Worker<AbstractCurrencyConverter, Void> worker = new Worker<AbstractCurrencyConverter, Void>(){

            @Override
            protected AbstractCurrencyConverter doProcessing() throws Exception {
                converter.update();
                return converter;
            }
        };
        final Window owner = Utils.getOwnerWindow(this);
        WorkInProgressFrame waitFrame = new WorkInProgressFrame(owner, Messages.getString("ToolsPlugIn.currencyConverter.title"), Dialog.ModalityType.APPLICATION_MODAL, worker){
            private static final long serialVersionUID = 1L;

            @Override
            protected WorkInProgressPanel buildProgressPanel() {
                DefaultWorkInProgressPanel panel = (DefaultWorkInProgressPanel)super.buildProgressPanel();
                panel.setMessage(Messages.getString("ToolsPlugin.currencyConverter.wait.message"));
                panel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                return panel;
            }
        };
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state") && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE) && !worker.isCancelled()) {
                    AbstractCurrencyConverter converter = null;
                    try {
                        converter = (AbstractCurrencyConverter)worker.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof IOException) {
                            ErrorManager.INSTANCE.display(owner, null, Messages.getString("ToolsPlugin.currencyConverter.ioErrorMessage"));
                        }
                        String message = Formatter.format(Messages.getString("CurrencyConverterPanel.errorMessage"), e.getCause());
                        ErrorManager.INSTANCE.display(owner, null, message);
                    }
                    if (converter != null) {
                        Dialog.this.setConverter(converter);
                    }
                }
            }
        });
        waitFrame.setVisible(true);
    }

    private AbstractCurrencyConverter getConverter(Source source) {
        try {
            Proxy proxy = Preferences.INSTANCE.getHttpProxy();
            if (Source.ECB.equals((Object)source)) {
                return new ECBCurrencyConverter(proxy, new FileCache(new File(Portable.getDataDirectory(), "ExchangeRates.xml")));
            }
            return new YahooCurrencyConverter(proxy, new FileCache(new File(Portable.getDataDirectory(), "YahooExchangeRates.xml")));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private void setConverter(AbstractCurrencyConverter converter) {
        this.panel.setConverter(converter);
        this.setSize(this.getPreferredSize());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog.this.setLocationRelativeTo(Dialog.this.getOwner());
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setSource(SourceManager.getSource());
        }
        super.setVisible(visible);
    }
}

