/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.currencyconverter;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import com.fathzer.soft.ajlib.swing.widget.NumberWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.currency.CountryCurrencyMap;
import net.yapbam.currency.CurrencyNames;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.tools.Messages;
import net.yapbam.gui.tools.currencyconverter.ConversionRateRenderer;
import net.yapbam.gui.tools.currencyconverter.CurrenciesTableModel;
import net.yapbam.gui.tools.currencyconverter.DialogButtons;
import net.yapbam.gui.tools.currencyconverter.SourceManager;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class DialogMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String KEY_ROOT = "net.yapbam.gui.tools.currencyconverter.";
    private static final String CURRENCY1_KEY = "net.yapbam.gui.tools.currencyconverter.currency1";
    private static final String CURRENCY2_KEY = "net.yapbam.gui.tools.currencyconverter.currency2";
    private ComboBox currency1 = null;
    private ComboBox currency2 = null;
    private NumberWidget amount1 = null;
    private NumberWidget amount2 = null;
    private AbstractCurrencyConverter converter = null;
    private String[] codes;
    private JLabel errField = null;
    private JScrollPane jScrollPane = null;
    private javax.swing.JTable jTable = null;
    private CurrenciesTableModel tableModel;
    private JButton swapButton;
    private DialogButtons bottomPanel;
    private JLayeredPane swapPanel;
    private JLabel extendButton;

    public DialogMainPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.gridwidth = 0;
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints12.weightx = 1.0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.gridy = 2;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 2;
        gridBagConstraints31.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints31.gridy = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText("=");
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridy = 0;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints21.gridx = 3;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints11.gridx = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 3;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints1.gridx = 4;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 3;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridx = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridx = 1;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.add((Component)this.getCurrency1(), gridBagConstraints2);
        this.add((Component)this.getCurrency2(), gridBagConstraints1);
        this.add((Component)this.getAmount1(), gridBagConstraints11);
        this.add((Component)this.getAmount2(), gridBagConstraints21);
        this.add((Component)jLabel, gridBagConstraints31);
        this.add((Component)this.getErrField(), gridBagConstraints6);
        GridBagConstraints gbcSwapPanel = new GridBagConstraints();
        gbcSwapPanel.fill = 1;
        gbcSwapPanel.gridwidth = 0;
        gbcSwapPanel.gridx = 0;
        gbcSwapPanel.gridy = 1;
        this.add((Component)this.getSwapPanel(), gbcSwapPanel);
        this.add((Component)this.getJScrollPane(), gridBagConstraints12);
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.gridwidth = 0;
        gbcBottomPanel.fill = 2;
        gbcBottomPanel.gridx = 0;
        gbcBottomPanel.gridy = 3;
        this.add((Component)this.getBottomPanel(), gbcBottomPanel);
    }

    private JLabel getErrField() {
        if (this.errField == null) {
            this.errField = new JLabel();
            this.errField.setForeground(new Color(255, 64, 64));
        }
        return this.errField;
    }

    private ComboBox getCurrency1() {
        if (this.currency1 == null) {
            this.currency1 = new ComboBox();
            this.currency1.setToolTipText(Messages.getString("CurrencyConverterPanel.origin.toolTip"));
            this.currency1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogMainPanel.this.tableModel != null) {
                        String currencyCode = DialogMainPanel.this.codes[DialogMainPanel.this.currency1.getSelectedIndex()];
                        YapbamState.INSTANCE.put(DialogMainPanel.CURRENCY1_KEY, currencyCode);
                        DialogMainPanel.this.tableModel.setCurrency(currencyCode);
                    }
                    Utils.packColumns(DialogMainPanel.this.getJTable(), 2);
                    DialogMainPanel.this.doConvert();
                }
            });
        }
        return this.currency1;
    }

    private ComboBox getCurrency2() {
        if (this.currency2 == null) {
            this.currency2 = new ComboBox();
            this.currency2.setToolTipText(Messages.getString("CurrencyConverterPanel.destination.toolTip"));
            this.currency2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String currencyCode = DialogMainPanel.this.codes[DialogMainPanel.this.currency2.getSelectedIndex()];
                    int index = DialogMainPanel.this.tableModel.indexOf(currencyCode);
                    if (index < 0) {
                        DialogMainPanel.this.getJTable().clearSelection();
                    } else {
                        index = DialogMainPanel.this.getJTable().convertRowIndexToView(index);
                        DialogMainPanel.this.getJTable().getSelectionModel().setSelectionInterval(index, index);
                        DialogMainPanel.this.getJTable().scrollRectToVisible(DialogMainPanel.this.getJTable().getCellRect(index, 0, true));
                        YapbamState.INSTANCE.put(DialogMainPanel.CURRENCY2_KEY, currencyCode);
                    }
                    DialogMainPanel.this.doConvert();
                }
            });
        }
        return this.currency2;
    }

    private NumberWidget getAmount1() {
        if (this.amount1 == null) {
            this.amount1 = new NumberWidget(LocalizationData.getLocale());
            this.amount1.setColumns(10);
            this.amount1.setToolTipText(Messages.getString("CurrencyConverterPanel.amount.toolTip"));
            this.amount1.setValue(0.0);
            this.amount1.addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.amount1.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DialogMainPanel.this.doConvert();
                }
            });
        }
        return this.amount1;
    }

    private NumberWidget getAmount2() {
        if (this.amount2 == null) {
            this.amount2 = new NumberWidget(LocalizationData.getLocale());
            this.amount2.setColumns(10);
            this.amount2.setToolTipText(Messages.getString("CurrencyConverterPanel.result.toolTip"));
            this.amount2.setEditable(false);
        }
        return this.amount2;
    }

    private void doConvert() {
        Double value = this.amount1.getValue();
        if (value != null && this.codes != null && this.currency1.getSelectedIndex() >= 0 && this.currency2.getSelectedIndex() >= 0) {
            String from = this.codes[this.currency1.getSelectedIndex()];
            String to = this.codes[this.currency2.getSelectedIndex()];
            this.amount2.setValue(this.converter.convert(value, from, to));
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private javax.swing.JTable getJTable() {
        if (this.jTable == null) {
            this.tableModel = new CurrenciesTableModel();
            this.jTable = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent event) {
                    int row = DialogMainPanel.this.jTable.convertRowIndexToModel(DialogMainPanel.this.jTable.rowAtPoint(event.getPoint()));
                    Set<String> countries = CountryCurrencyMap.INSTANCE.getCountries(DialogMainPanel.this.tableModel.getCode(row));
                    if (countries == null) {
                        return super.getToolTipText(event);
                    }
                    ArrayList<String> lines = new ArrayList<String>(countries.size());
                    Iterator<String> iter = countries.iterator();
                    while (iter.hasNext()) {
                        lines.add(new Locale("", iter.next()).getDisplayCountry());
                    }
                    Collections.sort(lines);
                    StringBuilder buf = new StringBuilder();
                    for (String line : lines) {
                        if (buf.length() != 0) {
                            buf.append("<br>");
                        }
                        buf.append(line);
                    }
                    return "<html>" + buf.toString() + "</html>";
                }
            };
            this.getJTable().setRowSorter(new RowSorter<TableModel>(this.getJTable().getModel()));
            this.getJTable().setDefaultRenderer(Double.class, new ConversionRateRenderer());
            Utils.packColumns(this.jTable, 2);
            this.getJTable().setSelectionMode(0);
            this.getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int viewRow;
                    if (!e.getValueIsAdjusting() && (viewRow = DialogMainPanel.this.getJTable().getSelectedRow()) >= 0) {
                        int selectedRow = DialogMainPanel.this.getJTable().convertRowIndexToModel(viewRow);
                        String selectedCode = DialogMainPanel.this.tableModel.getCode(selectedRow);
                        DialogMainPanel.this.getCurrency2().setSelectedItem(CurrencyNames.get(selectedCode));
                    }
                }
            });
        }
        return this.jTable;
    }

    private JButton getSwapButton() {
        if (this.swapButton == null) {
            this.swapButton = new JButton(Utils.createIcon(this.getClass().getResource("swap.png"), (float)this.getFont().getSize() / 32.0f));
            this.swapButton.setFocusable(false);
            this.swapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int old1 = DialogMainPanel.this.getCurrency1().getSelectedIndex();
                    DialogMainPanel.this.getCurrency1().setSelectedIndex(DialogMainPanel.this.getCurrency2().getSelectedIndex());
                    DialogMainPanel.this.getCurrency2().setSelectedIndex(old1);
                }
            });
            this.swapButton.setToolTipText(Messages.getString("CurrencyConverterPanel.swapButton.toolTipText"));
        }
        return this.swapButton;
    }

    void setConverter(AbstractCurrencyConverter converter) {
        this.converter = converter;
        this.getBottomPanel().setConverter(converter);
        this.codes = this.converter.getCurrencies();
        Arrays.sort(this.codes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String w1 = CurrencyNames.get(o1);
                String w2 = CurrencyNames.get(o2);
                return w1.compareToIgnoreCase(w2);
            }
        });
        this.tableModel.setContent(this.converter, this.codes);
        this.getCurrency1().setActionEnabled(false);
        this.getCurrency2().setActionEnabled(false);
        this.getCurrency1().removeAllItems();
        this.getCurrency2().removeAllItems();
        this.getCurrency1().setSelectedItem(null);
        this.getCurrency2().setSelectedItem(null);
        for (int i = 0; i < this.codes.length; ++i) {
            String symbol = CurrencyNames.get(this.codes[i]);
            this.getCurrency1().addItem(symbol);
            this.getCurrency2().addItem(symbol);
        }
        this.getCurrency1().setActionEnabled(true);
        this.getCurrency2().setActionEnabled(true);
        String currencyCode = Currency.getInstance(LocalizationData.getLocale()).getCurrencyCode();
        if (!this.tryToSet(this.getCurrency1(), YapbamState.INSTANCE.get(CURRENCY1_KEY))) {
            this.tryToSet(this.getCurrency1(), currencyCode);
        }
        if (!this.tryToSet(this.getCurrency2(), YapbamState.INSTANCE.get(CURRENCY2_KEY))) {
            this.tryToSet(this.getCurrency2(), currencyCode);
        }
    }

    private boolean tryToSet(JComboBox selector, String currencyCode) {
        int index;
        int n = index = currencyCode == null ? -1 : Arrays.asList(this.codes).indexOf(currencyCode);
        if (index >= 0) {
            selector.setSelectedIndex(index);
        }
        return index >= 0;
    }

    private DialogButtons getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new DialogButtons(SourceManager.getSource());
            this.bottomPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("CurrencySource".equals(evt.getPropertyName())) {
                        DialogMainPanel.this.firePropertyChange("CurrencySource", evt.getOldValue(), evt.getNewValue());
                    }
                }
            });
        }
        return this.bottomPanel;
    }

    private JLayeredPane getSwapPanel() {
        if (this.swapPanel == null) {
            this.swapPanel = new JLayeredPane();
            GridBagLayout gblSwapPanel = new GridBagLayout();
            this.swapPanel.setLayout(gblSwapPanel);
            GridBagConstraints gbcSwapButton = new GridBagConstraints();
            gbcSwapButton.insets = new Insets(0, 0, 5, 0);
            gbcSwapButton.gridwidth = 0;
            gbcSwapButton.gridx = 0;
            gbcSwapButton.gridy = 0;
            this.swapPanel.add((Component)this.getSwapButton(), gbcSwapButton);
            GridBagConstraints gbcExtendButton = new GridBagConstraints();
            gbcExtendButton.insets = new Insets(0, 5, 0, 0);
            gbcExtendButton.weightx = 1.0;
            gbcExtendButton.anchor = 16;
            gbcExtendButton.gridx = 0;
            gbcExtendButton.gridy = 0;
            this.swapPanel.add((Component)this.getExtendButton(), gbcExtendButton);
        }
        return this.swapPanel;
    }

    private JLabel getExtendButton() {
        if (this.extendButton == null) {
            this.extendButton = new JLabel(IconManager.get(IconManager.Name.SPREAD));
            this.extendButton.setVerticalAlignment(3);
            this.getSwapPanel().setLayer(this.extendButton, 1);
            this.extendButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean deploy = DialogMainPanel.this.extendButton.getIcon() != IconManager.get(IconManager.Name.SPREAD);
                    DialogMainPanel.this.extendButton.setIcon(IconManager.get(deploy ? IconManager.Name.SPREAD : IconManager.Name.SPREADABLE));
                    DialogMainPanel.this.getJScrollPane().setVisible(deploy);
                    DialogMainPanel.this.getBottomPanel().setVisible(deploy);
                    Utils.getOwnerWindow(DialogMainPanel.this).pack();
                }
            });
        }
        return this.extendButton;
    }
}

