/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.currencyconverter;

import net.yapbam.gui.Preferences;
import net.yapbam.gui.tools.currencyconverter.CurrencyConverterAction;
import net.yapbam.gui.tools.currencyconverter.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceManager {
    private static final String SOURCE_PREF_KEY = "net.yapbam.gui.tools.currencyConverter.source";
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrencyConverterAction.class);

    public static Source getSource() {
        try {
            String property = Preferences.INSTANCE.getProperty(SOURCE_PREF_KEY, Source.ECB.name());
            Source preferedSource = Source.valueOf(property);
            if (Source.YAHOO.equals((Object)preferedSource)) {
                preferedSource = Source.ECB;
            }
            return preferedSource;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid value in preferences", e);
            return Source.ECB;
        }
    }

    static void setSource(Source source) {
        if (Source.ECB.equals((Object)source)) {
            Preferences.INSTANCE.removeProperty(SOURCE_PREF_KEY);
        } else {
            Preferences.INSTANCE.setProperty(SOURCE_PREF_KEY, source.name());
        }
    }
}

