/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.soft.ajlib.swing.ButtonGroup;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.yapbam.data.BalanceData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.transactiontable.BalanceReportField;

public class BalanceReportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BalanceData balance;
    private BalanceReportField currentBalance;
    private BalanceReportField finalBalance;
    private BalanceReportField checkedBalance;
    private ButtonGroup group;

    public BalanceReportPanel(BalanceData balance) {
        this.balance = balance;
        if (balance != null) {
            balance.addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    BalanceReportPanel.this.updateBalances();
                }
            });
        }
        this.setLayout(new GridLayout(1, 3, 3, 0));
        this.currentBalance = new BalanceReportField(LocalizationData.get("MainFrame.CurrentBalance"));
        this.finalBalance = new BalanceReportField(LocalizationData.get("MainFrame.FinalBalance"));
        this.checkedBalance = new BalanceReportField(LocalizationData.get("MainFrame.CheckedBalance"));
        this.add(this.currentBalance);
        this.add(this.finalBalance);
        this.add(this.checkedBalance);
        this.group = new ButtonGroup();
        this.group.setAutoDeselect(true);
        this.group.add(this.checkedBalance);
        this.group.add(this.currentBalance);
        this.group.add(this.finalBalance);
        this.group.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                BalanceReportPanel.this.updateBalances();
            }
        });
        this.updateBalances();
    }

    private void updateBalances() {
        AbstractButton selected = this.group.getSelected();
        if (this.balance != null) {
            if (selected == null) {
                this.currentBalance.setValue(this.balance.getCurrentBalance(), true);
                this.finalBalance.setValue(this.balance.getFinalBalance(), true);
                this.checkedBalance.setValue(this.balance.getCheckedBalance(), true);
            } else if (selected.equals(this.currentBalance)) {
                this.currentBalance.setValue(this.balance.getCurrentBalance(), true);
                this.finalBalance.setValue(this.balance.getFinalBalance() - this.balance.getCurrentBalance(), false);
                this.checkedBalance.setValue(this.balance.getCheckedBalance() - this.balance.getCurrentBalance(), false);
            } else if (selected.equals(this.finalBalance)) {
                this.currentBalance.setValue(this.balance.getCurrentBalance() - this.balance.getFinalBalance(), false);
                this.finalBalance.setValue(this.balance.getFinalBalance(), true);
                this.checkedBalance.setValue(this.balance.getCheckedBalance() - this.balance.getFinalBalance(), false);
            } else if (selected.equals(this.checkedBalance)) {
                this.currentBalance.setValue(this.balance.getCurrentBalance() - this.balance.getCheckedBalance(), false);
                this.finalBalance.setValue(this.balance.getFinalBalance() - this.balance.getCheckedBalance(), false);
                this.checkedBalance.setValue(this.balance.getCheckedBalance(), true);
            }
        }
        this.currentBalance.setToolTipText(this.getTooltip(this.currentBalance, LocalizationData.get("MainFrame.CurrentBalance.ToolTip")));
        this.finalBalance.setToolTipText(this.getTooltip(this.finalBalance, LocalizationData.get("MainFrame.FinalBalance.ToolTip")));
        this.checkedBalance.setToolTipText(this.getTooltip(this.checkedBalance, LocalizationData.get("MainFrame.CheckedBalance.ToolTip")));
    }

    private String getTooltip(JToggleButton button, String baseTip) {
        StringBuilder b = new StringBuilder("<html>").append(baseTip).append("<br>");
        AbstractButton selected = this.group.getSelected();
        if (selected != null && selected != button) {
            b.append(LocalizationData.get("MainFrame.BalancePanel.Relative.ToolTip")).append("<br><br>");
        }
        b.append(LocalizationData.get(selected == button ? "MainFrame.BalancePanel.Selected.ToolTip" : "MainFrame.BalancePanel.NotSelected.ToolTip"));
        b.append("</html>");
        return b.toString();
    }

    public Selection getSelected() {
        AbstractButton selected = this.group.getSelected();
        if (selected == this.currentBalance) {
            return Selection.CURRENT;
        }
        if (selected == this.checkedBalance) {
            return Selection.CHECKED;
        }
        if (selected == this.finalBalance) {
            return Selection.FINAL;
        }
        return Selection.NONE;
    }

    public void setSelected(Selection selected) {
        BalanceReportField button = null;
        if (selected == Selection.CHECKED) {
            button = this.checkedBalance;
        } else if (selected == Selection.CURRENT) {
            button = this.currentBalance;
        } else if (selected == Selection.FINAL) {
            button = this.finalBalance;
        }
        this.group.setSelected(button);
    }

    public static enum Selection {
        NONE,
        CURRENT,
        FINAL,
        CHECKED;

    }
}

