/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.periodicaltransaction.GeneratePeriodicalTransactionsDialog;

public class GeneratePeriodicalTransactionsAction
extends AbstractAction {
    private GlobalData data;

    public GeneratePeriodicalTransactionsAction(GlobalData data, boolean isMenu) {
        super(LocalizationData.get("MainMenu.Transactions.Periodical"));
        if (isMenu) {
            this.putValue("MnemonicKey", LocalizationData.getChar("MainMenu.Transactions.Periodical.Mnemonic"));
        }
        this.data = data;
        if (data != null) {
            data.addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    if (event instanceof EverythingChangedEvent || event instanceof PeriodicalTransactionsRemovedEvent || event instanceof PeriodicalTransactionsAddedEvent) {
                        GeneratePeriodicalTransactionsAction.this.refreshEnabled();
                    }
                }
            });
            this.refreshEnabled();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new GeneratePeriodicalTransactionsDialog(Utils.getOwnerWindow((Component)e.getSource()), this.data).setVisible(true);
    }

    private void refreshEnabled() {
        boolean enabled = this.data.getPeriodicalTransactionsNumber() != 0;
        this.setEnabled(enabled);
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<html>");
        toolTip.append(LocalizationData.get("MainMenu.Transactions.Periodical.ToolTip"));
        Icon icon = null;
        if (!enabled) {
            toolTip.append("<br>").append(LocalizationData.get("MainMenu.Transactions.Periodical.disabled.tooltip.line1"));
            toolTip.append("<br>").append(Formatter.format(LocalizationData.get("MainMenu.Transactions.Periodical.disabled.tooltip.line2"), LocalizationData.get("PeriodicalTransactionManager.title"), LocalizationData.get("AdministrationPlugIn.title")));
        } else if (this.data.hasPendingPeriodicalTransactions(new Date())) {
            toolTip.append("<br>").append(LocalizationData.get("GeneratePeriodicalTransactionsDialog.alert"));
            icon = IconManager.get(IconManager.Name.ALERT);
        }
        toolTip.append("</html>");
        this.putValue("ShortDescription", toolTip.toString());
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }
}

