/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AccountSelector;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.actions.DeleteTransactionAction;
import net.yapbam.gui.actions.DuplicateTransactionAction;
import net.yapbam.gui.actions.EditTransactionAction;
import net.yapbam.gui.actions.NewTransactionAction;
import net.yapbam.gui.transactiontable.GeneratePeriodicalTransactionsAction;
import net.yapbam.gui.transactiontable.TransactionTable;

public class TransactionEditionButtonsPanel
extends JPanel {
    private FilteredData data;
    private TransactionTable table;
    private AccountSelector accountSelector;
    private JButton newButton;
    private JButton massNewButton;
    private JButton editButton;
    private JButton duplicateButton;
    private JButton deleteButton;

    public TransactionEditionButtonsPanel(TransactionTable table, FilteredData data, AccountSelector selector) {
        this.data = data;
        this.table = table;
        this.accountSelector = selector;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.add((Component)this.getNewButton(), c);
        c.gridx = 1;
        this.add((Component)this.getMassNewButton(), c);
        c.gridx = 2;
        this.add((Component)this.getEditButton(), c);
        c.gridx = 3;
        this.add((Component)this.getDuplicateButton(), c);
        c.gridx = 4;
        c.anchor = 17;
        this.add((Component)this.getDeleteButton(), c);
        GeneratePeriodicalTransactionsAction action = new GeneratePeriodicalTransactionsAction(this.data == null ? null : this.data.getGlobalData(), false);
        JButton periodicalTransactionsButton = new JButton(action);
        c.gridx = 5;
        c.weightx = 1.0;
        c.anchor = 13;
        this.add((Component)periodicalTransactionsButton, c);
    }

    protected JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton(new NewTransactionAction(this.data, this.getTable(), false, this.accountSelector));
            this.newButton.setText(LocalizationData.get("GenericButton.new"));
        }
        return this.newButton;
    }

    protected JButton getMassNewButton() {
        if (this.massNewButton == null) {
            this.massNewButton = new JButton(new NewTransactionAction(this.data, this.getTable(), true, this.accountSelector));
            this.massNewButton.setText(LocalizationData.get("MainMenu.Transactions.NewMultiple"));
        }
        return this.massNewButton;
    }

    protected JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(new EditTransactionAction(this.getTable()));
            this.editButton.setText(LocalizationData.get("GenericButton.edit"));
        }
        return this.editButton;
    }

    protected JButton getDuplicateButton() {
        if (this.duplicateButton == null) {
            this.duplicateButton = new JButton(new DuplicateTransactionAction(this.getTable()));
            this.duplicateButton.setText(LocalizationData.get("GenericButton.duplicate"));
        }
        return this.duplicateButton;
    }

    protected JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(new DeleteTransactionAction(this.getTable()));
            this.deleteButton.setText(LocalizationData.get("GenericButton.delete"));
        }
        return this.deleteButton;
    }

    private TransactionTable getTable() {
        return this.table;
    }
}

