/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.soft.ajlib.swing.table.JTableSelector;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.Font;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.transactiontable.AmountRenderer;
import net.yapbam.gui.transactiontable.DateRenderer;
import net.yapbam.gui.transactiontable.ObjectRenderer;
import net.yapbam.gui.transactiontable.SpreadState;
import net.yapbam.gui.transactiontable.SpreadStateRenderer;
import net.yapbam.gui.transactiontable.SpreadableMouseAdapter;
import net.yapbam.gui.transactiontable.TableSettings;
import net.yapbam.gui.transactiontable.TransactionTablePainter;
import net.yapbam.gui.transactiontable.TransactionsTableModel;
import net.yapbam.gui.util.DoubleArrayComparator;
import net.yapbam.gui.util.FriendlyTable;
import net.yapbam.gui.util.LinkEnabler;
import net.yapbam.gui.util.PaintedTable;
import net.yapbam.gui.util.TablePainter;

public class TransactionTable
extends FriendlyTable
implements TransactionSelector,
PaintedTable {
    private static final long serialVersionUID = 1L;
    private Transaction[] lastSelected;
    private FilteredData data;
    private TablePainter painter = new TransactionTablePainter(){
        private static final long serialVersionUID = 1L;

        @Override
        public void setRowLook(Component renderer, JTable table, int row, boolean isSelected) {
            super.setRowLook(renderer, table, row, isSelected);
            boolean isChecked = TransactionTable.this.data.getTransaction(row).isChecked();
            Font font = renderer.getFont().deriveFont(isChecked ? 2 : 1);
            renderer.setFont(font);
        }

        @Override
        public int getAlignment(int column) {
            TableSettings settings = ((TransactionsTableModel)TransactionTable.this.getModel()).getTableSettings();
            if (column == settings.getAmountColumn() || column == settings.getReceiptColumn() || column == settings.getExpenseColumn()) {
                return 4;
            }
            if (column == settings.getAccountColumn() || column == settings.getDescriptionColumn()) {
                return 2;
            }
            return 0;
        }
    };

    public TransactionTable(FilteredData data) {
        this.data = data;
        TransactionsTableModel model = new TransactionsTableModel(this, data);
        this.setModel(model);
        this.setDefaultRenderer(Date.class, new DateRenderer());
        this.setDefaultRenderer(double[].class, new AmountRenderer());
        this.setDefaultRenderer(SpreadState.class, new SpreadStateRenderer());
        this.setDefaultRenderer(Object.class, new ObjectRenderer());
        LinkEnabler.enable(this, model.getTableSettings().getDescriptionColumn(), model.getTableSettings().getCommentColumn());
        this.getSelectionModel().setSelectionMode(0);
        this.addMouseListener(new SpreadableMouseAdapter());
        RowSorter<TransactionsTableModel> sorter = new RowSorter<TransactionsTableModel>(model);
        TableSettings settings = model.getTableSettings();
        DoubleArrayComparator doubleArrayComparator = new DoubleArrayComparator();
        if (settings.getAmountColumn() != -1) {
            sorter.setComparator(settings.getAmountColumn(), doubleArrayComparator);
        }
        if (settings.getReceiptColumn() != -1) {
            sorter.setComparator(settings.getReceiptColumn(), doubleArrayComparator);
        }
        if (settings.getExpenseColumn() != -1) {
            sorter.setComparator(settings.getExpenseColumn(), doubleArrayComparator);
        }
        sorter.setComparator(4, new Comparator<double[]>(){

            @Override
            public int compare(double[] o1, double[] o2) {
                return (int)Math.signum(o1[0] - o2[0]);
            }
        });
        this.setRowSorter(sorter);
        this.lastSelected = null;
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Transaction[] selectedTransactions;
                if (!e.getValueIsAdjusting() && !NullUtils.areEquals(selectedTransactions = TransactionTable.this.getSelectedTransactions(), TransactionTable.this.lastSelected)) {
                    TransactionTable.this.firePropertyChange("selectedTransaction", TransactionTable.this.lastSelected, selectedTransactions);
                    TransactionTable.access$002(TransactionTable.this, selectedTransactions);
                }
            }
        });
    }

    @Override
    public TablePainter getPainter() {
        return this.painter;
    }

    @Override
    public Transaction[] getSelectedTransactions() {
        int[] indexes = this.getSelectedRows();
        Transaction[] result = new Transaction[indexes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.data.getTransaction(this.convertRowIndexToModel(indexes[i]));
        }
        return result;
    }

    @Override
    public void setSelectedTransactions(Transaction[] transactions) {
        JTableSelector<Transaction> selector = new JTableSelector<Transaction>((JTable)this){

            @Override
            public int getModelIndex(Transaction transaction) {
                return TransactionTable.this.data == null ? -1 : TransactionTable.this.data.indexOf(transaction);
            }
        };
        selector.setSelected(transactions);
    }

    public GlobalData getGlobalData() {
        return this.data == null ? null : this.data.getGlobalData();
    }

    @Override
    public FilteredData getFilteredData() {
        return this.data;
    }

    public void scrollToLastLine() {
        this.scrollRectToVisible(this.getCellRect(this.getRowCount() - 1, 0, true));
    }

    static /* synthetic */ Transaction[] access$002(TransactionTable x0, Transaction[] x1) {
        x0.lastSelected = x1;
        return x1;
    }
}

