/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.soft.ajlib.swing.table.JTableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AccountSelector;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.actions.ConvertToPeriodicalTransactionAction;
import net.yapbam.gui.transactiontable.BalanceReportPanel;
import net.yapbam.gui.transactiontable.SpreadableTableModel;
import net.yapbam.gui.transactiontable.StatPanel;
import net.yapbam.gui.transactiontable.TransactionEditionButtonsPanel;
import net.yapbam.gui.transactiontable.TransactionTable;
import net.yapbam.gui.util.FriendlyTable;
import net.yapbam.gui.widget.JLabelMenu;

public class TransactionsPlugInPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FilteredData data;
    private AccountSelector accountSelector;
    private TransactionTable transactionTable;
    private TransactionEditionButtonsPanel buttons;
    private BalanceReportPanel balances;

    public TransactionsPlugInPanel(FilteredData data, AccountSelector accountSelector) {
        this.data = data;
        this.accountSelector = accountSelector;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.getTransactionTable(), 22, 31);
        this.add((Component)this.getMenusPanel(), "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.getSouthPanel(), "South");
    }

    private JPanel getSouthPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints cButtons = new GridBagConstraints();
        cButtons.fill = 2;
        cButtons.gridy = 1;
        cButtons.weightx = 1.0;
        result.add((Component)this.getButtons(), cButtons);
        GridBagConstraints cBalance = new GridBagConstraints();
        cBalance.fill = 2;
        cBalance.weightx = 1.0;
        cBalance.gridy = 2;
        result.add((Component)this.getBalanceReportPanel(), cBalance);
        GridBagConstraints cStat = new GridBagConstraints();
        cStat.fill = 2;
        cStat.weightx = 1.0;
        cStat.gridy = 0;
        result.add((Component)new StatPanel(this.data), cStat);
        return result;
    }

    private JPanel getMenusPanel() {
        JPanel menus = new JPanel(new BorderLayout());
        menus.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        menus.setBackground(new Color(240, 240, 240));
        JLabelMenu deploy = new JLabelMenu(LocalizationData.get("MainFrame.ShowSubtransactions")){

            @Override
            protected void fillPopUp(JPopupMenu popup) {
                popup.add(new DeploySubTransactionsAction(LocalizationData.get("MainFrame.ShowSubtransactions.All"), true));
                popup.add(new DeploySubTransactionsAction(LocalizationData.get("MainFrame.ShowSubtransactions.None"), false));
            }
        };
        deploy.setToolTipText(LocalizationData.get("MainFrame.ShowSubtransactions.ToolTip"));
        EmptyBorder border = new EmptyBorder(0, 5, 0, 5);
        deploy.setBorder(border);
        menus.add((Component)deploy, "West");
        FriendlyTable.ShowHideColumsMenu columns = new FriendlyTable.ShowHideColumsMenu(this.getTransactionTable(), LocalizationData.get("MainFrame.showColumns"));
        columns.setToolTipText(LocalizationData.get("MainFrame.showColumns.ToolTip"));
        columns.setBorder(border);
        menus.add((Component)columns, "East");
        return menus;
    }

    private TransactionEditionButtonsPanel getButtons() {
        if (this.buttons == null) {
            this.buttons = new TransactionEditionButtonsPanel(this.getTransactionTable(), this.data, this.accountSelector);
        }
        return this.buttons;
    }

    TransactionTable getTransactionTable() {
        if (this.transactionTable == null) {
            this.transactionTable = new TransactionTable(this.data);
            Action editAction = this.getButtons().getEditButton().getAction();
            JTableListener listener = new JTableListener(new Action[]{editAction, this.getButtons().getDuplicateButton().getAction(), this.getButtons().getDeleteButton().getAction(), null, new ConvertToPeriodicalTransactionAction(this.transactionTable)}, editAction);
            this.transactionTable.addMouseListener(listener);
        }
        return this.transactionTable;
    }

    BalanceReportPanel getBalanceReportPanel() {
        if (this.balances == null) {
            this.balances = new BalanceReportPanel(this.data == null ? null : this.data.getBalanceData());
        }
        return this.balances;
    }

    private final class DeploySubTransactionsAction
    extends AbstractAction {
        private boolean spread;

        private DeploySubTransactionsAction(String name, boolean spread) {
            super(name);
            this.spread = spread;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpreadableTableModel model = (SpreadableTableModel)((Object)TransactionsPlugInPanel.this.getTransactionTable().getModel());
            for (int i = 0; i < TransactionsPlugInPanel.this.getTransactionTable().getRowCount(); ++i) {
                if (!model.isSpreadable(i)) continue;
                model.setSpread(i, this.spread);
                int viewRow = TransactionsPlugInPanel.this.getTransactionTable().convertRowIndexToView(i);
                if (this.spread) {
                    TransactionsPlugInPanel.this.getTransactionTable().setRowHeight(viewRow, TransactionsPlugInPanel.this.getTransactionTable().getRowHeight() * model.getSpreadLines(i));
                    continue;
                }
                TransactionsPlugInPanel.this.getTransactionTable().setRowHeight(viewRow, TransactionsPlugInPanel.this.getTransactionTable().getRowHeight());
            }
        }
    }
}

