/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.soft.ajlib.swing.table.JTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.transactiontable.BalanceReportField;
import net.yapbam.gui.transactiontable.ObjectRenderer;
import net.yapbam.gui.util.PaintedTable;
import net.yapbam.gui.util.TablePainter;

public class TransactionsPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private BalanceReportField positiveBalanceReport = null;
    private BalanceReportField negativeBalanceReport = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JButton setTodefault = null;
    private JPanel jPanel1 = null;
    private JCheckBox separeCommentChkBx;
    private JCheckBox separateExpenseReceiptChckbx;
    private JTable table;
    private JCheckBox chckBxCustomBackground;
    private JButton btnExpense;
    private JButton btnReceipt;
    private JScrollPane scrollPane;
    private MyTableModel tableModel;
    private Color expenseColor;
    private Color receiptColor;
    private boolean initialSeparateCommentState = TransactionsPreferencePanel.isCommentSeparatedFromDescription();
    private boolean initialSeparateReceiptExpense = TransactionsPreferencePanel.isReceiptSeparatedFromExpense();
    static String NEGATIVE_KEY = "net.yapbam.balanceReport.negative";
    static String POSITIVE_KEY = "net.yapbam.balanceReport.positive";
    private static String CUSTOMIZED_BACKGROUND_KEY = "net.yapbam.transactionTable.customized.background";
    static String EXPENSE_BACKGROUND_COLOR_KEY = "net.yapbam.transactionTable.expense.color";
    static String RECEIPT_BACKGROUND_COLOR_KEY = "net.yapbam.transactionTable.receipt.color";
    private static final String SEPARATE_RECEIPT_EXPENSE = "net.yapbam.transactionTable.separateReceiptAndExpense";
    private static final String SEPARATE_COMMENT = "net.yapbam.transactionTable.separateDescriptionAndComment";
    static final Color DEFAULT_POSITIVE = new Color(0, 200, 0);
    static final Color DEFAULT_NEGATIVE = Color.RED;
    static final Color DEFAULT_CASHIN = new Color(240, 255, 240);
    static final Color DEFAULT_CASHOUT = new Color(255, 240, 240);

    public TransactionsPreferencePanel() {
        Color[] colors = TransactionsPreferencePanel.getBackgroundColors();
        this.expenseColor = colors[0] != null ? colors[0] : DEFAULT_CASHOUT;
        this.receiptColor = colors[1] != null ? colors[1] : DEFAULT_CASHIN;
        this.initialize();
    }

    public static boolean isCommentSeparatedFromDescription() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(SEPARATE_COMMENT));
    }

    public static boolean isReceiptSeparatedFromExpense() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(SEPARATE_RECEIPT_EXPENSE));
    }

    public static boolean isCustomBackgroundColors() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(CUSTOMIZED_BACKGROUND_KEY, "true"));
    }

    public static Color[] getBackgroundColors() {
        Color receipt = null;
        Color expense = null;
        if (TransactionsPreferencePanel.isCustomBackgroundColors()) {
            try {
                receipt = new Color(Integer.parseInt(Preferences.INSTANCE.getProperty(RECEIPT_BACKGROUND_COLOR_KEY)));
                expense = new Color(Integer.parseInt(Preferences.INSTANCE.getProperty(EXPENSE_BACKGROUND_COLOR_KEY)));
            }
            catch (NumberFormatException e) {
                receipt = DEFAULT_CASHIN;
                expense = DEFAULT_CASHOUT;
            }
        }
        return new Color[]{expense, receipt};
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 11;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJPanel(), gridBagConstraints4);
        GridBagConstraints gbcSetTodefault = new GridBagConstraints();
        gbcSetTodefault.anchor = 14;
        gbcSetTodefault.weighty = 1.0;
        gbcSetTodefault.weightx = 1.0;
        gbcSetTodefault.insets = new Insets(0, 0, 5, 5);
        gbcSetTodefault.gridx = 0;
        gbcSetTodefault.gridy = 2;
        this.add((Component)this.getSetTodefault(), gbcSetTodefault);
        this.add((Component)this.getJPanel1(), gridBagConstraints6);
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("MainFrame.Transactions.Preferences.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("MainFrame.Transactions.Preferences.tooltip");
    }

    @Override
    public boolean updatePreferences() {
        boolean bckHasChange;
        Color positive = this.positiveBalanceReport.getForeground();
        Color negative = this.negativeBalanceReport.getForeground();
        Color[] oldColors = TransactionsPreferencePanel.getBackgroundColors();
        boolean bl = bckHasChange = oldColors[0] != null && (!oldColors[1].equals(this.receiptColor) || !oldColors[0].equals(this.expenseColor));
        if (positive.equals(BalanceReportField.POSITIVE_COLOR) && negative.equals(BalanceReportField.NEGATIVE_COLOR) && this.separeCommentChkBx.isSelected() == this.initialSeparateCommentState && this.getSeparateExpenseReceiptChckbx().isSelected() == this.initialSeparateReceiptExpense && this.getChckBxCustomBackground().isSelected() == (oldColors[0] != null) && !bckHasChange) {
            return false;
        }
        BalanceReportField.POSITIVE_COLOR = positive;
        BalanceReportField.NEGATIVE_COLOR = negative;
        Preferences.INSTANCE.setProperty(POSITIVE_KEY, Integer.toString(positive.getRGB()));
        Preferences.INSTANCE.setProperty(NEGATIVE_KEY, Integer.toString(negative.getRGB()));
        Preferences.INSTANCE.setProperty(SEPARATE_RECEIPT_EXPENSE, Boolean.toString(this.getSeparateExpenseReceiptChckbx().isSelected()));
        Preferences.INSTANCE.setProperty(SEPARATE_COMMENT, Boolean.toString(this.separeCommentChkBx.isSelected()));
        Preferences.INSTANCE.setProperty(CUSTOMIZED_BACKGROUND_KEY, Boolean.toString(this.getChckBxCustomBackground().isSelected()));
        if (this.getChckBxCustomBackground().isSelected()) {
            Preferences.INSTANCE.setProperty(EXPENSE_BACKGROUND_COLOR_KEY, Integer.toString(this.expenseColor.getRGB()));
            Preferences.INSTANCE.setProperty(RECEIPT_BACKGROUND_COLOR_KEY, Integer.toString(this.receiptColor.getRGB()));
        } else {
            Preferences.INSTANCE.removeProperty(EXPENSE_BACKGROUND_COLOR_KEY);
            Preferences.INSTANCE.removeProperty(RECEIPT_BACKGROUND_COLOR_KEY);
        }
        return true;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.negativeBalanceReport = new BalanceReportField(LocalizationData.get("MainFrame.Transactions.Preferences.balanceSummary.negativeSample"));
            this.negativeBalanceReport.setValue(-100.0, true);
            this.positiveBalanceReport = new BalanceReportField(LocalizationData.get("MainFrame.Transactions.Preferences.balanceSummary.positiveSample"));
            this.positiveBalanceReport.setValue(100.0, true);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createTitledBorder(LocalizationData.get("MainFrame.Transactions.Preferences.balanceSummary.title")));
            this.jPanel.add((Component)this.positiveBalanceReport, gridBagConstraints);
            this.jPanel.add((Component)this.negativeBalanceReport, gridBagConstraints1);
            this.jPanel.add((Component)this.getJButton(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJButton1(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(LocalizationData.get("MainFrame.Transactions.Preferences.changeColor"));
            this.jButton.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.changeColor.tooltip"));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = TransactionsPreferencePanel.this.localizedColorChooser(TransactionsPreferencePanel.this.positiveBalanceReport.getForeground());
                    if (c != null) {
                        TransactionsPreferencePanel.this.positiveBalanceReport.setForeground(c);
                    }
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(LocalizationData.get("MainFrame.Transactions.Preferences.changeColor"));
            this.jButton1.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.changeColor.tooltip"));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = TransactionsPreferencePanel.this.localizedColorChooser(TransactionsPreferencePanel.this.negativeBalanceReport.getForeground());
                    if (c != null) {
                        TransactionsPreferencePanel.this.negativeBalanceReport.setForeground(c);
                    }
                }
            });
        }
        return this.jButton1;
    }

    private JButton getSetTodefault() {
        if (this.setTodefault == null) {
            this.setTodefault = new JButton();
            this.setTodefault.setText(LocalizationData.get("MainFrame.Transactions.Preferences.setDefault"));
            this.setTodefault.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.setDefault.tooltip"));
            this.setTodefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransactionsPreferencePanel.this.negativeBalanceReport.setForeground(DEFAULT_NEGATIVE);
                    TransactionsPreferencePanel.this.positiveBalanceReport.setForeground(DEFAULT_POSITIVE);
                    TransactionsPreferencePanel.this.separeCommentChkBx.setSelected(false);
                    TransactionsPreferencePanel.this.getChckBxCustomBackground().setSelected(true);
                    TransactionsPreferencePanel.this.expenseColor = DEFAULT_CASHOUT;
                    TransactionsPreferencePanel.this.receiptColor = DEFAULT_CASHIN;
                    TransactionsPreferencePanel.this.getTableModel().refresh();
                }
            });
        }
        return this.setTodefault;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setBorder(null);
            GridBagLayout gblJPanel1 = new GridBagLayout();
            this.jPanel1.setLayout(gblJPanel1);
            GridBagConstraints gbcSepareCommentChkBx = new GridBagConstraints();
            gbcSepareCommentChkBx.weightx = 1.0;
            gbcSepareCommentChkBx.anchor = 17;
            gbcSepareCommentChkBx.gridwidth = 0;
            gbcSepareCommentChkBx.insets = new Insets(5, 5, 5, 0);
            gbcSepareCommentChkBx.gridx = 0;
            gbcSepareCommentChkBx.gridy = 0;
            this.jPanel1.add((Component)this.getSeparateCommentChkBx(), gbcSepareCommentChkBx);
            GridBagConstraints gbcSeparateExpenseReceiptChckbx = new GridBagConstraints();
            gbcSeparateExpenseReceiptChckbx.gridwidth = 0;
            gbcSeparateExpenseReceiptChckbx.anchor = 17;
            gbcSeparateExpenseReceiptChckbx.insets = new Insets(0, 5, 0, 5);
            gbcSeparateExpenseReceiptChckbx.gridx = 0;
            gbcSeparateExpenseReceiptChckbx.gridy = 1;
            this.jPanel1.add((Component)this.getSeparateExpenseReceiptChckbx(), gbcSeparateExpenseReceiptChckbx);
            GridBagConstraints gbcChckBxCustomBackground = new GridBagConstraints();
            gbcChckBxCustomBackground.gridwidth = 0;
            gbcChckBxCustomBackground.anchor = 17;
            gbcChckBxCustomBackground.insets = new Insets(5, 5, 5, 0);
            gbcChckBxCustomBackground.gridx = 0;
            gbcChckBxCustomBackground.gridy = 2;
            this.jPanel1.add((Component)this.getChckBxCustomBackground(), gbcChckBxCustomBackground);
            GridBagConstraints gbcScrollPane = new GridBagConstraints();
            gbcScrollPane.weightx = 1.0;
            gbcScrollPane.fill = 2;
            gbcScrollPane.gridheight = 2;
            gbcScrollPane.insets = new Insets(0, 0, 0, 5);
            gbcScrollPane.gridx = 0;
            gbcScrollPane.gridy = 3;
            this.jPanel1.add((Component)this.getScrollPane(), gbcScrollPane);
            GridBagConstraints gbcBtnReceipt = new GridBagConstraints();
            gbcBtnReceipt.fill = 2;
            gbcBtnReceipt.anchor = 17;
            gbcBtnReceipt.insets = new Insets(0, 0, 0, 5);
            gbcBtnReceipt.gridx = 1;
            gbcBtnReceipt.gridy = 4;
            this.jPanel1.add((Component)this.getBtnReceipt(), gbcBtnReceipt);
            GridBagConstraints gbcBtnExpense = new GridBagConstraints();
            gbcBtnExpense.fill = 2;
            gbcBtnExpense.insets = new Insets(0, 0, 5, 5);
            gbcBtnExpense.anchor = 17;
            gbcBtnExpense.gridx = 1;
            gbcBtnExpense.gridy = 3;
            this.jPanel1.add((Component)this.getBtnExpense(), gbcBtnExpense);
        }
        return this.jPanel1;
    }

    private JCheckBox getSeparateCommentChkBx() {
        if (this.separeCommentChkBx == null) {
            this.separeCommentChkBx = new JCheckBox();
            this.separeCommentChkBx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TransactionsPreferencePanel.this.getTableModel().refresh();
                }
            });
            this.separeCommentChkBx.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.commentDisplay.tooltip"));
            this.separeCommentChkBx.setText(LocalizationData.get("MainFrame.Transactions.Preferences.commentDisplay"));
            this.separeCommentChkBx.setSelected(this.initialSeparateCommentState);
        }
        return this.separeCommentChkBx;
    }

    private Color localizedColorChooser(Color initialColor) {
        return JColorChooser.showDialog(this.jButton, LocalizationData.get("MainFrame.Transactions.Preferences.ChooseColorDialog.title"), initialColor);
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new MyTable();
        }
        return this.table;
    }

    private MyTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new MyTableModel();
        }
        return this.tableModel;
    }

    private JCheckBox getChckBxCustomBackground() {
        if (this.chckBxCustomBackground == null) {
            this.chckBxCustomBackground = new JCheckBox();
            this.chckBxCustomBackground.setText(LocalizationData.get("MainFrame.Transactions.Preferences.customBackground.title"));
            this.chckBxCustomBackground.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.customBackground.tooltip"));
            this.chckBxCustomBackground.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TransactionsPreferencePanel.this.getTableModel().refresh();
                    TransactionsPreferencePanel.this.getBtnExpense().setEnabled(TransactionsPreferencePanel.this.getChckBxCustomBackground().isSelected());
                    TransactionsPreferencePanel.this.getBtnReceipt().setEnabled(TransactionsPreferencePanel.this.getChckBxCustomBackground().isSelected());
                }
            });
            this.chckBxCustomBackground.setSelected(TransactionsPreferencePanel.isCustomBackgroundColors());
        }
        return this.chckBxCustomBackground;
    }

    private JButton getBtnExpense() {
        if (this.btnExpense == null) {
            this.btnExpense = new JButton(LocalizationData.get("MainFrame.Transactions.Preferences.changeExpenseBackground.title"));
            this.btnExpense.setEnabled(false);
            this.btnExpense.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.changeExpenseBackground.tooltip"));
            this.btnExpense.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = TransactionsPreferencePanel.this.localizedColorChooser(TransactionsPreferencePanel.this.expenseColor);
                    if (c != null) {
                        TransactionsPreferencePanel.this.expenseColor = c;
                        TransactionsPreferencePanel.this.getTableModel().refresh();
                    }
                }
            });
        }
        return this.btnExpense;
    }

    private JButton getBtnReceipt() {
        if (this.btnReceipt == null) {
            this.btnReceipt = new JButton(LocalizationData.get("MainFrame.Transactions.Preferences.changeReceiptBackground.title"));
            this.btnReceipt.setEnabled(false);
            this.btnReceipt.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.changeReceiptBackground.tooltip"));
            this.btnReceipt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = TransactionsPreferencePanel.this.localizedColorChooser(TransactionsPreferencePanel.this.receiptColor);
                    if (c != null) {
                        TransactionsPreferencePanel.this.receiptColor = c;
                        TransactionsPreferencePanel.this.getTableModel().refresh();
                    }
                }
            });
        }
        return this.btnReceipt;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getTable());
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        return this.scrollPane;
    }

    private JCheckBox getSeparateExpenseReceiptChckbx() {
        if (this.separateExpenseReceiptChckbx == null) {
            this.separateExpenseReceiptChckbx = new JCheckBox(LocalizationData.get("MainFrame.Transactions.Preferences.separateExpenseReceipt"));
            this.separateExpenseReceiptChckbx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TransactionsPreferencePanel.this.getTableModel().refresh();
                }
            });
            this.separateExpenseReceiptChckbx.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.separateExpenseReceipt.tooltip"));
            this.separateExpenseReceiptChckbx.setSelected(this.initialSeparateReceiptExpense);
        }
        return this.separateExpenseReceiptChckbx;
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        private int getCommentColumnIndex() {
            return TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected() ? 1 : -1;
        }

        private int getReceiptColumnIndex() {
            if (!TransactionsPreferencePanel.this.getSeparateExpenseReceiptChckbx().isSelected()) {
                return -1;
            }
            return TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected() ? 2 : 1;
        }

        private int getExpenseColumnIndex() {
            if (!TransactionsPreferencePanel.this.getSeparateExpenseReceiptChckbx().isSelected()) {
                return -1;
            }
            return TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected() ? 3 : 2;
        }

        private boolean isExpense(int rowIndex) {
            return rowIndex == 0;
        }

        @Override
        public int getRowCount() {
            return 2;
        }

        @Override
        public int getColumnCount() {
            int nb = 2;
            if (TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected()) {
                ++nb;
            }
            if (TransactionsPreferencePanel.this.getSeparateExpenseReceiptChckbx().isSelected()) {
                ++nb;
            }
            return nb;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                String result;
                String string = result = this.isExpense(row) ? LocalizationData.get("MainFrame.Transactions.Preferences.expenseSample") : LocalizationData.get("MainFrame.Transactions.Preferences.receiptSample");
                if (!TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected()) {
                    result = result + " (" + LocalizationData.get("Transaction.comment") + ")";
                }
                return result;
            }
            if (column == this.getCommentColumnIndex()) {
                return LocalizationData.get("Transaction.comment");
            }
            if (column == this.getReceiptColumnIndex()) {
                return this.isExpense(row) ? "" : "100";
            }
            if (column == this.getExpenseColumnIndex()) {
                return this.isExpense(row) ? "-100" : "";
            }
            return this.isExpense(row) ? "-100" : "100";
        }

        public void refresh() {
            this.fireTableStructureChanged();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return LocalizationData.get("Transaction.description");
            }
            if (column == this.getCommentColumnIndex()) {
                return LocalizationData.get("Transaction.comment");
            }
            if (column == this.getReceiptColumnIndex()) {
                return LocalizationData.get("StatementView.receipt");
            }
            if (column == this.getExpenseColumnIndex()) {
                return LocalizationData.get("StatementView.debt");
            }
            return LocalizationData.get("Transaction.amount");
        }
    }

    class MyTable
    extends JTable
    implements PaintedTable {
        private static final long serialVersionUID = 1L;
        private TablePainter painter;

        MyTable() {
            super(TransactionsPreferencePanel.this.getTableModel());
            this.painter = new TablePainter(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setRowLook(Component renderer, javax.swing.JTable table, int row, boolean isSelected) {
                    renderer.setForeground(table.getForeground());
                    if (TransactionsPreferencePanel.this.getChckBxCustomBackground().isSelected()) {
                        renderer.setBackground(((MyTableModel)table.getModel()).isExpense(row) ? TransactionsPreferencePanel.this.expenseColor : TransactionsPreferencePanel.this.receiptColor);
                    } else {
                        renderer.setBackground(table.getBackground());
                    }
                }

                @Override
                public int getAlignment(int column) {
                    int firstNumberColumn = TransactionsPreferencePanel.this.getSeparateCommentChkBx().isSelected() ? 2 : 1;
                    return column < firstNumberColumn ? 2 : 4;
                }
            };
            this.setPreferredScrollableViewportSize(new Dimension(500, this.getRowCount() * this.getRowHeight()));
            this.setDefaultRenderer(Object.class, new ObjectRenderer());
        }

        @Override
        public TablePainter getPainter() {
            return this.painter;
        }
    }
}

