/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.CategoryPropertyChangedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.transactiontable.GenericTransactionTableModel;
import net.yapbam.gui.transactiontable.SpreadState;
import net.yapbam.gui.transactiontable.TableSettings;
import net.yapbam.gui.transactiontable.TransactionTable;
import net.yapbam.gui.transactiontable.TransactionTableUtils;

class TransactionsTableModel
extends GenericTransactionTableModel
implements DataListener {
    private static final long serialVersionUID = 1L;
    private transient DateFormat dateFormater;
    private transient FilteredData data;
    private TableSettings settings = new TableSettings();

    TransactionsTableModel(TransactionTable table, FilteredData data) {
        this.data = data;
        if (data != null) {
            data.addListener(this);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.settings.getSpreadColumn()) {
            return SpreadState.class;
        }
        if (columnIndex == this.settings.getDateColumn() || columnIndex == this.settings.getValueDateColumn()) {
            return Date.class;
        }
        if (columnIndex == this.settings.getAmountColumn() || columnIndex == this.settings.getReceiptColumn() || columnIndex == this.settings.getExpenseColumn()) {
            return double[].class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.settings.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.settings.getSpreadColumn()) {
            return LocalizationData.get("Transaction.0");
        }
        if (columnIndex == this.settings.getAccountColumn()) {
            return LocalizationData.get("Transaction.account");
        }
        if (columnIndex == this.settings.getDateColumn()) {
            return LocalizationData.get("Transaction.date");
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return LocalizationData.get("Transaction.description");
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return LocalizationData.get("Transaction.amount");
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            return LocalizationData.get("StatementView.receipt");
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            return LocalizationData.get("StatementView.debt");
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            return LocalizationData.get("Transaction.category");
        }
        if (columnIndex == this.settings.getModeColumn()) {
            return LocalizationData.get("Transaction.mode");
        }
        if (columnIndex == this.settings.getNumberColumn()) {
            return LocalizationData.get("Transaction.number");
        }
        if (columnIndex == this.settings.getValueDateColumn()) {
            return LocalizationData.get("Transaction.valueDate");
        }
        if (columnIndex == this.settings.getStatementColumn()) {
            return LocalizationData.get("Transaction.statement");
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return LocalizationData.get("Transaction.comment");
        }
        return "?";
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.getTransactionsNumber();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        boolean spread = this.isSpread(rowIndex);
        if (this.dateFormater == null) {
            this.dateFormater = SimpleDateFormat.getDateInstance(1, LocalizationData.getLocale());
        }
        Transaction transaction = (Transaction)this.getTransaction(rowIndex);
        if (columnIndex == this.settings.getSpreadColumn()) {
            if (transaction.getSubTransactionSize() == 0) {
                return SpreadState.NOT_SPREADABLE;
            }
            return spread ? SpreadState.SPREAD : SpreadState.NOT_SPREAD;
        }
        if (columnIndex == this.settings.getAccountColumn()) {
            return transaction.getAccount().getName();
        }
        if (columnIndex == this.settings.getDateColumn()) {
            return transaction.getDate();
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return TransactionTableUtils.getDescription(transaction, spread, !this.settings.isCommentSeparatedFromDescription(), false);
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return TransactionTableUtils.getAmount(transaction, spread);
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            return TransactionTableUtils.getExpenseReceipt(transaction, spread, false);
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            return TransactionTableUtils.getExpenseReceipt(transaction, spread, true);
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            return TransactionTableUtils.getCategory(transaction, spread);
        }
        if (columnIndex == this.settings.getModeColumn()) {
            return transaction.getMode().getName();
        }
        if (columnIndex == this.settings.getNumberColumn()) {
            return transaction.getNumber();
        }
        if (columnIndex == this.settings.getValueDateColumn()) {
            return transaction.getValueDate();
        }
        if (columnIndex == this.settings.getStatementColumn()) {
            return transaction.getStatement();
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return TransactionTableUtils.getComment(transaction);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return (columnIndex == this.settings.getDescriptionColumn() || columnIndex == this.settings.getCommentColumn()) && columnIndex >= 0;
    }

    @Override
    public void processEvent(DataEvent event) {
        if (event instanceof EverythingChangedEvent) {
            this.clearSpreadData();
            this.fireTableDataChanged();
        } else if (event instanceof TransactionsAddedEvent) {
            Transaction[] transactions = ((TransactionsAddedEvent)event).getTransactions();
            if (transactions.length == 1) {
                int index = this.data.indexOf(transactions[0]);
                this.fireTableRowsInserted(index, index);
            } else {
                this.fireTableDataChanged();
            }
        } else if (event instanceof TransactionsRemovedEvent) {
            Transaction[] removed = ((TransactionsRemovedEvent)event).getTransactions();
            for (int i = 0; i < removed.length; ++i) {
                this.setSpread(removed[i], false);
            }
            this.fireTableDataChanged();
        } else if (event instanceof AccountPropertyChangedEvent) {
            if (((AccountPropertyChangedEvent)event).getProperty().equals("name")) {
                this.fireTableDataChanged();
            }
        } else if (event instanceof CategoryPropertyChangedEvent || event instanceof ModePropertyChangedEvent && (((ModePropertyChangedEvent)event).getChanges() & 1) != 0) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public AbstractTransaction getTransaction(int row) {
        return this.data.getTransaction(row);
    }

    TableSettings getTableSettings() {
        return this.settings;
    }
}

