/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.util;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class JTableUtils {
    private JTableUtils() {
    }

    public static void initColumnSizes(JTable table, int maxColumnSize) {
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int intercellspacing = table.getIntercellSpacing().width;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int columnWidth = Math.min(comp.getPreferredSize().width, maxColumnSize);
            for (int j = 0; j < table.getRowCount(); ++j) {
                comp = table.getDefaultRenderer(table.getModel().getColumnClass(i)).getTableCellRendererComponent(table, table.getModel().getValueAt(j, i), false, false, 0, i);
                columnWidth = Math.max(Math.min(comp.getPreferredSize().width + intercellspacing, maxColumnSize), columnWidth);
            }
            column.setPreferredWidth(columnWidth);
        }
    }

    public static void fixColumnSize(JTable table, int modelColumnIndex, int margin) {
        int width = Utils.packColumn(table, modelColumnIndex, margin);
        if (width > 0) {
            TableColumn firstColumn = table.getColumnModel().getColumn(table.convertColumnIndexToView(modelColumnIndex));
            firstColumn.setMinWidth(width);
            firstColumn.setMaxWidth(width);
            firstColumn.setResizable(false);
        }
    }
}

