/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.util;

import java.awt.Color;
import java.awt.Font;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.yapbam.gui.HelpManager;
import net.yapbam.util.HtmlUtils;

public class MessageWithLink
extends JEditorPane {
    private static final long serialVersionUID = 1L;

    public MessageWithLink(String htmlBody) {
        super("text/html", "<html><body style=\"" + MessageWithLink.getStyle() + "\">" + HtmlUtils.removeHtmlTags(htmlBody) + "</body></html>");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        HelpManager.show(null, e.getURL().toURI());
                    }
                    catch (URISyntaxException e1) {
                        throw new IllegalArgumentException(e.getURL().toString() + " is not an valid URL");
                    }
                }
            }
        });
        this.setEditable(false);
        this.setBorder(null);
    }

    static StringBuilder getStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        StringBuilder style = new StringBuilder("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        style.append("background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");");
        return style;
    }
}

