/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.util;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.yapbam.gui.HelpManager;
import org.slf4j.LoggerFactory;

public class URLTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private Point clickPoint;

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        TableCellRenderer renderer = table.getCellRenderer(row, column);
        Component comp = table.prepareRenderer(renderer, row, column);
        comp.setBounds(table.getCellRect(row, column, false));
        if (comp instanceof JEditorPane) {
            JEditorPane editPane = (JEditorPane)comp;
            this.clickPoint.x -= comp.getLocation().x;
            this.clickPoint.y -= comp.getLocation().y;
            final String url = this.getHyperlink(editPane, this.clickPoint);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    URLTableCellEditor.this.cancelCellEditing();
                    if (url != null) {
                        try {
                            HelpManager.show((Component)table, new URI(url));
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(URLTableCellEditor.class).debug("Invalid URL " + url, e);
                        }
                    }
                }
            });
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        MouseEvent me;
        boolean editable = false;
        if (e instanceof MouseEvent && (me = (MouseEvent)e).getClickCount() == 1 && SwingUtilities.isLeftMouseButton(me)) {
            editable = true;
            this.clickPoint = me.getPoint();
        }
        return editable;
    }

    private String getHyperlink(JEditorPane editor, Point p) {
        Object attribute;
        int pos = editor.viewToModel(p);
        Element h = this.getHyperlinkElement(editor.getDocument(), pos);
        if (h != null && (attribute = h.getAttributes().getAttribute(HTML.Tag.A)) instanceof AttributeSet) {
            AttributeSet set = (AttributeSet)attribute;
            return (String)set.getAttribute(HTML.Attribute.HREF);
        }
        return null;
    }

    private Element getHyperlinkElement(Document doc, int pos) {
        HTMLDocument hdoc;
        Element elem;
        if (pos >= 0 && doc instanceof HTMLDocument && (elem = (hdoc = (HTMLDocument)doc).getCharacterElement(pos)).getAttributes().getAttribute(HTML.Tag.A) != null) {
            return elem;
        }
        return null;
    }
}

