/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import net.yapbam.gui.Preferences;

public class PanelWithOverlay
extends JLayeredPane {
    private Where where;

    public PanelWithOverlay(JComponent background, JComponent overlay) {
        this(background, overlay, Where.NORTH_EAST);
    }

    public PanelWithOverlay(final JComponent background, final JComponent overlay, Where where) {
        this.where = where;
        this.add((Component)background, 1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                background.setSize(PanelWithOverlay.this.getSize());
            }
        });
        this.add((Component)overlay, 0);
        final int margin = (int)(Preferences.INSTANCE.getFontSizeRatio() * 3.0f);
        background.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle bounds = background.getBounds();
                Dimension preferredSize = overlay.getPreferredSize();
                bounds.x = PanelWithOverlay.this.isAtEast() ? bounds.width - preferredSize.width - margin : margin;
                bounds.y = PanelWithOverlay.this.isAtNorth() ? margin : bounds.height - preferredSize.height - margin;
                bounds.width = preferredSize.width;
                bounds.height = preferredSize.height;
                overlay.setBounds(bounds);
            }
        });
    }

    private boolean isAtEast() {
        return Where.NORTH_EAST.equals((Object)this.where) || Where.SOUTH_EAST.equals((Object)this.where);
    }

    private boolean isAtNorth() {
        return Where.NORTH_EAST.equals((Object)this.where) || Where.NORTH_WEST.equals((Object)this.where);
    }

    public static enum Where {
        NORTH_WEST,
        NORTH_EAST,
        SOUTH_WEST,
        SOUTH_EAST;

    }
}

