/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.widget;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import terai.xrea.jp.DnDTabbedPane;

public class TabbedPane
extends DnDTabbedPane {
    private List<Integer> positions = new ArrayList<Integer>();
    private boolean movingTab = false;

    @Override
    protected void convertTab(int prev, int next) {
        if (next == -1) {
            return;
        }
        if (next > prev) {
            this.positions.add(next - 1, this.positions.remove(prev));
        } else if (next != prev) {
            this.positions.add(next, this.positions.remove(prev));
        }
        this.movingTab = true;
        super.convertTab(prev, next);
        this.movingTab = false;
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (!this.movingTab) {
            this.positions.add(index, this.getTabCount());
        }
        super.insertTab(title, icon, component, tip, index);
    }

    @Override
    public void removeTabAt(int index) {
        if (!this.movingTab) {
            int removed = this.positions.remove(index);
            for (int i = 0; i < this.positions.size(); ++i) {
                if (this.positions.get(i) <= removed) continue;
                this.positions.set(i, this.positions.get(i) - 1);
            }
        }
        super.removeTabAt(index);
    }

    public int[] getIds() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.positions.get(i);
        }
        return result;
    }

    public void setOrder(int[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            this.convertTab(this.getIndexOf(ids[i]), i);
        }
    }

    public int getIndexOf(int id) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (this.positions.get(i) != id) continue;
            return i;
        }
        return -1;
    }

    public int getId(int index) {
        return this.positions.get(index);
    }
}

