/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.relnotes;

import com.fathzer.soft.ajlib.utilities.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReleaseNotesFormatter {
    private boolean ignoreNext = false;
    private boolean divOpened = false;
    private boolean needSeparator = false;
    private boolean firstOne = true;
    private List<String> known;
    private List<String> changes = new ArrayList<String>();
    private List<String> fixes = new ArrayList<String>();
    private List<String> currentList = null;
    private boolean ignoredVersion = false;
    private BufferedWriter writer;
    private String next;
    private String knownSingular;
    private String knownPlural;
    private String changeSingular;
    private String changePlural;
    private String fixSingular;
    private String fixPlural;

    public ReleaseNotesFormatter() {
        this.known = new ArrayList<String>();
    }

    public void setIgnoreNext(boolean ignoreNext) {
        this.ignoreNext = ignoreNext;
    }

    private void echoHead() throws IOException {
        this.echo("<html>");
        this.echo("<head>");
        this.echoCSS();
        this.echo("</head>");
        this.echo("<body>");
    }

    protected void echoCSS() throws IOException {
        this.echo("<style type=\"text/css\">");
        this.echo(".relnotes-version {");
        this.echo("background: #f0f0f0;");
        this.echo("margin-bottom: 10px;");
        this.echo("padding-left: 5px;");
        this.echo("}");
        this.echo(".relnotes-bugFix {");
        this.echo("background: #f8fff8;");
        this.echo("color: #202020;");
        this.echo("padding-left: 5px;");
        this.echo("margin-bottom: 5px;");
        this.echo("margin-right: 5px;");
        this.echo("}");
        this.echo("h2 { font-size: 1.2em; }");
        this.echo("ul { margin-top: 0px; }");
        this.echo("</style>");
    }

    private void echoBottom() throws IOException {
        this.echo("</body>");
        this.echo("</html>");
    }

    public synchronized void build(BufferedReader reader, BufferedWriter writer) throws IOException {
        this.writer = writer;
        this.echoHead();
        String line = reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        String[] fields = StringUtils.split(line, '\t');
        if (fields.length < 7) {
            throw new EOFException(line);
        }
        this.next = fields[0];
        this.knownSingular = fields[1];
        this.knownPlural = fields[2];
        this.changeSingular = fields[3];
        this.changePlural = fields[4];
        this.fixSingular = fields[5];
        this.fixPlural = fields[6];
        int lineNumber = 1;
        line = reader.readLine();
        while (line != null) {
            ++lineNumber;
            fields = StringUtils.split(line, '\t');
            String code = fields[0].trim();
            String string = line = fields.length > 1 ? fields[1].trim() : "";
            if ("version".equals(code)) {
                this.openVersion(line);
            } else if ("improvement".equals(code)) {
                this.currentList = this.changes;
            } else if ("fix".equals(code)) {
                this.currentList = this.fixes;
            } else if ("known".equals(code)) {
                this.currentList = this.known;
            } else if (code.isEmpty()) {
                if (!line.isEmpty()) {
                    if (this.currentList == null) {
                        System.err.println("Line " + lineNumber + " is not preceded by a kind");
                    } else {
                        this.currentList.add(line);
                    }
                }
            } else {
                this.wrongLine(lineNumber);
            }
            if (fields.length > 2) {
                this.wrongLine(lineNumber);
            }
            line = reader.readLine();
        }
        this.closeVersion();
        this.echoBottom();
        this.writer.flush();
    }

    private void wrongLine(int lineNumber) {
        System.err.println(this.getClass().getName() + ": Line " + lineNumber + " is wrong");
    }

    private void openVersion(String version) throws IOException {
        this.closeVersion();
        if ("next".equals(version)) {
            if (this.ignoreNext) {
                this.ignoredVersion = true;
            } else {
                this.echo("<h2>" + this.next + "</h2>");
                this.needSeparator = true;
            }
        } else {
            if (this.needSeparator) {
                this.echo("<hr/>");
            }
            this.echo("<div class=\"relnotes-version\"><h2>" + version + "</h2>");
            this.divOpened = true;
            this.needSeparator = this.firstOne;
            this.firstOne = false;
        }
    }

    private void closeVersion() throws IOException {
        if (!this.ignoredVersion) {
            this.output(this.known, "relnotes-knownBugs", this.knownSingular, this.knownPlural);
            this.output(this.changes, "relnotes-new", this.changeSingular, this.changePlural);
            this.output(this.fixes, "relnotes-bugFix", this.fixSingular, this.fixPlural);
            this.known.clear();
            if (this.divOpened) {
                this.echo("</div>");
                this.divOpened = false;
            }
        }
        this.changes.clear();
        this.fixes.clear();
        this.currentList = null;
        this.ignoredVersion = false;
    }

    private void output(List<String> array, String className, String singular, String plural) throws IOException {
        if (!array.isEmpty()) {
            String title = array.size() == 1 ? singular : plural;
            this.echo("<div class=\"" + className + "\"><h3>" + title + "</h3><ul>");
            for (String line : array) {
                this.echo("<li>" + line + "</li>");
            }
            this.echo("</ul></div>");
        }
    }

    private void echo(String line) throws IOException {
        this.writer.write(line);
        this.writer.newLine();
    }
}

