/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.update;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.YapbamState;
import net.yapbam.update.ReleaseInfo;
import net.yapbam.util.CheckSum;
import net.yapbam.util.CoolHttpConnection;

public class UpdateInformation {
    private int errorCode;
    private ReleaseInfo lastestRelease;
    private URL updateURL;
    private URL autoUpdateURL;
    private String autoUpdateCheckSum;
    private long autoUpdateSize;
    private URL autoUpdaterURL;
    private String autoUpdaterCheckSum;
    private long autoUpdaterSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateInformation(URL url) throws IOException {
        CoolHttpConnection ct = new CoolHttpConnection(url, Preferences.INSTANCE.getHttpProxy(), new URL[0]);
        this.errorCode = ct.getResponseCode();
        if (this.errorCode == 200) {
            Properties p = new Properties();
            String encoding = ct.getContentEncoding();
            if (encoding == null) {
                throw new IOException("Encoding is null");
            }
            InputStreamReader reader = new InputStreamReader(ct.getInputStream(), encoding);
            try {
                p.load(reader);
            }
            finally {
                reader.close();
            }
            String serialNumber = p.getProperty("serialNumber");
            YapbamState.INSTANCE.put("serialNumber", serialNumber);
            this.lastestRelease = new ReleaseInfo(p.getProperty("lastestRelease"));
            this.updateURL = new URL(p.getProperty("updateURL"));
            this.autoUpdateURL = new URL(p.getProperty("autoUpdateURL"));
            this.autoUpdateCheckSum = CheckSum.toString(CheckSum.toBytes(p.getProperty("autoUpdateCHKSUM")));
            this.autoUpdateSize = Long.parseLong(p.getProperty("autoUpdateSize"));
            this.autoUpdaterURL = new URL(p.getProperty("autoUpdateUpdaterURL"));
            this.autoUpdaterCheckSum = CheckSum.toString(CheckSum.toBytes(p.getProperty("autoUpdateUpdaterCHKSUM")));
            this.autoUpdaterSize = Long.parseLong(p.getProperty("autoUpdateUpdaterSize"));
        }
    }

    public int getHttpErrorCode() {
        return this.errorCode;
    }

    public ReleaseInfo getLastestRelease() {
        return this.lastestRelease;
    }

    public URL getUpdateURL() {
        return this.updateURL;
    }

    public URL getAutoUpdateURL() {
        return this.autoUpdateURL;
    }

    public String getAutoUpdateCheckSum() {
        return this.autoUpdateCheckSum;
    }

    public long getAutoUpdateSize() {
        return this.autoUpdateSize;
    }

    public long getAutoUpdaterSize() {
        return this.autoUpdaterSize;
    }

    public URL getAutoUpdaterURL() {
        return this.autoUpdaterURL;
    }

    public String getAutoUpdaterCheckSum() {
        return this.autoUpdaterCheckSum;
    }
}

