/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Portable {
    private static ApplicationDefinition appDefinition = null;
    private static boolean IS_PORTABLE;
    private static File APP_DIRECTORY;
    private static File DATA_DIRECTORY;
    private static boolean IS_JNLP;
    private static boolean inited;

    private static void initDefFromPropertyStream(InputStream in) throws IOException {
        Logger logger = LoggerFactory.getLogger(Portable.class);
        Properties properties = new Properties();
        properties.load(in);
        String className = properties.getProperty("class");
        if (className == null) {
            logger.warn("No class specified in property resource file");
        } else {
            try {
                appDefinition = (ApplicationDefinition)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                logger.warn("Unable to create application description (" + className + ")", e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error while creating application description (" + className + ")", e);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unable to find application description class (" + className + ")", e);
            }
        }
    }

    public static void setDefinition(ApplicationDefinition definition) {
        if (!NullUtils.areEquals(definition, appDefinition)) {
            APP_DIRECTORY = null;
            appDefinition = definition;
        }
    }

    private static void init() {
        if (inited) {
            return;
        }
        if (appDefinition == null) {
            throw new IllegalStateException();
        }
        APP_DIRECTORY = Boolean.getBoolean("simulateJNLP") ? null : appDefinition.getAppDirectory();
        IS_JNLP = APP_DIRECTORY == null;
        IS_PORTABLE = APP_DIRECTORY != null && FileUtils.isWritable(APP_DIRECTORY);
        File file = APP_DIRECTORY;
        if (IS_PORTABLE) {
            file = new File(file, "Data");
        } else {
            String path = System.getenv("APPDATA");
            if (path == null) {
                path = System.getenv("USERPROFILE");
            }
            if (path == null) {
                path = System.getProperty("user.home");
            }
            file = path != null && FileUtils.isWritable(new File(path)) ? new File(path, "." + appDefinition.getApplicationName()) : ((path = System.getProperty("java.io.tmpdir")) != null && FileUtils.isWritable(new File(path)) ? new File(path, "." + appDefinition.getApplicationName()) : null);
        }
        DATA_DIRECTORY = file;
        inited = true;
    }

    private Portable() {
    }

    public static boolean isPortable() {
        Portable.init();
        return IS_PORTABLE;
    }

    public static boolean isWebStarted() {
        Portable.init();
        return IS_JNLP;
    }

    public static File getApplicationDirectory() {
        Portable.init();
        return APP_DIRECTORY;
    }

    public static File getDataDirectory() {
        Portable.init();
        return DATA_DIRECTORY;
    }

    public static File getHelpDirectory() {
        Portable.init();
        File file = Portable.getApplicationDirectory();
        file = new File(file, "Other/Help");
        if (!file.exists()) {
            file = new File(Portable.getApplicationDirectory(), "Other/help");
        }
        return file;
    }

    public static File getUpdateFileDirectory() {
        Portable.init();
        return new File(Portable.getDataDirectory(), "update");
    }

    static {
        InputStream in = Portable.class.getClassLoader().getResourceAsStream("applicationDefinition.properties");
        if (in != null) {
            Logger logger = LoggerFactory.getLogger(Portable.class);
            logger.trace("Application definition is specified");
            try {
                Portable.initDefFromPropertyStream(in);
            }
            catch (IOException e) {
                logger.warn("Unable to read property resource file", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close property resource file", e);
                }
            }
        }
        inited = false;
    }

    public static interface ApplicationDefinition {
        public File getAppDirectory();

        public String getApplicationName();
    }
}

