/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.util.HtmlUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class TransactionUtils {
    private static final String NEW_INDENTED_LINE = "<BR>&nbsp;&nbsp;";
    private static final String OPEN = "<HTML><BODY>";
    private static final String END = "</HTML></BODY>";
    private WordingProvider wordingProvider;

    public TransactionUtils(WordingProvider wordingProvider) {
        this.wordingProvider = wordingProvider;
    }

    public String getDescription(AbstractTransaction transaction, boolean spread, boolean mergeComment, boolean withHtmlTags) {
        StringBuilder buf = new StringBuilder();
        if (withHtmlTags) {
            buf.append(OPEN);
        }
        if (spread) {
            buf.append(this.getDescription(transaction, false, mergeComment, false));
            for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
                buf.append(NEW_INDENTED_LINE).append(StringEscapeUtils.escapeHtml3(transaction.getSubTransaction(i).getDescription()));
            }
            if (transaction.getComplement() != 0.0) {
                buf.append(NEW_INDENTED_LINE).append(StringEscapeUtils.escapeHtml3(this.wordingProvider.getComplementWording()));
            }
        } else {
            buf.append(StringEscapeUtils.escapeHtml3(transaction.getDescription()));
            if (mergeComment && transaction.getComment() != null) {
                buf.append(" (");
                buf.append(this.getComment(transaction));
                buf.append(")");
            }
        }
        if (withHtmlTags) {
            buf.append(END);
        }
        return buf.toString().replace(" ", "&nbsp;");
    }

    public String getComment(AbstractTransaction transaction) {
        String comment = transaction.getComment();
        return comment == null ? "" : HtmlUtils.toHtml(comment);
    }

    private boolean isExpense(double amount) {
        return GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) <= 0;
    }

    private boolean isZero(double amount) {
        return GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) == 0;
    }

    private String getName(Category category) {
        return category.equals(Category.UNDEFINED) ? "" : category.getName();
    }

    public double[] getAmount(AbstractTransaction transaction, boolean spread) {
        if (spread) {
            double complement = transaction.getComplement();
            int numberOfLines = transaction.getSubTransactionSize() + 1;
            if (complement != 0.0) {
                ++numberOfLines;
            }
            double[] result = new double[numberOfLines];
            result[0] = transaction.getAmount();
            for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
                result[i + 1] = transaction.getSubTransaction(i).getAmount();
            }
            if (complement != 0.0) {
                result[result.length - 1] = complement;
            }
            return result;
        }
        return new double[]{transaction.getAmount()};
    }

    public double[] getExpenseReceipt(AbstractTransaction transaction, boolean spread, boolean expense) {
        double[] dArray;
        if (spread) {
            double complement = transaction.getComplement();
            int numberOfLines = transaction.getSubTransactionSize() + 1;
            if (!this.isZero(complement)) {
                ++numberOfLines;
            }
            double[] result = new double[numberOfLines];
            result[0] = expense == this.isExpense(transaction.getAmount()) ? transaction.getAmount() : Double.NaN;
            for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
                double amount = transaction.getSubTransaction(i).getAmount();
                result[i + 1] = expense == this.isExpense(amount) ? amount : Double.NaN;
            }
            if (!this.isZero(complement)) {
                result[result.length - 1] = expense == this.isExpense(complement) ? complement : Double.NaN;
            }
            return result;
        }
        if (expense == this.isExpense(transaction.getAmount())) {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = transaction.getAmount();
        } else {
            dArray = null;
        }
        return dArray;
    }

    public Object getCategory(AbstractTransaction transaction, boolean spread) {
        if (spread) {
            StringBuilder buf = new StringBuilder(OPEN);
            buf.append(StringEscapeUtils.escapeHtml3(this.getName(transaction.getCategory())));
            for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
                buf.append(NEW_INDENTED_LINE).append(StringEscapeUtils.escapeHtml3(this.getName(transaction.getSubTransaction(i).getCategory())));
            }
            if (transaction.getComplement() != 0.0) {
                buf.append(NEW_INDENTED_LINE).append(StringEscapeUtils.escapeHtml3(this.getName(transaction.getCategory())));
            }
            buf.append(END);
            return buf.toString().replace(" ", "&nbsp;");
        }
        return this.getName(transaction.getCategory());
    }

    public static interface WordingProvider {
        public String getComplementWording();
    }
}

