/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JideSwingUtilities
implements SwingConstants {
    private static ChangeListener _viewportSyncListener;

    JideSwingUtilities() {
    }

    private static ChangeListener getViewportSynchronizationChangeListener() {
        if (_viewportSyncListener == null) {
            _viewportSyncListener = new viewportSynchronizationChangeListener();
        }
        return _viewportSyncListener;
    }

    public static void synchronizeView(JViewport masterViewport, JViewport slaveViewport, int orientation) {
        HashMap property;
        int i;
        if (masterViewport == null || slaveViewport == null) {
            return;
        }
        ChangeListener[] changeListeners = masterViewport.getChangeListeners();
        for (i = 0; i < changeListeners.length && changeListeners[i] != JideSwingUtilities.getViewportSynchronizationChangeListener(); ++i) {
        }
        if (i >= changeListeners.length) {
            masterViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
        }
        if (!((property = masterViewport.getClientProperty("synchronizeViewSlaveViewport")) instanceof Map)) {
            property = new HashMap();
        }
        Map slaveViewportMap = property;
        slaveViewportMap.put(slaveViewport, orientation);
        masterViewport.putClientProperty("synchronizeViewSlaveViewport", slaveViewportMap);
        property = slaveViewport.getClientProperty("synchronizeViewMasterViewport");
        if (!(property instanceof Map)) {
            property = new HashMap();
        }
        Map masterViewportMap = property;
        masterViewportMap.put(masterViewport, orientation);
        slaveViewport.putClientProperty("synchronizeViewMasterViewport", masterViewportMap);
    }

    public static void unsynchronizeView(JViewport masterViewport, JViewport slaveViewport) {
        if (masterViewport == null || slaveViewport == null) {
            return;
        }
        Object property = masterViewport.getClientProperty("synchronizeViewSlaveViewport");
        if (property instanceof Map) {
            Map slaveViewportMap = (Map)property;
            slaveViewportMap.remove(slaveViewport);
            if (slaveViewportMap.isEmpty()) {
                slaveViewportMap = null;
                masterViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
            masterViewport.putClientProperty("synchronizeViewSlaveViewport", slaveViewportMap);
        }
        if ((property = slaveViewport.getClientProperty("synchronizeViewMasterViewport")) instanceof Map) {
            Map masterViewportMap = (Map)property;
            masterViewportMap.remove(masterViewport);
            if (masterViewportMap.isEmpty()) {
                masterViewportMap = null;
            }
            slaveViewport.putClientProperty("synchronizeViewMasterViewport", masterViewportMap);
        }
    }

    private static class viewportSynchronizationChangeListener
    implements ChangeListener {
        private viewportSynchronizationChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e.getSource() instanceof JViewport)) {
                return;
            }
            JViewport masterViewport = (JViewport)e.getSource();
            Object property = masterViewport.getClientProperty("synchronizeViewSlaveViewport");
            if (!(property instanceof Map)) {
                return;
            }
            Dimension size = masterViewport.getSize();
            if (size.width == 0 || size.height == 0) {
                return;
            }
            Map slaveViewportMap = (Map)property;
            HashMap allViewportToSync = new HashMap();
            allViewportToSync.putAll(slaveViewportMap);
            while (true) {
                HashMap viewportToAdd = new HashMap();
                for (JViewport slaveViewport : allViewportToSync.keySet()) {
                    Object slaveProperty = slaveViewport.getClientProperty("synchronizeViewSlaveViewport");
                    if (!(slaveProperty instanceof Map)) continue;
                    int orientation = (Integer)allViewportToSync.get(slaveViewport);
                    Map viewportMap = (Map)slaveProperty;
                    for (JViewport viewport : viewportMap.keySet()) {
                        if (viewport == masterViewport || allViewportToSync.containsKey(viewport) || (Integer)viewportMap.get(viewport) != orientation) continue;
                        viewportToAdd.put(viewport, viewportMap.get(viewport));
                    }
                }
                if (viewportToAdd.isEmpty()) break;
                allViewportToSync.putAll(viewportToAdd);
            }
            for (JViewport slaveViewport : allViewportToSync.keySet()) {
                Point v2;
                Point v1;
                slaveViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
                int orientation = (Integer)allViewportToSync.get(slaveViewport);
                if (orientation == 0) {
                    v1 = masterViewport.getViewPosition();
                    v2 = slaveViewport.getViewPosition();
                    if (v1.x != v2.x) {
                        slaveViewport.setViewPosition(new Point(v1.x, v2.y));
                    }
                } else if (orientation == 1) {
                    v1 = masterViewport.getViewPosition();
                    v2 = slaveViewport.getViewPosition();
                    if (v1.y != v2.y) {
                        slaveViewport.setViewPosition(new Point(v2.x, v1.y));
                    }
                }
                slaveViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
        }
    }
}

