/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;

public class Comparators {
    private static Comparator<Transaction> transactionByDate = null;
    private static Comparator<Transaction> transactionByAmount = null;
    private static Comparator<Transaction> transactionByMemo = null;
    private static Comparator<Transaction> transactionByNumber = null;
    private static Comparator<Transaction> transactionByPayee = null;
    private static Comparator<Transaction> transactionBySecurity = null;
    private static Comparator<Transaction> transactionByType = null;

    public static Comparator<Account> getAccountByName() {
        return new AccountByName();
    }

    public static Comparator<Account> getAccountByPathName() {
        return new AccountByPathName();
    }

    public static Comparator<Account> getAccountByBalance(Date startDate, Date endDate, CurrencyNode currency, boolean ascending) {
        return new AccountByBalance(startDate, endDate, currency, ascending);
    }

    public static Comparator<Transaction> getTransactionByDate() {
        if (transactionByDate != null) {
            return transactionByDate;
        }
        transactionByDate = new TransactionByDate();
        return transactionByDate;
    }

    public static Comparator<Transaction> getTransactionByAmount() {
        if (transactionByAmount != null) {
            return transactionByAmount;
        }
        transactionByAmount = new TransactionByAmount();
        return transactionByAmount;
    }

    public static Comparator<Transaction> getTransactionByPayee() {
        if (transactionByPayee != null) {
            return transactionByPayee;
        }
        transactionByPayee = new TransactionByPayee();
        return transactionByPayee;
    }

    public static Comparator<Transaction> getTransactionByMemo() {
        if (transactionByMemo != null) {
            return transactionByMemo;
        }
        transactionByMemo = new TransactionByMemo();
        return transactionByMemo;
    }

    public static Comparator<Transaction> getTransactionByNumber() {
        if (transactionByNumber != null) {
            return transactionByNumber;
        }
        transactionByNumber = new TransactionByNumber();
        return transactionByNumber;
    }

    public static Comparator<Transaction> getTransactionBySecurity() {
        if (transactionBySecurity != null) {
            return transactionBySecurity;
        }
        transactionBySecurity = new TransactionBySecurity();
        return transactionBySecurity;
    }

    public static Comparator<Transaction> getTransactionByType() {
        if (transactionByType != null) {
            return transactionByType;
        }
        transactionByType = new TransactionByType();
        return transactionByType;
    }

    private Comparators() {
    }

    private static class TransactionByType
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -5608504681905338120L;

        private TransactionByType() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getTransactionType().compareTo(o2.getTransactionType());
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }

    private static class TransactionBySecurity
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -7693459048730293939L;

        private TransactionBySecurity() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            if (o1 instanceof InvestmentTransaction && o2 instanceof InvestmentTransaction) {
                int result = ((InvestmentTransaction)o1).getSecurityNode().compareTo(((InvestmentTransaction)o2).getSecurityNode());
                if (result != 0) {
                    return result;
                }
                return o1.compareTo(o2);
            }
            if (o1 instanceof InvestmentTransaction) {
                return -1;
            }
            if (o2 instanceof InvestmentTransaction) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    private static class TransactionByNumber
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -6249244600475940336L;

        private TransactionByNumber() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getNumber().compareTo(o2.getNumber());
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }

    private static class TransactionByMemo
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -8403231536773788664L;

        private TransactionByMemo() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getMemo().compareTo(o2.getMemo());
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }

    private static class TransactionByPayee
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = 449668146646303461L;

        private TransactionByPayee() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getPayee().compareTo(o2.getPayee());
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }

    public static class TransactionByAccount
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -7736644080763766670L;
        private final Account baseAccount;

        public TransactionByAccount(Account baseAccount) {
            this.baseAccount = baseAccount;
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            String s2;
            if (o1 == o2) {
                return 0;
            }
            String s1 = this.getAccount(o1);
            int result = s1.compareTo(s2 = this.getAccount(o2));
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }

        private String getAccount(Transaction t) {
            if (t.getTransactionEntries().size() == 1) {
                if (t.getTransactionEntries().get(0).getCreditAccount() != this.baseAccount) {
                    return t.getTransactionEntries().get(0).getCreditAccount().getPathName();
                }
                return t.getTransactionEntries().get(0).getDebitAccount().getPathName();
            }
            return "!split!";
        }
    }

    private static class TransactionByAmount
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = -4850098176317371999L;

        private TransactionByAmount() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            TransactionEntry t1 = o1.getTransactionEntries().get(0);
            TransactionEntry t2 = o2.getTransactionEntries().get(0);
            int result = t1.getAmount(t1.getCreditAccount()).compareTo(t2.getAmount(t2.getCreditAccount()));
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }

    private static class AccountByBalance
    implements Comparator<Account>,
    Serializable {
        private static final long serialVersionUID = -4850018176347371999L;
        private final Date startDate;
        private final Date endDate;
        private final boolean ascending;
        private final CurrencyNode currency;

        public AccountByBalance(Date startDate, Date endDate, CurrencyNode currency, boolean ascending) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.currency = currency;
            this.ascending = ascending;
        }

        @Override
        public int compare(Account a1, Account a2) {
            int result = a1.getBalance(this.startDate, this.endDate, this.currency).compareTo(a2.getBalance(this.startDate, this.endDate, this.currency));
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }
    }

    private static class AccountByPathName
    implements Comparator<Account>,
    Serializable {
        private static final long serialVersionUID = -4850018176347371999L;

        private AccountByPathName() {
        }

        @Override
        public int compare(Account a1, Account a2) {
            return a1.getPathName().compareTo(a2.getPathName());
        }
    }

    private static class AccountByName
    implements Comparator<Account>,
    Serializable {
        private static final long serialVersionUID = -4850018176347371999L;

        private AccountByName() {
        }

        @Override
        public int compare(Account a1, Account a2) {
            return a1.getName().compareTo(a2.getName());
        }
    }

    private static class TransactionByDate
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = 2952335785972287877L;

        private TransactionByDate() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            return o1.compareTo(o2);
        }
    }
}

