/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.budget;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.budget.BudgetPeriodResults;
import jgnash.engine.budget.BudgetResultsModel;
import jgnash.text.CommodityFormat;
import jgnash.util.FileUtils;
import jgnash.util.Resource;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BudgetResultsExport {
    private BudgetResultsExport() {
    }

    public static void exportBudgetResultsModel(File file, BudgetResultsModel model) {
        CellReference remainingRef;
        CellReference changeRef;
        CellReference budgetedRef;
        BudgetPeriodResults results;
        int i;
        ArrayList<CellReference> remainingRefList;
        ArrayList<CellReference> changeRefList;
        ArrayList<CellReference> budgetedRefList;
        Cell c;
        CellStyle cs;
        int col;
        String pattern;
        DecimalFormat format;
        CellStyle amountStyle;
        Cell c2;
        Resource rb = Resource.get();
        String extension = FileUtils.getFileExtension(file.getAbsolutePath());
        Object wb = extension.equals("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet s = wb.createSheet(model.getBudget().getName());
        CellStyle headerStyle = wb.createCellStyle();
        Font amountFont = wb.createFont();
        Font headerFont = wb.createFont();
        amountFont.setFontHeightInPoints((short)10);
        amountFont.setColor(IndexedColors.BLACK.getIndex());
        headerFont.setFontHeightInPoints((short)11);
        headerFont.setColor(IndexedColors.BLACK.getIndex());
        headerFont.setBoldweight((short)700);
        DataFormat df = wb.createDataFormat();
        headerStyle.setBorderBottom((short)1);
        headerStyle.setBorderTop((short)1);
        headerStyle.setBorderLeft((short)1);
        headerStyle.setBorderRight((short)1);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerStyle.setFillPattern((short)1);
        headerStyle.setDataFormat(df.getFormat("text"));
        headerStyle.setFont(headerFont);
        headerStyle.setAlignment((short)2);
        int row = 0;
        Row r = s.createRow(row);
        for (int i2 = 0; i2 < model.getDescriptorList().size(); ++i2) {
            c2 = r.createCell(i2 * 3 + 1);
            c2.setCellValue(createHelper.createRichTextString(model.getDescriptorList().get(i2).getPeriodDescription()));
            c2.setCellStyle(headerStyle);
            s.addMergedRegion(new CellRangeAddress(row, row, i2 * 3 + 1, i2 * 3 + 3));
        }
        int col2 = model.getDescriptorList().size() * 3 + 1;
        c2 = r.createCell(col2);
        c2.setCellValue(createHelper.createRichTextString(rb.getString("Title.Summary")));
        c2.setCellStyle(headerStyle);
        s.addMergedRegion(new CellRangeAddress(row, row, col2, col2 + 2));
        r = s.createRow(++row);
        Cell c3 = r.createCell(0);
        c3.setCellValue(createHelper.createRichTextString(rb.getString("Column.Account")));
        c3.setCellStyle(headerStyle);
        for (int i3 = 0; i3 <= model.getDescriptorList().size(); ++i3) {
            c3 = r.createCell(i3 * 3 + 1);
            c3.setCellValue(createHelper.createRichTextString(rb.getString("Column.Budgeted")));
            c3.setCellStyle(headerStyle);
            c3 = r.createCell(i3 * 3 + 2);
            c3.setCellValue(createHelper.createRichTextString(rb.getString("Column.Change")));
            c3.setCellStyle(headerStyle);
            c3 = r.createCell(i3 * 3 + 3);
            c3.setCellValue(createHelper.createRichTextString(rb.getString("Column.Remaining")));
            c3.setCellStyle(headerStyle);
        }
        ArrayList<Account> accounts = new ArrayList<Account>(model.getAccounts());
        Collections.sort(accounts);
        for (Account account : accounts) {
            amountStyle = wb.createCellStyle();
            amountStyle.setFont(amountFont);
            format = (DecimalFormat)CommodityFormat.getFullNumberFormat(account.getCurrencyNode());
            pattern = format.toLocalizedPattern().replace("\u00a4", account.getCurrencyNode().getPrefix());
            amountStyle.setDataFormat(df.getFormat(pattern));
            col = 0;
            r = s.createRow(++row);
            cs = wb.createCellStyle();
            cs.cloneStyleFrom(headerStyle);
            cs.setAlignment((short)1);
            cs.setIndention((short)(model.getDepth(account) * 2));
            c = r.createCell(col);
            c.setCellValue(createHelper.createRichTextString(account.getName()));
            c.setCellStyle(cs);
            budgetedRefList = new ArrayList<CellReference>();
            changeRefList = new ArrayList<CellReference>();
            remainingRefList = new ArrayList<CellReference>();
            for (i = 0; i < model.getDescriptorList().size(); ++i) {
                results = model.getResults(model.getDescriptorList().get(i), account);
                c = r.createCell(++col);
                c.setCellType(0);
                c.setCellValue(results.getBudgeted().doubleValue());
                c.setCellStyle(amountStyle);
                budgetedRef = new CellReference(row, col);
                budgetedRefList.add(budgetedRef);
                c = r.createCell(++col);
                c.setCellType(0);
                c.setCellValue(results.getChange().doubleValue());
                c.setCellStyle(amountStyle);
                changeRef = new CellReference(row, col);
                changeRefList.add(changeRef);
                c = r.createCell(++col);
                c.setCellType(2);
                c.setCellStyle(amountStyle);
                c.setCellFormula(budgetedRef.formatAsString() + "-" + changeRef.formatAsString());
                remainingRef = new CellReference(row, col);
                remainingRefList.add(remainingRef);
            }
            BudgetResultsExport.addSummaryCell(r, ++col, budgetedRefList, amountStyle);
            BudgetResultsExport.addSummaryCell(r, ++col, changeRefList, amountStyle);
            BudgetResultsExport.addSummaryCell(r, ++col, remainingRefList, amountStyle);
        }
        for (AccountGroup group : model.getAccountGroupList()) {
            amountStyle = wb.createCellStyle();
            amountStyle.setFont(amountFont);
            amountStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            amountStyle.setFillPattern((short)1);
            amountStyle.setBorderBottom((short)1);
            amountStyle.setBorderTop((short)1);
            amountStyle.setBorderLeft((short)1);
            amountStyle.setBorderRight((short)1);
            format = (DecimalFormat)CommodityFormat.getFullNumberFormat(model.getBaseCurrency());
            pattern = format.toLocalizedPattern().replace("\u00a4", model.getBaseCurrency().getPrefix());
            amountStyle.setDataFormat(df.getFormat(pattern));
            col = 0;
            r = s.createRow(++row);
            cs = wb.createCellStyle();
            cs.cloneStyleFrom(headerStyle);
            cs.setAlignment((short)1);
            c = r.createCell(col);
            c.setCellValue(createHelper.createRichTextString(group.toString()));
            c.setCellStyle(cs);
            budgetedRefList = new ArrayList();
            changeRefList = new ArrayList();
            remainingRefList = new ArrayList();
            for (i = 0; i < model.getDescriptorList().size(); ++i) {
                results = model.getResults(model.getDescriptorList().get(i), group);
                c = r.createCell(++col);
                c.setCellType(0);
                c.setCellValue(results.getBudgeted().doubleValue());
                c.setCellStyle(amountStyle);
                budgetedRef = new CellReference(row, col);
                budgetedRefList.add(budgetedRef);
                c = r.createCell(++col);
                c.setCellType(0);
                c.setCellValue(results.getChange().doubleValue());
                c.setCellStyle(amountStyle);
                changeRef = new CellReference(row, col);
                changeRefList.add(changeRef);
                c = r.createCell(++col);
                c.setCellType(2);
                c.setCellStyle(amountStyle);
                c.setCellFormula(budgetedRef.formatAsString() + "-" + changeRef.formatAsString());
                remainingRef = new CellReference(row, col);
                remainingRefList.add(remainingRef);
            }
            BudgetResultsExport.addSummaryCell(r, ++col, budgetedRefList, amountStyle);
            BudgetResultsExport.addSummaryCell(r, ++col, changeRefList, amountStyle);
            BudgetResultsExport.addSummaryCell(r, ++col, remainingRefList, amountStyle);
        }
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        evaluator.evaluateAll();
        int columnCount = s.getRow(1).getLastCellNum();
        for (int i4 = 0; i4 <= columnCount; ++i4) {
            s.autoSizeColumn(i4);
            s.setColumnWidth(i4, s.getColumnWidth(i4) + 10);
        }
        String filename = file.getAbsolutePath();
        filename = wb instanceof XSSFWorkbook ? FileUtils.stripFileExtension(filename) + ".xlsx" : FileUtils.stripFileExtension(filename) + ".xls";
        try {
            FileOutputStream out = new FileOutputStream(filename);
            wb.write((OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            Logger.getLogger(BudgetResultsExport.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private static void addSummaryCell(Row row, int col, List<CellReference> cellReferenceList, CellStyle style) {
        Cell c = row.createCell(col);
        c.setCellType(2);
        c.setCellStyle(style);
        c.setCellFormula(BudgetResultsExport.buildAddFormula(cellReferenceList));
    }

    private static String buildAddFormula(List<CellReference> cellReferenceList) {
        StringBuilder formula = new StringBuilder(cellReferenceList.get(0).formatAsString());
        for (int i = 1; i < cellReferenceList.size(); ++i) {
            formula.append("+");
            formula.append(cellReferenceList.get(i).formatAsString());
        }
        return formula.toString();
    }
}

