/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.checks;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import jgnash.engine.checks.CheckLayout;
import jgnash.engine.checks.CheckObject;

public class CheckLayoutSerializationFactory {
    public static CheckLayout loadLayout(String file) {
        XStream xstream = CheckLayoutSerializationFactory.getStream();
        CheckLayout layout = null;
        try {
            FileReader in = new FileReader(file);
            layout = (CheckLayout)xstream.fromXML(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return layout;
    }

    public static boolean saveLayout(String file, CheckLayout layout) {
        boolean result = false;
        XStream xstream = CheckLayoutSerializationFactory.getStream();
        try {
            FileWriter out = new FileWriter(file);
            xstream.toXML((Object)layout, out);
            out.close();
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static XStream getStream() {
        XStream xstream = new XStream(new StaxDriver());
        xstream.alias("CheckLayout", CheckLayout.class);
        xstream.alias("CheckObject", CheckObject.class);
        return xstream;
    }

    private CheckLayoutSerializationFactory() {
    }
}

