/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.recurring;

import java.util.Calendar;
import java.util.Date;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.ReminderType;
import jgnash.util.DateUtils;

public class MonthlyReminder
extends Reminder {
    private static final long serialVersionUID = 11516039436649194L;
    private int type = 0;
    private static final int DATE = 0;
    private static final int DAY = 1;

    @Override
    public RecurringIterator getIterator() {
        return new MonthlyIterator();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public ReminderType getReminderType() {
        return ReminderType.MONTHLY;
    }

    public void setType(int type) {
        if (type == 0 || type == 1) {
            this.type = type;
        }
    }

    private class MonthlyIterator
    implements RecurringIterator {
        private Calendar calendar = Calendar.getInstance();

        public MonthlyIterator() {
            if (MonthlyReminder.this.getLastDate() != null) {
                this.calendar.setTime(MonthlyReminder.this.getLastDate());
            } else if (MonthlyReminder.this.type == 0) {
                this.calendar.setTime(MonthlyReminder.this.getStartDate());
                this.calendar.add(2, MonthlyReminder.this.getIncrement() * -1);
            } else if (MonthlyReminder.this.type == 1) {
                this.calendar.setTime(MonthlyReminder.this.getStartDate());
                int week = this.calendar.get(4);
                int day = this.calendar.get(7);
                this.calendar.add(2, MonthlyReminder.this.getIncrement() * -1);
                this.calendar.set(4, week);
                this.calendar.set(7, day);
            }
        }

        @Override
        public Date next() {
            if (MonthlyReminder.this.type == 0) {
                this.calendar.add(2, MonthlyReminder.this.getIncrement());
            } else {
                int week = this.calendar.get(4);
                int day = this.calendar.get(7);
                this.calendar.add(2, MonthlyReminder.this.getIncrement());
                this.calendar.set(4, week);
                this.calendar.set(7, day);
            }
            Date date = this.calendar.getTime();
            if (MonthlyReminder.this.getEndDate() == null) {
                return date;
            }
            if (DateUtils.before(date, MonthlyReminder.this.getEndDate())) {
                return date;
            }
            return null;
        }
    }
}

