/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.recurring;

import java.util.Calendar;
import java.util.Date;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.ReminderType;
import jgnash.util.DateUtils;

public class YearlyReminder
extends Reminder {
    private static final long serialVersionUID = 8173755092984444499L;

    @Override
    public RecurringIterator getIterator() {
        return new YearlyIterator();
    }

    @Override
    public ReminderType getReminderType() {
        return ReminderType.YEARLY;
    }

    private class YearlyIterator
    implements RecurringIterator {
        private final Calendar calendar = Calendar.getInstance();

        public YearlyIterator() {
            if (YearlyReminder.this.getLastDate() != null) {
                this.calendar.setTime(YearlyReminder.this.getLastDate());
            } else {
                this.calendar.setTime(YearlyReminder.this.getStartDate());
                this.calendar.add(1, YearlyReminder.this.getIncrement() * -1);
            }
        }

        @Override
        public Date next() {
            this.calendar.add(1, YearlyReminder.this.getIncrement());
            Date date = this.calendar.getTime();
            if (YearlyReminder.this.getEndDate() == null) {
                return date;
            }
            if (DateUtils.before(date, YearlyReminder.this.getEndDate())) {
                return date;
            }
            return null;
        }
    }
}

