/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetResultsModel;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.message.MessageProxy;
import jgnash.ui.components.expandingtable.AbstractExpandingTableModel;
import jgnash.util.Resource;

public class ExpandingBudgetTableModel
extends AbstractExpandingTableModel<Account>
implements MessageListener {
    private static final String COLUMN_NAME = Resource.get().getString("Column.Account");
    private MessageProxy proxy = new MessageProxy();
    private Budget budget;
    private BudgetResultsModel model;

    public ExpandingBudgetTableModel(BudgetResultsModel model) {
        this.budget = model.getBudget();
        this.model = model;
        this.initializeModel();
        this.registerListeners();
    }

    public BudgetResultsModel getResultsModel() {
        return this.model;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public final synchronized void addMessageListener(MessageListener messageListener) {
        this.proxy.addMessageListener(messageListener);
    }

    public final synchronized void removeMessageListener(MessageListener messageListener) {
        this.proxy.removeMessageListener(messageListener);
    }

    private void registerListeners() {
        this.model.addMessageListener(this);
    }

    private void unregisterListeners() {
        this.model.removeMessageListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccount(Account account) {
        this.rwl.writeLock().lock();
        try {
            if (this.includeAccount(account)) {
                this.addNode(account);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private boolean includeAccount(Account account) {
        return this.model.includeAccount(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccount(Account account) {
        this.rwl.writeLock().lock();
        try {
            this.removeNode(account);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccountStructure() {
        this.rwl.writeLock().lock();
        try {
            this.initializeModel();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public final List<AccountGroup> getAccountGroups() {
        return this.model.getAccountGroupList();
    }

    public boolean contains(Account account) {
        return this.model.getAccounts().contains(account);
    }

    @Override
    public int getVisibleDepth(Account account) {
        int depth = 0;
        for (Account parent = account.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isExcludedFromBudget()) continue;
            ++depth;
        }
        return depth;
    }

    @Override
    public boolean isParent(Account account) {
        return account.isParent();
    }

    @Override
    public Collection<Account> getChildren(Account account) {
        return account.getChildren();
    }

    @Override
    protected Collection<Account> getModelObjects() {
        return this.model.getAccounts();
    }

    @Override
    public String getSearchString(Account object) {
        return object.getName();
    }

    @Override
    protected Account getRootObject() {
        Engine engine = EngineFactory.getEngine("default");
        return engine.getRootAccount();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Account)this.get(rowIndex)).getName();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAME;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Account getParent(Account object) {
        return object.getParent();
    }

    @Override
    public final void messagePosted(final Message message) {
        if (message.getEvent() == ChannelEvent.FILE_CLOSING) {
            this.clear();
            this.unregisterListeners();
            this.proxy.forwardMessage(message);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (message.getEvent()) {
                    case ACCOUNT_ADD: {
                        Account addAccount = (Account)message.getObject(MessageProperty.ACCOUNT);
                        ExpandingBudgetTableModel.this.addAccount(addAccount);
                        break;
                    }
                    case ACCOUNT_REMOVE: {
                        Account removeAccount = (Account)message.getObject(MessageProperty.ACCOUNT);
                        ExpandingBudgetTableModel.this.removeAccount(removeAccount);
                        break;
                    }
                    case ACCOUNT_MODIFY: {
                        ExpandingBudgetTableModel.this.updateAccountStructure();
                        break;
                    }
                    case BUDGET_UPDATE: {
                        if (!message.getObject(MessageProperty.BUDGET).equals(ExpandingBudgetTableModel.this.budget)) break;
                        ExpandingBudgetTableModel.this.updateAccountStructure();
                        break;
                    }
                }
                ExpandingBudgetTableModel.this.proxy.forwardMessage(message);
            }
        });
    }
}

