/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

final class PrintPreviewPanel
extends JPanel {
    private Printable printable;
    private PageFormat pageFormat;

    protected PrintPreviewPanel(Printable printable, PageFormat pageFormat) {
        assert (printable != null);
        this.setPageFormat(pageFormat);
        this.printable = printable;
        this.setLayout(null);
    }

    public void setPageFormat(PageFormat pageFormat) {
        assert (pageFormat != null);
        this.pageFormat = pageFormat;
        this.repaint();
    }

    public void setPrintable(Printable printable) {
        this.printable = printable;
    }

    @Override
    public void paintComponent(Graphics g) {
        double yOffset;
        double xOffset;
        double scale;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double px = this.pageFormat.getWidth();
        double py = this.pageFormat.getHeight();
        double sx = this.getWidth() - 1;
        double sy = this.getHeight() - 1;
        if (px / py < sx / sy) {
            scale = sy / py;
            xOffset = 0.5 * (sx - scale * px);
            yOffset = 0.0;
        } else {
            scale = sx / px;
            xOffset = 0.0;
            yOffset = 0.5 * (sy - scale * py);
        }
        g2.translate((float)xOffset, (float)yOffset);
        g2.scale((float)scale, (float)scale);
        Rectangle2D.Double page = new Rectangle2D.Double(0.0, 0.0, px, py);
        g2.setPaint(Color.WHITE);
        g2.fill(page);
        g2.setPaint(Color.BLACK);
        g2.draw(page);
        Rectangle2D.Double margin = new Rectangle2D.Double(this.pageFormat.getImageableX(), this.pageFormat.getImageableY(), this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight());
        g2.setPaint(Color.DARK_GRAY);
        g2.draw(margin);
        g2.setPaint(Color.BLACK);
        try {
            this.printable.print(g2, this.pageFormat, 0);
        }
        catch (PrinterException e) {
            Logger.getLogger(PrintPreviewPanel.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
        }
    }
}

