/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components.expandingtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import jgnash.ui.ThemeManager;
import jgnash.ui.components.expandingtable.AbstractExpandingTableModel;
import jgnash.ui.util.IconUtils;

public class ExpandingTable<E extends Comparable<? super E>>
extends JTable {
    private int iconIndent;
    private Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
    private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
    private int iconSpacing = 0;
    private final int selectionRange = this.getSelectionRange();
    private AtomicBoolean defaultSaved = new AtomicBoolean();
    protected Color defaultForeground;
    protected int defaultAlignment;
    AbstractExpandingTableModel<E> model;
    private static final int VERTICAL_ICON_PADDING = 5;
    private Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public ExpandingTable(AbstractExpandingTableModel<E> model) {
        super(model);
        this.model = model;
        this.iconIndent = this.expandedIcon.getIconWidth();
        if (ThemeManager.isLookAndFeelJGoodies() || ThemeManager.isLookAndFeelMotif()) {
            this.iconSpacing = 5;
        }
        this.setShowGrid(false);
        this.setRowHeight();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int range = ExpandingTable.this.selectionRange;
                Object object = ExpandingTable.this.getSelectedObject(point);
                if (object != null) {
                    range += ExpandingTable.this.iconIndent * ExpandingTable.this.model.getVisibleDepth(object);
                }
                if (e.getX() < range + 5) {
                    ExpandingTable.this.processMouseClicked(ExpandingTable.this.getSelectedObject(point));
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    ExpandingTable.this.processMouseClicked(ExpandingTable.this.getSelectedObject());
                }
            }

            @Override
            public void keyTyped(final KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExpandingTable.this.handleKeyboardSelect(e.getKeyChar());
                        }
                    });
                }
            }
        });
    }

    public E getSelectedObject(Point p) {
        E selected = null;
        int row = this.rowAtPoint(p);
        if (row >= 0) {
            selected = this.model.get(row);
        }
        return selected;
    }

    public E getSelectedObject() {
        E selected = null;
        int row = this.getSelectedRow();
        if (row >= 0) {
            selected = this.model.get(row);
        }
        return selected;
    }

    public void setSelectedObject(E object) {
        int index = this.model.indexOf(object);
        if (index >= 0) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private void processMouseClicked(E object) {
        if (object != null) {
            EventQueue.invokeLater(new Runnable((Comparable)object){
                final /* synthetic */ Comparable val$object;
                {
                    this.val$object = comparable;
                }

                @Override
                public void run() {
                    ExpandingTable.this.model.toggleExpansion(this.val$object);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExpandingTable.this.setSelectedObject(val$object);
                        }
                    });
                }
            });
        }
    }

    private void handleKeyboardSelect(char c) {
        int startRow = this.getSelectedRow();
        int lastRow = this.getRowCount() - 1;
        for (int currentRow = startRow + 1; currentRow != startRow; ++currentRow) {
            E object;
            String searchString;
            if (currentRow > lastRow) {
                currentRow = 0;
            }
            if ((searchString = this.model.getSearchString(object = this.model.get(currentRow))).length() <= 0 || Character.toUpperCase(searchString.charAt(0)) != Character.toUpperCase(c)) continue;
            this.setSelectedObject(object);
            break;
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JLabel) {
            if (!this.defaultSaved.get()) {
                this.defaultForeground = c.getForeground();
                this.defaultAlignment = ((JLabel)c).getHorizontalAlignment();
                this.defaultSaved.set(true);
            }
            E object = this.model.get(row);
            if (column == 0) {
                c.setForeground(this.defaultForeground);
                ((JLabel)c).setHorizontalAlignment(2);
                if (object != null) {
                    Icon cachedIcon;
                    int indent = this.iconIndent * (this.model.getVisibleDepth(object) - 1);
                    if (this.model.isParent(object)) {
                        if (this.model.isExpanded(object)) {
                            String key = "eo" + indent;
                            cachedIcon = this.iconCache.get(key);
                            if (cachedIcon == null) {
                                cachedIcon = IconUtils.createImageIcon(new IndentedIcon(new Icon[]{this.expandedIcon, this.openIcon}, indent, this.iconSpacing));
                                this.iconCache.put(key, cachedIcon);
                            }
                        } else {
                            String key = "co" + indent;
                            cachedIcon = this.iconCache.get(key);
                            if (cachedIcon == null) {
                                cachedIcon = IconUtils.createImageIcon(new IndentedIcon(new Icon[]{this.collapsedIcon, this.closedIcon}, indent, this.iconSpacing));
                                this.iconCache.put(key, cachedIcon);
                            }
                        }
                    } else {
                        String key = "el" + indent;
                        cachedIcon = this.iconCache.get(key);
                        if (cachedIcon == null) {
                            cachedIcon = IconUtils.createImageIcon(new IndentedIcon(new Icon[]{new EmptyIndentedIcon(new Icon[]{this.expandedIcon}, 0), this.leafIcon}, indent, this.iconSpacing));
                            this.iconCache.put(key, cachedIcon);
                        }
                    }
                    ((JLabel)c).setIcon(cachedIcon);
                }
            } else {
                c.setForeground(this.defaultForeground);
                ((JLabel)c).setHorizontalAlignment(this.defaultAlignment);
                ((JLabel)c).setIcon(null);
            }
        }
        return c;
    }

    private int getSelectionRange() {
        return Math.max(this.expandedIcon.getIconWidth(), this.collapsedIcon.getIconWidth());
    }

    private void setRowHeight() {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        int height = (int)Math.floor((float)((JLabel)((Object)new JTree().getCellRenderer())).getFont().getSize() * 1.0f / 72.0f * (float)dpi) + 2;
        if (this.openIcon != null) {
            height = Math.max(height, this.openIcon.getIconHeight() + 5);
        }
        if (this.closedIcon != null) {
            height = Math.max(height, this.closedIcon.getIconHeight() + 5);
        }
        if (this.leafIcon != null) {
            height = Math.max(height, this.leafIcon.getIconHeight() + 5);
        }
        if (this.collapsedIcon != null) {
            height = Math.max(height, this.collapsedIcon.getIconHeight() + 5);
        }
        if (this.expandedIcon != null) {
            height = Math.max(height, this.expandedIcon.getIconHeight() + 5);
        }
        this.setRowHeight(height);
    }

    private static class EmptyIndentedIcon
    implements Icon {
        private int height;
        private int width;

        public EmptyIndentedIcon(Icon[] referenceIcons, int indent) {
            for (Icon icon : referenceIcons) {
                if (icon == null) continue;
                this.width += icon.getIconWidth();
            }
            this.width += indent;
            for (Icon icon : referenceIcons) {
                if (icon == null) continue;
                this.height = Math.max(this.height, icon.getIconHeight());
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class IndentedIcon
    implements Icon {
        private Icon[] icons;
        private int indent;
        private int height;
        private int width;
        private int iconSpacing;

        public IndentedIcon(Icon[] icons, int indent, int iconSpacing) {
            this.icons = icons;
            this.indent = indent;
            this.iconSpacing = iconSpacing;
            for (Icon icon : icons) {
                if (icon == null) continue;
                this.width += icon.getIconWidth();
                this.width += iconSpacing;
            }
            this.width += indent;
            this.width -= iconSpacing;
            for (Icon icon : icons) {
                if (icon == null) continue;
                this.height = Math.max(this.height, icon.getIconHeight());
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int paintX = x + this.indent;
            for (Icon icon : this.icons) {
                if (icon == null) continue;
                int paintY = y;
                if (icon.getIconHeight() < this.getIconHeight()) {
                    paintY = this.getIconHeight() / 2 - icon.getIconHeight() / 2;
                }
                icon.paintIcon(c, g, paintX, y + paintY);
                paintX += icon.getIconWidth();
                paintX += this.iconSpacing;
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

