/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import java.text.DateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.recurring.PendingReminder;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class ReminderObjectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7267851227687408645L;
    private final Resource rb = Resource.get();
    private String[] cNames = new String[]{this.rb.getString("Column.Approve"), this.rb.getString("Column.Description"), this.rb.getString("Column.Date")};
    private List<PendingReminder> reminders = null;
    private DateFormat dateFormatter = DateUtils.getShortDateFormat();
    private char enabledSymbol = (char)10003;

    protected ReminderObjectTableModel(List<PendingReminder> reminders) {
        this.reminders = reminders;
    }

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public int getRowCount() {
        return this.reminders.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.cNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.reminders.get(rowIndex).isSelected()) {
                    return Character.valueOf(this.enabledSymbol);
                }
                return null;
            }
            case 1: {
                return this.reminders.get(rowIndex).getReminder().getDescription();
            }
            case 2: {
                return this.dateFormatter.format(this.reminders.get(rowIndex).getCommitDate());
            }
        }
        return null;
    }

    protected void toggleSelectedState(int index) {
        this.reminders.get(index).setSelected(!this.reminders.get(index).isSelected());
        this.fireTableRowsUpdated(index, index);
    }

    protected void setEnabledSymbol(char symbol) {
        this.enabledSymbol = symbol;
    }

    protected char getEnabledSymbol() {
        return this.enabledSymbol;
    }
}

