/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.engine.Account;
import jgnash.engine.TransactionEntry;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.invest.FeeTransactionEntryPanel;
import jgnash.ui.register.table.RegisterTable;
import jgnash.ui.register.table.SplitsRegisterTableModel;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;

public class FeesDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private final Resource rb = Resource.get();
    private SplitsRegisterTableModel model;
    private RegisterTable table;
    private FeeTransactionEntryPanel debitPanel;
    private boolean returnStatus = false;
    private JButton newButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JButton okButton;
    private JButton cancelButton;

    static FeesDialog getFeesDialog(Component c, Account account, List<TransactionEntry> splits) {
        Window parent = SwingUtilities.getWindowAncestor(c);
        if (parent instanceof Dialog) {
            return new FeesDialog((Dialog)parent, account, splits);
        }
        if (parent instanceof Frame) {
            return new FeesDialog((Frame)parent, account, splits);
        }
        return new FeesDialog((Frame)null, account, splits);
    }

    boolean showFeesDialog() {
        this.setVisible(true);
        return this.returnStatus;
    }

    private FeesDialog(Frame parent, Account account, List<TransactionEntry> splits) {
        super(parent, true);
        this.init(account, splits);
    }

    private FeesDialog(Dialog parent, Account account, List<TransactionEntry> splits) {
        super(parent, true);
        this.init(account, splits);
    }

    private void init(Account account, List<TransactionEntry> splits) {
        this.setTitle(this.rb.getString("Title.InvFees"));
        this.setDefaultCloseOperation(2);
        this.table = RegisterFactory.generateInvestmentFeesTable(account, splits);
        this.model = (SplitsRegisterTableModel)this.table.getModel();
        JTableUtils.packTable(this.table);
        this.layoutMainPanel();
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        this.newButton = new JButton(this.rb.getString("Button.New"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.deleteAllButton = new JButton(this.rb.getString("Button.DeleteAll"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteAllButton.addActionListener(this);
        this.debitPanel = new FeeTransactionEntryPanel(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("d:g", "80dlu:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JScrollPane(this.table));
        ButtonBarBuilder2 bbb = new ButtonBarBuilder2();
        bbb.addButton(new JComponent[]{this.newButton, this.deleteButton});
        bbb.addUnrelatedGap();
        bbb.addGlue();
        bbb.addButton((JComponent)this.deleteAllButton);
        builder.append((Component)bbb.getPanel());
        builder.append((Component)this.debitPanel);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okAction() {
        this.returnStatus = true;
        this.closeDialog();
    }

    private void deleteAction() {
        int index = this.table.getSelectedRow();
        if (index != -1) {
            this.model.removeTransaction(index);
        }
    }

    private void deleteAllAction() {
        for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
            this.model.removeTransaction(i);
        }
    }

    private void newAction() {
        this.debitPanel.clearForm();
        this.table.clearSelection();
    }

    private void modifyTransaction(int index) {
        TransactionEntry t = this.model.getTransactionAt(index);
        this.debitPanel.modifyTransaction(t);
    }

    public List<TransactionEntry> getSplits() {
        return this.model.getSplits();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.table.getSelectedRow();
        if (index != -1) {
            this.modifyTransaction(index);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this.deleteAllButton) {
            this.deleteAllAction();
        } else if (e.getSource() == this.newButton) {
            this.newAction();
        } else if (e.getSource() == this.okButton) {
            this.okAction();
        }
    }
}

