/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class Ole10Native {
    private final int totalSize;
    private short flags1;
    private final String label;
    private final String fileName;
    private short flags2;
    private byte[] unknown1;
    private byte[] unknown2;
    private final String command;
    private final int dataSize;
    private final byte[] dataBuffer;
    private short flags3;
    public static final String OLE10_NATIVE = "\u0001Ole10Native";

    public static Ole10Native createFromEmbeddedOleObject(POIFSFileSystem poifs) throws IOException, Ole10NativeException {
        return Ole10Native.createFromEmbeddedOleObject(poifs.getRoot());
    }

    public static Ole10Native createFromEmbeddedOleObject(DirectoryNode directory) throws IOException, Ole10NativeException {
        boolean plain = false;
        try {
            directory.getEntry("\u0001Ole10ItemName");
            plain = true;
        }
        catch (FileNotFoundException ex) {
            plain = false;
        }
        DocumentEntry nativeEntry = (DocumentEntry)directory.getEntry(OLE10_NATIVE);
        byte[] data = new byte[nativeEntry.getSize()];
        directory.createDocumentInputStream(nativeEntry).read(data);
        return new Ole10Native(data, 0, plain);
    }

    public Ole10Native(byte[] data, int offset) throws Ole10NativeException {
        this(data, offset, false);
    }

    public Ole10Native(byte[] data, int offset, boolean plain) throws Ole10NativeException {
        int ofs = offset;
        if (data.length < offset + 2) {
            throw new Ole10NativeException("data is too small");
        }
        this.totalSize = LittleEndian.getInt(data, ofs);
        ofs += 4;
        if (plain) {
            this.dataBuffer = new byte[this.totalSize - 4];
            System.arraycopy(data, 4, this.dataBuffer, 0, this.dataBuffer.length);
            this.dataSize = this.totalSize - 4;
            byte[] oleLabel = new byte[8];
            System.arraycopy(this.dataBuffer, 0, oleLabel, 0, Math.min(this.dataBuffer.length, 8));
            this.fileName = this.label = "ole-" + HexDump.toHex(oleLabel);
            this.command = this.label;
        } else {
            this.flags1 = LittleEndian.getShort(data, ofs);
            int len = Ole10Native.getStringLength(data, ofs += 2);
            this.label = StringUtil.getFromCompressedUnicode(data, ofs, len - 1);
            ofs += len;
            len = Ole10Native.getStringLength(data, ofs);
            this.fileName = StringUtil.getFromCompressedUnicode(data, ofs, len - 1);
            this.flags2 = LittleEndian.getShort(data, ofs += len);
            len = LittleEndian.getUnsignedByte(data, ofs += 2);
            this.unknown1 = new byte[len];
            ofs += len;
            len = 3;
            this.unknown2 = new byte[len];
            ofs += len;
            len = Ole10Native.getStringLength(data, ofs);
            this.command = StringUtil.getFromCompressedUnicode(data, ofs, len - 1);
            if (this.totalSize + 4 - (ofs += len) > 4) {
                this.dataSize = LittleEndian.getInt(data, ofs);
                ofs += 4;
                if (this.dataSize > this.totalSize || this.dataSize < 0) {
                    throw new Ole10NativeException("Invalid Ole10Native");
                }
                this.dataBuffer = new byte[this.dataSize];
                System.arraycopy(data, ofs, this.dataBuffer, 0, this.dataSize);
                ofs += this.dataSize;
                if (this.unknown1.length > 0) {
                    this.flags3 = LittleEndian.getShort(data, ofs);
                    ofs += 2;
                } else {
                    this.flags3 = 0;
                }
            } else {
                throw new Ole10NativeException("Invalid Ole10Native");
            }
        }
    }

    private static int getStringLength(byte[] data, int ofs) {
        int len = 0;
        while (len + ofs < data.length && data[ofs + len] != 0) {
            ++len;
        }
        return ++len;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public short getFlags1() {
        return this.flags1;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFileName() {
        return this.fileName;
    }

    public short getFlags2() {
        return this.flags2;
    }

    public byte[] getUnknown1() {
        return this.unknown1;
    }

    public byte[] getUnknown2() {
        return this.unknown2;
    }

    public String getCommand() {
        return this.command;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public short getFlags3() {
        return this.flags3;
    }
}

