/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

public class BinConverter {
    static final char[] HEXTAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int byteArrayToInt(byte[] buf, int nOfs) {
        return buf[nOfs] << 24 | (buf[nOfs + 1] & 0xFF) << 16 | (buf[nOfs + 2] & 0xFF) << 8 | buf[nOfs + 3] & 0xFF;
    }

    public static void intToByteArray(int nValue, byte[] buf, int nOfs) {
        buf[nOfs] = (byte)(nValue >>> 24 & 0xFF);
        buf[nOfs + 1] = (byte)(nValue >>> 16 & 0xFF);
        buf[nOfs + 2] = (byte)(nValue >>> 8 & 0xFF);
        buf[nOfs + 3] = (byte)nValue;
    }

    public static long byteArrayToLong(byte[] buf, int nOfs) {
        return (long)buf[nOfs] << 56 | ((long)buf[nOfs + 1] & 0xFFL) << 48 | ((long)buf[nOfs + 2] & 0xFFL) << 40 | ((long)buf[nOfs + 3] & 0xFFL) << 32 | ((long)buf[nOfs + 4] & 0xFFL) << 24 | ((long)buf[nOfs + 5] & 0xFFL) << 16 | ((long)buf[nOfs + 6] & 0xFFL) << 8 | (long)buf[nOfs + 7] & 0xFFL;
    }

    public static void longToByteArray(long lValue, byte[] buf, int nOfs) {
        buf[nOfs] = (byte)(lValue >>> 56);
        buf[nOfs + 1] = (byte)(lValue >>> 48 & (long)255);
        buf[nOfs + 2] = (byte)(lValue >>> 40 & (long)255);
        buf[nOfs + 3] = (byte)(lValue >>> 32 & (long)255);
        buf[nOfs + 4] = (byte)(lValue >>> 24 & (long)255);
        buf[nOfs + 5] = (byte)(lValue >>> 16 & (long)255);
        buf[nOfs + 6] = (byte)(lValue >>> 8 & (long)255);
        buf[nOfs + 7] = (byte)lValue;
    }

    public static long intArrayToLong(int[] buf, int nOfs) {
        return (long)buf[nOfs] << 32 | (long)buf[nOfs + 1] & 0xFFFFFFFFL;
    }

    public static void longToIntArray(long lValue, int[] buf, int nOfs) {
        buf[nOfs] = (int)(lValue >>> 32);
        buf[nOfs + 1] = (int)lValue;
    }

    public static long makeLong(int nLo, int nHi) {
        return (long)nHi << 32 | (long)nLo & 0xFFFFFFFFL;
    }

    public static int longLo32(long lVal) {
        return (int)lVal;
    }

    public static int longHi32(long lVal) {
        return (int)(lVal >>> 32);
    }

    public static String bytesToBinHex(byte[] data) {
        return BinConverter.bytesToBinHex(data, 0, data.length);
    }

    public static String bytesToBinHex(byte[] data, int nOfs, int nLen) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nLen << 1);
        int nPos = 0;
        int nC = nOfs + nLen;
        while (nOfs < nC) {
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs] >> 4 & 0xF]);
            sbuf.setCharAt(nPos++, HEXTAB[data[nOfs++] & 0xF]);
        }
        return sbuf.toString();
    }

    public static int binHexToBytes(String sBinHex, byte[] data, int nSrcOfs, int nDstOfs, int nLen) {
        int nOutputCapacity;
        int nStrLen = sBinHex.length();
        int nAvailBytes = nStrLen - nSrcOfs >> 1;
        if (nAvailBytes < nLen) {
            nLen = nAvailBytes;
        }
        if (nLen > (nOutputCapacity = data.length - nDstOfs)) {
            nLen = nOutputCapacity;
        }
        int nDstOfsBak = nDstOfs;
        for (int nI = 0; nI < nLen; ++nI) {
            int bActByte = 0;
            boolean blConvertOK = true;
            for (int nJ = 0; nJ < 2; ++nJ) {
                char cActChar;
                bActByte = (byte)(bActByte << 4);
                if ((cActChar = sBinHex.charAt(nSrcOfs++)) >= 'a' && cActChar <= 'f') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 97) + 10);
                    continue;
                }
                if (cActChar >= '0' && cActChar <= '9') {
                    bActByte = (byte)(bActByte | (byte)(cActChar - 48));
                    continue;
                }
                blConvertOK = false;
            }
            if (!blConvertOK) continue;
            data[nDstOfs++] = bActByte;
        }
        return nDstOfs - nDstOfsBak;
    }

    public static String byteArrayToUNCString(byte[] data, int nOfs, int nLen) {
        int nAvailCapacity = data.length - nOfs;
        if (nAvailCapacity < (nLen &= 0xFFFFFFFE)) {
            nLen = nAvailCapacity;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(nLen >> 1);
        int nSBufPos = 0;
        while (nLen > 0) {
            sbuf.setCharAt(nSBufPos++, (char)(data[nOfs] << 8 | data[nOfs + 1] & 0xFF));
            nOfs += 2;
            nLen -= 2;
        }
        return sbuf.toString();
    }
}

