/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.SortMerge;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTOCNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ComponentListener,
Serializable {
    protected JHelpTOCNavigator toc;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicTOCNavigatorUI;
    static /* synthetic */ Class class$javax$help$HelpSet;
    static /* synthetic */ Class class$java$lang$String;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTOCNavigatorUI((JHelpTOCNavigator)jComponent);
    }

    public BasicTOCNavigatorUI(JHelpTOCNavigator jHelpTOCNavigator) {
        BasicTOCNavigatorUI.debug(this + " " + "CreateUI - sort of");
        ImageIcon imageIcon = this.getImageIcon(jHelpTOCNavigator.getNavigatorView());
        if (imageIcon != null) {
            this.setIcon(imageIcon);
        } else {
            this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicTOCNavigatorUI == null ? (class$javax$help$plaf$basic$BasicTOCNavigatorUI = BasicTOCNavigatorUI.class$("javax.help.plaf.basic.BasicTOCNavigatorUI")) : class$javax$help$plaf$basic$BasicTOCNavigatorUI, "images/toc.gif"));
        }
    }

    public void installUI(JComponent jComponent) {
        BasicTOCNavigatorUI.debug(this + " " + "installUI");
        this.toc = (JHelpTOCNavigator)jComponent;
        HelpModel helpModel = this.toc.getModel();
        this.toc.setLayout(new BorderLayout());
        this.toc.addPropertyChangeListener(this);
        this.toc.addComponentListener(this);
        if (helpModel != null) {
            helpModel.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.toc.add("Center", this.sp);
        this.reloadData();
        BasicTOCNavigatorUI.debug("topTree is: " + this.topNode);
    }

    public void uninstallUI(JComponent jComponent) {
        BasicTOCNavigatorUI.debug(this + " " + "unistallUI");
        HelpModel helpModel = this.toc.getModel();
        this.toc.removeComponentListener(this);
        this.toc.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.toc.setLayout(null);
        this.toc.removeAll();
        if (helpModel != null) {
            helpModel.removeHelpModelListener(this);
        }
        this.toc = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new BasicTOCCellRenderer(map));
    }

    private void reloadData() {
        BasicTOCNavigatorUI.debug("reloadData");
        TOCView tOCView = (TOCView)this.toc.getNavigatorView();
        this.loadData(tOCView);
    }

    private void reloadData(HelpModel helpModel) {
        BasicTOCNavigatorUI.debug("reloadData using new model");
        TOCView tOCView = null;
        HelpSet helpSet = helpModel.getHelpSet();
        TOCView tOCView2 = (TOCView)this.toc.getNavigatorView();
        String string = tOCView2.getName();
        NavigatorView[] navigatorViewArray = helpSet.getNavigatorViews();
        int n = 0;
        while (n < navigatorViewArray.length) {
            NavigatorView navigatorView;
            if (navigatorViewArray[n].getName().equals(string) && (navigatorView = navigatorViewArray[n]) instanceof TOCView) {
                tOCView = (TOCView)navigatorView;
                break;
            }
            ++n;
        }
        this.loadData(tOCView);
    }

    private void loadData(TOCView tOCView) {
        if (tOCView == null) {
            BasicTOCNavigatorUI.debug("view is null");
            return;
        }
        this.topNode.removeAllChildren();
        String string = tOCView.getMergeType();
        Locale locale = tOCView.getHelpSet().getLocale();
        DefaultMutableTreeNode defaultMutableTreeNode = tOCView.getDataAsTree();
        if (string != null) {
            if (string.equals("sort")) {
                SortMerge.sortNode(defaultMutableTreeNode, locale);
            } else {
                MergeHelpUtilities.sortNode(defaultMutableTreeNode, locale);
            }
        } else {
            MergeHelpUtilities.sortNode(defaultMutableTreeNode, locale);
        }
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(tOCView, this.tree);
        this.addSubHelpSets(this.toc.getModel().getHelpSet());
        Map.ID iD = this.toc.getModel().getCurrentID();
        if (iD != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findID(this.topNode, iD);
            this.selectNode(defaultMutableTreeNode2);
        }
    }

    protected void addSubHelpSets(HelpSet helpSet) {
        Enumeration enumeration = helpSet.getHelpSets();
        while (enumeration.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
            NavigatorView[] navigatorViewArray = helpSet2.getNavigatorViews();
            int n = 0;
            while (n < navigatorViewArray.length) {
                if (this.toc.canMerge(navigatorViewArray[n])) {
                    this.merge(navigatorViewArray[n]);
                }
                ++n;
            }
            this.addSubHelpSets(helpSet2);
        }
    }

    private void expand(String string) {
        BasicTOCNavigatorUI.debug("expand called");
        Enumeration enumeration = this.findNodes(string).elements();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements()) {
            TreePath treePath;
            Object[] objectArray;
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicTOCNavigatorUI.debug("expandPath :" + defaultMutableTreeNode);
            if (defaultMutableTreeNode.getChildCount() > 0) {
                objectArray = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                treePath = new TreePath(objectArray.getPath());
                this.tree.makeVisible(treePath);
                continue;
            }
            objectArray = defaultMutableTreeNode.getPath();
            treePath = new TreePath(objectArray);
            this.tree.makeVisible(treePath);
        }
    }

    private Vector findNodes(String string) {
        Enumeration<TreeNode> enumeration = this.topNode.preorderEnumeration();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicTOCNavigatorUI.debug(" node :" + defaultMutableTreeNode.toString());
            if (defaultMutableTreeNode == null) continue;
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
            if (tOCItem == null) {
                BasicTOCNavigatorUI.debug("tocItem is null");
                continue;
            }
            Map.ID iD = tOCItem.getID();
            if (iD == null) continue;
            BasicTOCNavigatorUI.debug("id name :" + iD.id);
            BasicTOCNavigatorUI.debug("target :" + string);
            Map.ID iD2 = null;
            try {
                iD2 = Map.ID.create(string, this.toc.getModel().getHelpSet());
            }
            catch (BadIDException badIDException) {
                System.err.println("Not valid ID :" + string);
                break;
            }
            if (!iD.equals(iD2)) continue;
            vector.addElement(defaultMutableTreeNode);
        }
        return vector;
    }

    private void collapse(String string) {
        Enumeration enumeration = this.findNodes(string).elements();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        BasicTOCNavigatorUI.debug("collapse called");
        while (enumeration.hasMoreElements()) {
            TreePath treePath;
            Object[] objectArray;
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getChildCount() > 0) {
                objectArray = defaultMutableTreeNode.getPath();
                treePath = new TreePath(objectArray);
                this.tree.collapsePath(treePath);
                this.tree.collapseRow(this.tree.getRowForPath(treePath));
                continue;
            }
            objectArray = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            treePath = new TreePath(objectArray.getPath());
            this.tree.collapseRow(this.tree.getRowForPath(treePath));
        }
    }

    public void merge(NavigatorView navigatorView) {
        BasicTOCNavigatorUI.debug("merging " + navigatorView);
        if (navigatorView == null) {
            return;
        }
        Merge merge = Merge.DefaultMergeFactory.getMerge(this.toc.getNavigatorView(), navigatorView);
        if (merge != null) {
            merge.processMerge(this.topNode);
        }
        this.addSubHelpSets(navigatorView.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        TOCView tOCView = (TOCView)navigatorView;
        this.setCellRenderer(tOCView, this.tree);
    }

    public void remove(NavigatorView navigatorView) {
        BasicTOCNavigatorUI.debug("removing " + navigatorView);
        this.remove(this.topNode, navigatorView.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(navigatorView, this.tree);
    }

    private void remove(DefaultMutableTreeNode defaultMutableTreeNode, HelpSet helpSet) {
        BasicTOCNavigatorUI.debug("remove(" + defaultMutableTreeNode + ", " + helpSet + ")");
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicTOCNavigatorUI.debug("  considering " + defaultMutableTreeNode2);
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode2.getUserObject();
            HelpSet helpSet2 = tOCItem.getHelpSet();
            BasicTOCNavigatorUI.debug("chs=" + helpSet2 + " hs.contains(chs)=" + helpSet.contains(helpSet2));
            if (helpSet2 != null && helpSet.contains(helpSet2)) {
                if (defaultMutableTreeNode2.isLeaf()) {
                    BasicTOCNavigatorUI.debug("  tagging for removal: " + defaultMutableTreeNode2);
                    vector.addElement(defaultMutableTreeNode2);
                    continue;
                }
                this.remove(defaultMutableTreeNode2, helpSet);
                if (defaultMutableTreeNode2.isLeaf()) {
                    BasicTOCNavigatorUI.debug("  tagging for removal: " + defaultMutableTreeNode2);
                    vector.addElement(defaultMutableTreeNode2);
                    continue;
                }
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild();
                TOCItem tOCItem2 = (TOCItem)defaultMutableTreeNode3.getUserObject();
                tOCItem.setHelpSet(tOCItem2.getHelpSet());
                BasicTOCNavigatorUI.debug("  orphaned children - changing hs: " + defaultMutableTreeNode2);
                continue;
            }
            this.remove(defaultMutableTreeNode2, helpSet);
        }
        int n = 0;
        while (n < vector.size()) {
            BasicTOCNavigatorUI.debug("  removing " + vector.elementAt(n));
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector.elementAt(n));
            ++n;
        }
    }

    private void setVisibility(DefaultMutableTreeNode defaultMutableTreeNode) {
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        int n = treePath.getPathCount();
        if (defaultMutableTreeNode == this.topNode || n <= 2 || tOCItem != null && tOCItem.getExpansionType() == 1) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            if (!defaultMutableTreeNode.isLeaf()) {
                int n2 = defaultMutableTreeNode.getChildCount();
                int n3 = 0;
                while (n3 < n2) {
                    this.setVisibility((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3));
                    ++n3;
                }
            }
        }
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD;
        DefaultMutableTreeNode defaultMutableTreeNode;
        TOCItem tOCItem;
        Object object;
        TreePath treePath;
        Map.ID iD2 = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        HelpModel helpModel = this.toc.getModel();
        BasicTOCNavigatorUI.debug("idChanged(" + helpModelEvent + ")");
        if (helpModelEvent.getSource() != helpModel) {
            BasicTOCNavigatorUI.debug("Internal inconsistency!");
            BasicTOCNavigatorUI.debug("  " + helpModelEvent.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (iD2 == null) {
            // empty if block
        }
        if ((treePath = this.tree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (tOCItem = (TOCItem)(defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) != null && (iD = tOCItem.getID()) != null && iD.equals(iD2)) {
            return;
        }
        object = this.findID(this.topNode, iD2);
        this.selectNode((DefaultMutableTreeNode)object);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD) {
        BasicTOCNavigatorUI.debug("findID: (" + iD + ")");
        BasicTOCNavigatorUI.debug("  node: " + defaultMutableTreeNode);
        if (iD == null) {
            return null;
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null) {
            Map.ID iD2 = tOCItem.getID();
            BasicTOCNavigatorUI.debug("  testID: " + iD2);
            if (iD2 != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findID(defaultMutableTreeNode2, iD);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    private void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.toc;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TOCItem tOCItem;
        Object object;
        JHelpNavigator jHelpNavigator = this.getHelpNavigator();
        HelpModel helpModel = jHelpNavigator.getModel();
        BasicTOCNavigatorUI.debug("ValueChanged: " + treeSelectionEvent);
        BasicTOCNavigatorUI.debug("  model: " + helpModel);
        TreeItem[] treeItemArray = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            treeItemArray = new TreeItem[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                if (treePathArray[n] != null) {
                    object = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                    treeItemArray[n] = (TreeItem)((DefaultMutableTreeNode)object).getUserObject();
                }
                ++n;
            }
        }
        jHelpNavigator.setSelectedItems(treeItemArray);
        if (treeItemArray != null && treeItemArray.length == 1 && (tOCItem = (TOCItem)treeItemArray[0]) != null && tOCItem.getID() != null) {
            Presentation presentation;
            object = tOCItem.getPresentation();
            if (object == null) {
                try {
                    helpModel.setCurrentID(tOCItem.getID(), tOCItem.getName(), jHelpNavigator);
                }
                catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                    System.err.println("BadID: " + tOCItem.getID());
                    return;
                }
            }
            HelpSet helpSet = helpModel.getHelpSet();
            Class[] classArray = new Class[]{class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = BasicTOCNavigatorUI.class$("javax.help.HelpSet")) : class$javax$help$HelpSet, class$java$lang$String == null ? (class$java$lang$String = BasicTOCNavigatorUI.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{helpSet, tOCItem.getPresentationName()};
            try {
                ClassLoader classLoader = helpSet.getLoader();
                Class<?> clazz = classLoader == null ? Class.forName((String)object) : classLoader.loadClass((String)object);
                Method method = clazz.getMethod("getPresentation", classArray);
                presentation = (Presentation)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("error invoking presentation");
            }
            if (presentation == null) {
                return;
            }
            if (presentation instanceof WindowPresentation) {
                ((WindowPresentation)presentation).setActivationObject(this.tree);
            }
            if (presentation instanceof Popup) {
                ((Popup)presentation).setInvokerInternalBounds(this.tree.getPathBounds(treePathArray[0]));
                ((Popup)presentation).setInvoker(this.tree);
            }
            try {
                presentation.setCurrentID(tOCItem.getID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                System.err.println("BadID: " + tOCItem.getID());
                return;
            }
            presentation.setDisplayed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicTOCNavigatorUI.debug(this + " " + "propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.toc) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData((HelpModel)propertyChangeEvent.getNewValue());
            } else if (string.equals("font")) {
                BasicTOCNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            } else if (string.equals("expand")) {
                BasicTOCNavigatorUI.debug("Expand change");
                this.expand((String)propertyChangeEvent.getNewValue());
            } else if (string.equals("collapse")) {
                BasicTOCNavigatorUI.debug("Collapse change");
                this.collapse((String)propertyChangeEvent.getNewValue());
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.tree.requestFocus();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    protected static void debug(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

