/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class ColorPanel
extends JPanel
implements ActionListener {
    JTextField colorDisplay = new JTextField();
    private Color defaultColor;
    private Vector listeners = new Vector(0);

    public ColorPanel(String title, Color col) {
        super(new BorderLayout(5, 5));
        this.defaultColor = col;
        this.colorDisplay.setBackground(col);
        Dimension dim = new Dimension(20, 15);
        this.colorDisplay.setMinimumSize(dim);
        this.colorDisplay.setMaximumSize(dim);
        this.colorDisplay.setPreferredSize(dim);
        this.colorDisplay.setEditable(false);
        JButton browseButton = new JButton();
        browseButton.setText("...");
        dim = new Dimension(20, 15);
        browseButton.setMinimumSize(dim);
        browseButton.setMaximumSize(dim);
        browseButton.setPreferredSize(dim);
        browseButton.addActionListener(this);
        JPanel eastPanel = new JPanel(new FlowLayout());
        eastPanel.add(this.colorDisplay);
        eastPanel.add(browseButton);
        if (title != null && title.length() > 0) {
            JLabel titleLabel = new JLabel(title);
            titleLabel.setFont(UIManager.getFont("TextField.font"));
            this.add((Component)titleLabel, "West");
            this.add((Component)eastPanel, "East");
        } else {
            this.add((Component)eastPanel, "West");
        }
    }

    public Color getColor() {
        return this.colorDisplay.getBackground();
    }

    public void setColor(Color color) {
        this.colorDisplay.setBackground(color);
        this.fireColorChanged();
    }

    public void actionPerformed(ActionEvent e) {
        JColorChooser cc = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Select Color", this.colorDisplay.getBackground());
        if (color != null) {
            this.setColor(color);
        }
    }

    public void addColorPanelListener(ColorPanelListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeColorPanelListener(ColorPanelListener listener) {
        this.listeners.removeElement(listener);
    }

    void fireColorChanged() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((ColorPanelListener)listenerList.nextElement()).colorChanged(new ColorPanelEvent(this));
        }
    }

    static interface ColorPanelListener
    extends EventListener {
        public void colorChanged(ColorPanelEvent var1);
    }

    class ColorPanelEvent
    extends EventObject {
        public ColorPanelEvent(Object source) {
            super(source);
        }
    }
}

