/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.mydragonfly.pj.DragonflyJournal;
import org.mydragonfly.pj.EntryForm;
import org.mydragonfly.pj.util.StringUtil;

public class OptionsDialog
extends JDialog {
    static final Logger logger = Logger.getLogger(OptionsDialog.class);
    private static final long serialVersionUID = 1850643922751346315L;
    private JLabel backupLoc_lbl;
    private JLabel backupFreq_lbl;
    private JTextField backupDir_Field;
    private JComboBox backupFreq_CBX;
    private JLabel lookAndFeel_lbl;
    private JButton ok_btn;
    private JButton browse_Btn;
    private JComboBox lookAndFeel_CBX;
    ArrayList<LAFInfo> plafinfo = this.convertToLafInfo(UIManager.getInstalledLookAndFeels());
    private JButton cancel_btn;

    public OptionsDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        this.loadData();
    }

    private void initGUI() {
        this.backupLoc_lbl = new JLabel();
        this.add(this.backupLoc_lbl);
        this.backupLoc_lbl.setName("backupDir_lbl");
        this.backupDir_Field = new JTextField(170);
        this.add(this.backupDir_Field);
        this.backupDir_Field.setName("backupDir_Field");
        this.browse_Btn = new JButton();
        this.add(this.browse_Btn);
        this.browse_Btn.setName("browse_Btn");
        this.browse_Btn.setAction(this.getAppActionMap().get("browseBackupLocButton"));
        this.backupFreq_lbl = new JLabel();
        this.add(this.backupFreq_lbl);
        this.backupFreq_lbl.setName("backupFreq_lbl");
        this.backupFreq_CBX = new JComboBox<DragonflyJournal.BackupSchedules>(DragonflyJournal.BackupSchedules.values());
        this.add(this.backupFreq_CBX);
        this.backupFreq_CBX.setName("backupFreq_CBX");
        this.lookAndFeel_lbl = new JLabel();
        this.add(this.lookAndFeel_lbl);
        this.lookAndFeel_lbl.setName("lookAndFeel_lbl");
        this.lookAndFeel_CBX = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.plafinfo.toArray()));
        this.add(this.lookAndFeel_CBX);
        this.lookAndFeel_CBX.setName("lookAndFeel_CBX");
        this.ok_btn = new JButton();
        this.ok_btn.setName("ok_btn");
        this.ok_btn.setAction(this.getAppActionMap().get("okButton"));
        this.cancel_btn = new JButton();
        this.cancel_btn.setName("cancel_btn");
        this.cancel_btn.setAction(this.getAppActionMap().get("cancelButton"));
        JPanel jPanel = new JPanel((LayoutManager)new FormLayout("4dlu, 50dlu, 4dlu, 50dlu, 4dlu", "2dlu,pref,2dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)this.ok_btn, cellConstraints.xy(2, 2));
        jPanel.add((Component)this.cancel_btn, cellConstraints.xy(4, 2));
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, 100dlu, 4dlu, 50dlu, 4dlu, 50dlu, 8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 8dlu");
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.add((Component)this.backupLoc_lbl, cellConstraints2.xy(2, 2));
        this.add((Component)this.backupDir_Field, new CellConstraints(4, 2, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT));
        this.add((Component)this.backupFreq_lbl, cellConstraints2.xy(2, 4));
        this.add((Component)this.backupFreq_CBX, cellConstraints2.xy(4, 4));
        this.add((Component)this.browse_Btn, cellConstraints2.xy(8, 2));
        this.add((Component)this.lookAndFeel_lbl, cellConstraints2.xy(2, 6));
        this.add((Component)this.lookAndFeel_CBX, cellConstraints2.xy(4, 6));
        this.add((Component)jPanel, cellConstraints2.rcw(14, 2, 8, CellConstraints.CENTER, CellConstraints.CENTER));
        Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents(this.getContentPane());
        this.pack();
    }

    protected void loadData() {
        DragonflyJournal.BackupSchedules backupSchedules;
        DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
        this.backupDir_Field.setText(StringUtil.blankNull((String)dragonflyJournal.userPrefs.get(DragonflyJournal.UserOptionParams.BackupDir.name())));
        try {
            backupSchedules = (DragonflyJournal.BackupSchedules)((Object)dragonflyJournal.userPrefs.get(DragonflyJournal.UserOptionParams.BackupSch.name()));
        }
        catch (Exception exception) {
            backupSchedules = DragonflyJournal.BackupSchedules.Never;
        }
        this.backupFreq_CBX.setSelectedItem((Object)backupSchedules);
        try {
            String string = EntryForm.formatter.format(((Calendar)dragonflyJournal.userPrefs.get(DragonflyJournal.UserOptionParams.BACKUP_LAST_DATE.name())).getTime());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "n/a";
        }
        LAFInfo lAFInfo = new LAFInfo((String)dragonflyJournal.userPrefs.get(DragonflyJournal.UserOptionParams.LookAndFeel.name()), "");
        this.lookAndFeel_CBX.setSelectedItem(lAFInfo);
    }

    private ArrayList<LAFInfo> convertToLafInfo(UIManager.LookAndFeelInfo[] lookAndFeelInfoArray) {
        ArrayList<LAFInfo> arrayList = new ArrayList<LAFInfo>(lookAndFeelInfoArray.length);
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray) {
            arrayList.add(new LAFInfo(lookAndFeelInfo));
        }
        return arrayList;
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap(this);
    }

    @Action
    public void okButton() {
        DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
        LAFInfo lAFInfo = (LAFInfo)this.lookAndFeel_CBX.getSelectedItem();
        String string = lAFInfo != null ? lAFInfo.getName() : null;
        logger.debug((Object)("lookName=" + string));
        dragonflyJournal.userPrefs.put(DragonflyJournal.UserOptionParams.LookAndFeel.name(), string);
        dragonflyJournal.userPrefs.put(DragonflyJournal.UserOptionParams.BackupSch.name(), this.backupFreq_CBX.getSelectedItem());
        dragonflyJournal.userPrefs.put(DragonflyJournal.UserOptionParams.BackupDir.name(), this.backupDir_Field.getText());
        this.dispose();
    }

    @Action
    public void cancelButton() {
        this.dispose();
    }

    @Action
    public void browseBackupLocButton() {
        DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
        String string = (String)dragonflyJournal.userPrefs.get(DragonflyJournal.UserOptionParams.BackupDir.name());
        JFileChooser jFileChooser = new JFileChooser(new File(string));
        jFileChooser.setFileSelectionMode(1);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directory";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.backupDir_Field.setText(file.getAbsolutePath());
            logger.debug((Object)("backup loc: " + file.getAbsolutePath()));
        }
    }

    class LAFInfo
    extends UIManager.LookAndFeelInfo {
        public LAFInfo(String string, String string2) {
            super(string, string2);
        }

        public LAFInfo(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            super(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
        }

        @Override
        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof LAFInfo) {
                LAFInfo lAFInfo = (LAFInfo)object;
                return lAFInfo.getName().equalsIgnoreCase(this.getName()) || lAFInfo.getClassName().equalsIgnoreCase(this.getClassName());
            }
            return false;
        }
    }
}

