/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.gtdfree.gui.IntervalFieldPanel;
import org.gtdfree.journal.JournalEntry;

public class JournalEntryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JournalEntry journalEntry;
    private JTextPane commentText;
    private IntervalFieldPanel intervalPanel;

    public JournalEntryPanel() {
        this.initialize();
    }

    public JournalEntryPanel(JournalEntry e) {
        this();
        this.setJournalEntry(e);
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.commentText = new JTextPane();
        this.commentText.setOpaque(true);
        this.commentText.setBackground(Color.WHITE);
        this.commentText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JournalEntryPanel.this.journalEntry.setComment(JournalEntryPanel.this.commentText.getText());
            }
        });
        this.add((Component)this.commentText, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 4, 1, 4), 0, 0));
        this.intervalPanel = new IntervalFieldPanel();
        this.add((Component)this.intervalPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 4, 1, 4), 0, 0));
    }

    public void setJournalEntry(JournalEntry journalEntry) {
        this.journalEntry = journalEntry;
        this.commentText.setText(journalEntry.getComment());
        this.intervalPanel.setEntry(journalEntry);
    }

    public void release() {
        this.intervalPanel.setEntry(null);
        this.journalEntry = null;
    }
}

