/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.gtdfree.Messages;
import org.gtdfree.gui.AbstractFilterPanel;
import org.gtdfree.model.RemindFilter;
import org.gtdfree.model.Utils;

public class TickleFilterPanel
extends AbstractFilterPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton allRadio;
    private JRadioButton pastRadio;
    private JPanel criterions;
    private JRadioButton weekRadio;
    private JRadioButton monthRadio;
    private JRadioButton yearRadio;
    private CardLayout cards;
    private Map<Integer, WeekdayToggleButton> daysOfWeek = new HashMap<Integer, WeekdayToggleButton>(7);
    private ButtonGroup viewGroup;
    private DateFormatSymbols symbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
    private Map<Integer, DayOfMonthToggleButton> daysOfMonth = new HashMap<Integer, DayOfMonthToggleButton>(31);
    private Map<Integer, MonthToggleButton> months = new HashMap<Integer, MonthToggleButton>(12);
    private SimpleDateFormat dayFormat = new SimpleDateFormat("EEE, d MMM yyyy");
    private SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM yyyy");
    private JPanel weekPanel;
    private JPanel monthPanel;
    private JPanel yearPanel;
    private Dimension weekPref;
    protected Dimension yearPref;

    public TickleFilterPanel() {
        this.initialize();
    }

    private void initialize() {
        JToggleButton tb;
        int i;
        this.setLayout(new GridBagLayout());
        this.cards = new CardLayout();
        this.criterions = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                if (TickleFilterPanel.this.weekRadio.isSelected()) {
                    return TickleFilterPanel.this.criterions.getComponent(2).getPreferredSize();
                }
                if (TickleFilterPanel.this.monthRadio.isSelected()) {
                    return TickleFilterPanel.this.criterions.getComponent(3).getPreferredSize();
                }
                if (TickleFilterPanel.this.yearRadio.isSelected()) {
                    return TickleFilterPanel.this.criterions.getComponent(4).getPreferredSize();
                }
                return new Dimension(0, 0);
            }
        };
        this.criterions.setLayout(this.cards);
        JLabel jl = new JLabel(Messages.getString("TickleFilterPanel.Tickler") + " ");
        this.add((Component)jl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.viewGroup = new ButtonGroup();
        this.allRadio = new JRadioButton(Messages.getString("TickleFilterPanel.All"));
        this.allRadio.setToolTipText(Messages.getString("TickleFilterPanel.All.desc"));
        this.allRadio.setSelected(true);
        this.allRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TickleFilterPanel.this.cards.show(TickleFilterPanel.this.criterions, Messages.getString("TickleFilterPanel.All"));
                    TickleFilterPanel.this.fireSearch(null);
                }
            }
        });
        this.viewGroup.add(this.allRadio);
        this.add((Component)this.allRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pastRadio = new JRadioButton(Messages.getString("TickleFilterPanel.Past"));
        this.pastRadio.setToolTipText(Messages.getString("TickleFilterPanel.Past.desc"));
        this.pastRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TickleFilterPanel.this.cards.show(TickleFilterPanel.this.criterions, Messages.getString("TickleFilterPanel.Past"));
                    TickleFilterPanel.this.fireSearchPast(Utils.today());
                }
            }
        });
        this.viewGroup.add(this.pastRadio);
        this.add((Component)this.pastRadio, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.weekRadio = new JRadioButton(Messages.getString("TickleFilterPanel.Week"));
        this.weekRadio.setToolTipText(Messages.getString("TickleFilterPanel.Week.desc"));
        this.weekRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TickleFilterPanel.this.cards.show(TickleFilterPanel.this.criterions, Messages.getString("TickleFilterPanel.Week"));
                    TickleFilterPanel.this.updateWeekPanel();
                }
            }
        });
        this.viewGroup.add(this.weekRadio);
        this.add((Component)this.weekRadio, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.monthRadio = new JRadioButton(Messages.getString("TickleFilterPanel.Month"));
        this.monthRadio.setToolTipText(Messages.getString("TickleFilterPanel.Month.desc"));
        this.monthRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TickleFilterPanel.this.cards.show(TickleFilterPanel.this.criterions, Messages.getString("TickleFilterPanel.Month"));
                    TickleFilterPanel.this.updateMonthPanel();
                    TickleFilterPanel.this.doLayout();
                }
            }
        });
        this.viewGroup.add(this.monthRadio);
        this.add((Component)this.monthRadio, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.yearRadio = new JRadioButton(Messages.getString("TickleFilterPanel.Year"));
        this.yearRadio.setToolTipText(Messages.getString("TickleFilterPanel.Year.desc"));
        this.yearRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TickleFilterPanel.this.cards.show(TickleFilterPanel.this.criterions, Messages.getString("TickleFilterPanel.Year"));
                    TickleFilterPanel.this.updateYearPanel();
                }
            }
        });
        this.viewGroup.add(this.yearRadio);
        this.add((Component)this.yearRadio, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.criterions.add((Component)new JPanel(), Messages.getString("TickleFilterPanel.All"));
        this.criterions.add((Component)new JPanel(), Messages.getString("TickleFilterPanel.Past"));
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridBagLayout());
        String[] names = this.symbols.getWeekdays();
        for (i = 1; i < names.length; ++i) {
            tb = new WeekdayToggleButton(names[i]);
            this.daysOfWeek.put(i, (WeekdayToggleButton)tb);
        }
        this.weekPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (TickleFilterPanel.this.weekPref == null || ((TickleFilterPanel)TickleFilterPanel.this).weekPref.width == 0) {
                    TickleFilterPanel.this.weekPref = TickleFilterPanel.this.weekPanel.getPreferredSize();
                }
                if (((TickleFilterPanel)TickleFilterPanel.this).weekPref.width > ((TickleFilterPanel)TickleFilterPanel.this).weekPanel.getSize().width) {
                    for (WeekdayToggleButton b : TickleFilterPanel.this.daysOfWeek.values()) {
                        b.useShortName();
                    }
                } else {
                    for (WeekdayToggleButton b : TickleFilterPanel.this.daysOfWeek.values()) {
                        b.useLongName();
                    }
                }
            }
        });
        this.criterions.add((Component)this.weekPanel, Messages.getString("TickleFilterPanel.Week"));
        this.monthPanel = new JPanel();
        this.monthPanel.setLayout(new GridBagLayout());
        for (i = 1; i < 32; ++i) {
            tb = new DayOfMonthToggleButton(i);
            this.daysOfMonth.put(i, (DayOfMonthToggleButton)tb);
        }
        this.monthPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TickleFilterPanel.this.updateMonthPanel();
            }
        });
        JScrollPane jsp = new JScrollPane(this.monthPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = this.getViewport().getView().getMinimumSize();
                Dimension r = null;
                r = this.getHorizontalScrollBar().isVisible() ? new Dimension(d.width, d.height + this.getHorizontalScrollBar().getPreferredSize().height) : new Dimension(d.width, d.height);
                return r;
            }
        };
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(21);
        this.criterions.add((Component)jsp, Messages.getString("TickleFilterPanel.Month"));
        this.yearPanel = new JPanel();
        this.yearPanel.setLayout(new GridBagLayout());
        this.yearPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (TickleFilterPanel.this.yearPref == null || TickleFilterPanel.this.yearPref.width == 0) {
                    TickleFilterPanel.this.yearPref = TickleFilterPanel.this.yearPanel.getPreferredSize();
                }
                if (TickleFilterPanel.this.yearPref.width > ((TickleFilterPanel)TickleFilterPanel.this).yearPanel.getSize().width) {
                    for (MonthToggleButton b : TickleFilterPanel.this.months.values()) {
                        b.useShortName();
                    }
                } else {
                    for (MonthToggleButton b : TickleFilterPanel.this.months.values()) {
                        b.useLongName();
                    }
                }
            }
        });
        names = this.symbols.getMonths();
        for (int i2 = 0; i2 < 12; ++i2) {
            MonthToggleButton tb2 = new MonthToggleButton(names[i2]);
            this.months.put(i2, tb2);
        }
        this.criterions.add((Component)this.yearPanel, Messages.getString("TickleFilterPanel.Year"));
        this.add((Component)this.criterions, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void updateWeekPanel() {
        GregorianCalendar c = new GregorianCalendar();
        long start = Utils.today(c);
        int day = c.get(7);
        WeekdayToggleButton tb = this.daysOfWeek.get(day);
        if (this.weekPanel.getComponentCount() != 7 || this.weekPanel.getComponent(0) != tb) {
            long end;
            WeekdayToggleButton dtb;
            int i;
            this.weekPanel.removeAll();
            int index = 0;
            for (i = day; i < 8; ++i) {
                dtb = this.daysOfWeek.get(i);
                end = start + 86400000L;
                dtb.setDates(start, end);
                dtb.setToolTipText(this.dayFormat.format(new Date(start)));
                this.weekPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                start = end;
            }
            for (i = 1; i < day; ++i) {
                dtb = this.daysOfWeek.get(i);
                end = start + 86400000L;
                dtb.setDates(start, end);
                dtb.setToolTipText(this.dayFormat.format(new Date(start)));
                this.weekPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                start = end;
            }
        }
        tb.fireSearch(true);
    }

    protected void updateMonthPanel() {
        GregorianCalendar c = new GregorianCalendar();
        Utils.today(c);
        int day = c.get(5);
        int max = c.getActualMaximum(5);
        DayOfMonthToggleButton tb = this.daysOfMonth.get(day);
        if (this.monthPanel.getComponentCount() < 20 || this.monthPanel.getComponent(0) != tb) {
            DayOfMonthToggleButton dtb;
            int i;
            this.monthPanel.removeAll();
            int index = 0;
            for (i = day; i <= max; ++i) {
                c.set(5, i);
                dtb = this.daysOfMonth.get(i);
                dtb.setDates(c.getTimeInMillis(), c.getTimeInMillis() + 86400000L);
                dtb.setToolTipText(this.dayFormat.format(new Date(c.getTimeInMillis())));
                this.monthPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            c.set(5, 1);
            c.set(2, c.get(2) + 1);
            for (i = 1; i < day; ++i) {
                c.set(5, i);
                dtb = this.daysOfMonth.get(i);
                dtb.setDates(c.getTimeInMillis(), c.getTimeInMillis() + 86400000L);
                dtb.setToolTipText(this.dayFormat.format(new Date(c.getTimeInMillis())));
                this.monthPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        tb.fireSearch(true);
    }

    protected void updateYearPanel() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(5, 1);
        c.set(14, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(11, 0);
        int month = c.get(2);
        MonthToggleButton tb = this.months.get(month);
        if (this.yearPanel.getComponentCount() != 12 || this.yearPanel.getComponent(0) != tb) {
            long start;
            MonthToggleButton dtb;
            int i;
            this.yearPanel.removeAll();
            int index = 0;
            for (i = month; i < 12; ++i) {
                c.set(2, i);
                dtb = this.months.get(i);
                dtb.setToolTipText(this.monthFormat.format(new Date(c.getTimeInMillis())));
                this.yearPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                start = c.getTimeInMillis();
                c.set(2, i + 1);
                dtb.setDates(start, c.getTimeInMillis());
            }
            for (i = 0; i < month; ++i) {
                c.set(2, i);
                dtb = this.months.get(i);
                dtb.setToolTipText(this.monthFormat.format(new Date(c.getTimeInMillis())));
                this.yearPanel.add((Component)dtb, new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                start = c.getTimeInMillis();
                c.set(2, i + 1);
                dtb.setDates(start, c.getTimeInMillis());
            }
        }
        tb.fireSearch(true);
    }

    private void fireSearch(long start, long end) {
        this.fireSearch(new RemindFilter(start, end));
    }

    private void fireSearchPast(long end) {
        this.fireSearch(new RemindFilter(end, true));
    }

    @Override
    protected void clearFilters() {
        this.allRadio.setSelected(true);
        for (WeekdayToggleButton b : this.daysOfWeek.values()) {
            b.setSelected(false);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag) {
            this.clearFilters();
            this.fireSearch(null);
        }
        super.setVisible(flag);
    }

    public void selectPast() {
        this.pastRadio.setSelected(true);
    }

    public void selectToday() {
        this.weekRadio.setSelected(true);
    }

    class DayOfMonthToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;
        private long start;
        private long end;

        public DayOfMonthToggleButton(int code) {
            super(String.valueOf(code));
            this.setMargin(new Insets(0, 1, 0, 1));
            this.setToolTipText(this.getText());
            this.setSelected(false);
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DayOfMonthToggleButton.this.fireSearch(false);
                }
            });
        }

        public void fireSearch(boolean select) {
            if (select && !this.isSelected()) {
                this.setSelected(true);
                return;
            }
            if (this.isSelected()) {
                for (DayOfMonthToggleButton b : TickleFilterPanel.this.daysOfMonth.values()) {
                    if (!b.isSelected() || b == this) continue;
                    b.setSelected(false);
                }
                TickleFilterPanel.this.fireSearch(this.start, this.end);
            } else {
                for (DayOfMonthToggleButton b : TickleFilterPanel.this.daysOfMonth.values()) {
                    if (!b.isSelected()) continue;
                    return;
                }
                TickleFilterPanel.this.fireSearch(null);
            }
        }

        public void setDates(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }

    class MonthToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;
        private String longName;
        private String shortName;
        private long start;
        private long end;

        public MonthToggleButton(String name) {
            super(name);
            this.longName = name;
            this.shortName = name.substring(0, 3);
            this.setMargin(new Insets(0, 1, 0, 1));
            this.setToolTipText(this.getText());
            this.setSelected(false);
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MonthToggleButton.this.fireSearch(false);
                }
            });
        }

        public void fireSearch(boolean select) {
            if (select && !this.isSelected()) {
                this.setSelected(true);
                return;
            }
            if (this.isSelected()) {
                for (MonthToggleButton b : TickleFilterPanel.this.months.values()) {
                    if (!b.isSelected() || b == this) continue;
                    b.setSelected(false);
                }
                TickleFilterPanel.this.fireSearch(this.start, this.end);
            } else {
                for (MonthToggleButton b : TickleFilterPanel.this.months.values()) {
                    if (!b.isSelected()) continue;
                    return;
                }
                TickleFilterPanel.this.fireSearch(null);
            }
        }

        public void useShortName() {
            this.setText(this.shortName);
        }

        public void useLongName() {
            this.setText(this.longName);
        }

        public void setDates(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }

    class WeekdayToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;
        private String longName;
        private String shortName;
        private long end;
        private long start;

        public WeekdayToggleButton(String name) {
            super(name);
            this.longName = name;
            this.shortName = name.substring(0, 3);
            this.setMargin(new Insets(0, 1, 0, 1));
            this.setToolTipText(this.getText());
            this.setSelected(false);
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WeekdayToggleButton.this.fireSearch(false);
                }
            });
        }

        public void fireSearch(boolean select) {
            if (select && !this.isSelected()) {
                this.setSelected(true);
                return;
            }
            if (this.isSelected()) {
                for (WeekdayToggleButton b : TickleFilterPanel.this.daysOfWeek.values()) {
                    if (!b.isSelected() || b == this) continue;
                    b.setSelected(false);
                }
                TickleFilterPanel.this.fireSearch(this.start, this.end);
            } else {
                for (WeekdayToggleButton b : TickleFilterPanel.this.daysOfWeek.values()) {
                    if (!b.isSelected()) continue;
                    return;
                }
                TickleFilterPanel.this.fireSearch(null);
            }
        }

        public void useShortName() {
            this.setText(this.shortName);
        }

        public void useLongName() {
            this.setText(this.longName);
        }

        public void setDates(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

