/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gtdfree.html.Attribute;
import org.gtdfree.html.Structure;
import org.gtdfree.html.TAG;

public class HTMLStreamWriter
implements XMLStreamWriter {
    private static final String EOL = "\n";
    private XMLStreamWriter wx;
    private Writer wr;

    public static HTMLStreamWriter newInstance(OutputStream out) throws IOException, XMLStreamException, FactoryConfigurationError {
        OutputStreamWriter wr = new OutputStreamWriter(out, "UTF-8");
        XMLStreamWriter wx = XMLOutputFactory.newInstance().createXMLStreamWriter(wr);
        return new HTMLStreamWriter(wx, wr);
    }

    private HTMLStreamWriter(XMLStreamWriter wx, Writer wr) {
        this.wx = wx;
        this.wr = wr;
    }

    @Override
    public void close() throws XMLStreamException {
        this.wx.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.wx.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return null;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.wx.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.wx.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.wx.writeCData(data);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.wx.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.wx.writeCharacters(text, start, len);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.wx.writeComment(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.wx.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.wx.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.wx.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.wx.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.wx.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.wx.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.wx.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.wx.writeStartElement(prefix, localName, namespaceURI);
    }

    public void startHtmlDocument(String title) throws XMLStreamException, IOException {
        this.writeUnescaped("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        this.writenl();
        this.wx.writeStartElement("HTML");
        this.wx.writeCharacters(EOL);
        this.wx.writeStartElement("HEAD");
        this.wx.writeCharacters(EOL);
        if (title != null) {
            this.wx.writeStartElement("TITLE");
            this.wx.writeCharacters(title);
            this.wx.writeEndElement();
        }
        this.wx.writeCharacters(EOL);
        this.writeUnescaped("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.writenl();
    }

    public void writeUnescaped(String meta) throws XMLStreamException, IOException {
        this.wx.flush();
        this.wr.write(meta);
        this.wr.flush();
    }

    public void startHtmlBody() throws XMLStreamException {
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
        this.wx.writeStartElement(TAG.BODY.getName());
        this.wx.writeCharacters(EOL);
    }

    public void writeTag(String tag, String value) throws XMLStreamException {
        this.wx.writeStartElement(tag);
        this.wx.writeCharacters(value);
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
    }

    public void writeHr() throws XMLStreamException, IOException {
        this.writeUnescaped("<HR>");
        this.wx.writeCharacters(EOL);
    }

    public void writeBr() throws XMLStreamException, IOException {
        this.writeUnescaped("<BR>");
        this.wx.writeCharacters(EOL);
    }

    public void startTag(String tag) throws XMLStreamException {
        this.wx.writeStartElement(tag);
    }

    public void startTag(TAG tag) throws XMLStreamException {
        this.wx.writeStartElement(tag.getName());
        for (Attribute attribute : tag) {
            this.wx.writeAttribute(attribute.toString(), tag.getAttribute(attribute));
        }
    }

    public void writeTag(TAG tag, String val) throws XMLStreamException {
        this.startTag(tag);
        this.wx.writeCharacters(val);
        this.endTag();
    }

    public void writeTag(TAG a) throws XMLStreamException {
        if (a.getAttributeCount() > 0) {
            this.startTag(a);
            this.endTag();
        } else {
            this.wx.writeEmptyElement(a.getName());
        }
    }

    public void endTag() throws XMLStreamException {
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
    }

    public void writeTableRow(String ... cells) throws XMLStreamException {
        this.wx.writeStartElement(TAG.TR.getName());
        for (String c : cells) {
            this.wx.writeStartElement(TAG.TD.getName());
            this.wx.writeCharacters(c);
            this.wx.writeEndElement();
        }
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
    }

    public void writeTableRow(String[] cells, TAG[] tags) throws XMLStreamException {
        this.wx.writeStartElement(TAG.TR.getName());
        for (int i = 0; i < cells.length; ++i) {
            this.startTag(tags[i]);
            this.wx.writeCharacters(cells[i]);
            this.wx.writeEndElement();
        }
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
    }

    public void endHtmlDocument() throws XMLStreamException {
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
        this.wx.writeEndElement();
        this.wx.writeCharacters(EOL);
    }

    public void writenl() throws XMLStreamException {
        this.wx.writeCharacters(EOL);
    }

    public void writeStyleRule(String selector, String declaration) throws XMLStreamException {
        this.wx.writeCharacters(selector);
        this.wx.writeCharacters(" { ");
        this.wx.writeCharacters(declaration);
        this.wx.writeCharacters(" } ");
        this.wx.writeCharacters(EOL);
    }

    public void writeMultiline(String s) throws XMLStreamException {
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, EOL);
        while (st.hasMoreTokens()) {
            this.wx.writeCharacters(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            this.writeTag(TAG.BR);
        }
    }

    public void writeStructure(Structure s) throws XMLStreamException {
        for (Structure st : s) {
            this.writeStructureElement(st);
        }
    }

    public void writeStructureElement(Structure s) throws XMLStreamException {
        if (s != null) {
            if (s.getType() == Structure.ElementType.TAG_START) {
                this.startTag(s.getTag());
            } else if (s.getType() == Structure.ElementType.TAG) {
                this.writeTag(s.getTag());
            } else if (s.getType() == Structure.ElementType.TAG_END) {
                this.writeEndElement();
            } else if (s.getType() == Structure.ElementType.TEXT) {
                this.writeCharacters(s.getText());
            }
        }
    }
}

