/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.flat;

import java.awt.BorderLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.objectbrowser.flat.FlatQueryTableModel;
import org.neodatis.odb.gui.objectbrowser.flat.TableToolTipHeader;

public class FlatQueryResultPanel
extends JPanel {
    public FlatQueryResultPanel(IStorageEngine engine, String fullClassName, Collection objectInfoValues) {
        this.init(engine, fullClassName, objectInfoValues);
    }

    private void init(IStorageEngine engine, String fullClassName, Collection objectInfoValues) {
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout(4, 4));
        FlatQueryTableModel model = new FlatQueryTableModel(engine, fullClassName, objectInfoValues);
        JTable table = new JTable(model);
        table.setAutoResizeMode(0);
        this.initTable(table, model.getAttributeList(), model.getValueList());
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(32);
        this.add(pane);
    }

    private void initTable(JTable table, List attributeNames, List valueList) {
        TableToolTipHeader tth = new TableToolTipHeader(table.getColumnModel());
        tth.setToolTipsText(attributeNames.toArray(new String[attributeNames.size()]));
        tth.setToolTipText("Default ToolTip text");
        table.setTableHeader(tth);
        TableColumn column = null;
        int[] sizes = this.estimateColumnSizes(valueList, table.getColumnCount());
        for (int i = 0; i < table.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            int dataWidth = sizes[i];
            int titleWidth = Math.min(80, attributeNames.get(i).toString().length());
            int realWidth = Math.max(dataWidth, titleWidth) * 6 + 10;
            column.setPreferredWidth(realWidth);
        }
    }

    private int[] estimateColumnSizes(List valueList, int numberOfColumns) {
        int[] sizes = new int[numberOfColumns];
        for (int i = 0; i < valueList.size(); ++i) {
            List l = (List)valueList.get(i);
            for (int j = 0; j < numberOfColumns; ++j) {
                int length;
                Object o;
                if (l.size() <= j || (o = l.get(j)) == null || (length = o.toString().length()) <= sizes[j]) continue;
                sizes[j] = length;
            }
        }
        return sizes;
    }
}

