/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.AbstractDateTimeDV;
import com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDateTimeException;

public class DurationDV
extends AbstractDateTimeDV {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return new AbstractDateTimeDV.DateTimeData(this.parse(content), this);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "duration"});
        }
    }

    protected int[] parse(String str) throws SchemaDateTimeException {
        int end;
        char c;
        int len = str.length();
        int[] date = new int[8];
        int start = 0;
        if ((c = str.charAt(start++)) != 'P' && c != '-') {
            throw new SchemaDateTimeException();
        }
        int n = date[7] = c == '-' ? 45 : 0;
        if (c == '-' && str.charAt(start++) != 'P') {
            throw new SchemaDateTimeException();
        }
        int negate = 1;
        if (date[7] == 45) {
            negate = -1;
        }
        boolean designator = false;
        int endDate = this.indexOf(str, start, len, 'T');
        if (endDate == -1) {
            endDate = len;
        }
        if ((end = this.indexOf(str, start, endDate, 'Y')) != -1) {
            date[0] = negate * this.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if ((end = this.indexOf(str, start, endDate, 'M')) != -1) {
            date[1] = negate * this.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if ((end = this.indexOf(str, start, endDate, 'D')) != -1) {
            date[2] = negate * this.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if (len == endDate && start != len) {
            throw new SchemaDateTimeException();
        }
        if (len != endDate) {
            if ((end = this.indexOf(str, ++start, len, 'H')) != -1) {
                date[3] = negate * this.parseInt(str, start, end);
                start = end + 1;
                designator = true;
            }
            if ((end = this.indexOf(str, start, len, 'M')) != -1) {
                date[4] = negate * this.parseInt(str, start, end);
                start = end + 1;
                designator = true;
            }
            if ((end = this.indexOf(str, start, len, 'S')) != -1) {
                int mlsec = this.indexOf(str, start, end, '.');
                if (mlsec > 0) {
                    date[5] = negate * this.parseInt(str, start, mlsec);
                    date[6] = negate * this.parseInt(str, mlsec + 1, end);
                } else {
                    date[5] = negate * this.parseInt(str, start, end);
                }
                start = end + 1;
                designator = true;
            }
            if (start != len || str.charAt(--start) == 'T') {
                throw new SchemaDateTimeException();
            }
        }
        if (!designator) {
            throw new SchemaDateTimeException();
        }
        return date;
    }

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        int[] tempB;
        short resultB = 2;
        short resultA = this.compareOrder(date1, date2);
        if (resultA == 0) {
            return 0;
        }
        int[][] result = new int[2][8];
        int[] tempA = this.addDuration(date1, DATETIMES[0], result[0]);
        resultA = this.compareOrder(tempA, tempB = this.addDuration(date2, DATETIMES[0], result[1]));
        if (resultA == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, DATETIMES[1], result[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, DATETIMES[1], result[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, DATETIMES[2], result[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, DATETIMES[2], result[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, DATETIMES[3], result[0]);
        tempB = this.addDuration(date2, DATETIMES[3], result[1]);
        resultB = this.compareOrder(tempA, tempB);
        resultA = this.compareResults(resultA, resultB, strict);
        return resultA;
    }

    private short compareResults(short resultA, short resultB, boolean strict) {
        if (resultB == 2) {
            return 2;
        }
        if (resultA != resultB && strict) {
            return 2;
        }
        if (resultA != resultB && !strict) {
            if (resultA != 0 && resultB != 0) {
                return 2;
            }
            return resultA != 0 ? resultA : resultB;
        }
        return resultA;
    }

    private int[] addDuration(int[] date, int[] addto, int[] duration) {
        this.resetDateObj(duration);
        int temp = addto[1] + date[1];
        duration[1] = this.modulo(temp, 1, 13);
        int carry = this.fQuotient(temp, 1, 13);
        duration[0] = addto[0] + date[0] + carry;
        temp = addto[5] + date[5];
        carry = this.fQuotient(temp, 60);
        duration[5] = this.mod(temp, 60, carry);
        temp = addto[4] + date[4] + carry;
        carry = this.fQuotient(temp, 60);
        duration[4] = this.mod(temp, 60, carry);
        temp = addto[3] + date[3] + carry;
        carry = this.fQuotient(temp, 24);
        duration[3] = this.mod(temp, 24, carry);
        duration[2] = addto[2] + date[2] + carry;
        while (true) {
            temp = this.maxDayInMonthFor(duration[0], duration[1]);
            if (duration[2] < 1) {
                duration[2] = duration[2] + this.maxDayInMonthFor(duration[0], duration[1] - 1);
                carry = -1;
            } else {
                if (duration[2] <= temp) break;
                duration[2] = duration[2] - temp;
                carry = 1;
            }
            temp = duration[1] + carry;
            duration[1] = this.modulo(temp, 1, 13);
            duration[0] = duration[0] + this.fQuotient(temp, 1, 13);
        }
        duration[7] = 90;
        return duration;
    }

    protected String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(30);
        int negate = 1;
        if (date[0] < 0) {
            message.append('-');
            negate = -1;
        }
        message.append('P');
        message.append(negate * date[0]);
        message.append('Y');
        message.append(negate * date[1]);
        message.append('M');
        message.append(negate * date[2]);
        message.append('D');
        message.append('T');
        message.append(negate * date[3]);
        message.append('H');
        message.append(negate * date[4]);
        message.append('M');
        message.append(negate * date[5]);
        message.append('.');
        message.append(negate * date[6]);
        message.append('S');
        return message.toString();
    }
}

