/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.infocardOrganizer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.infoml.infocardOrganizer.InfocardBuilder;
import org.infoml.infocardOrganizer.LargeCellEditor;
import org.infoml.infocardOrganizer.MainFrame;
import org.infoml.infocardOrganizer.NotecardModel;
import org.infoml.infocardOrganizer.SharedContentModel;
import org.infoml.infocardOrganizer.TransferableNode;
import org.infoml.infocardOrganizer.UniqueContentModel;
import org.infoml.jaxb.InfomlType;
import org.infoml.jaxb.SimpleRichTextType;

public class DragAndDropTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Serializable,
KeyListener,
MouseListener {
    DragSource dragSource;
    static DragSourceContext context;
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode celery;
    final MainFrame mainFr;
    NotecardModel content;
    UniqueContentModel model2;
    SharedContentModel shared;
    LargeCellEditor thisEditor;
    Vector way;
    TreePath editPath;
    TreePath currentPath;

    public DragAndDropTree(DefaultMutableTreeNode root, DragSource dragSource, MainFrame mainFr) {
        super(root);
        this.root = root;
        this.dragSource = dragSource;
        this.mainFr = mainFr;
        this.setEditable(true);
        this.setRootVisible(false);
        this.addKeyListener(this);
        this.setShowsRootHandles(true);
        this.thisEditor = new LargeCellEditor((JTree)this, (DefaultTreeCellRenderer)this.getCellRenderer(), mainFr);
        this.setCellEditor(this.thisEditor);
        this.setInvokesStopCellEditing(true);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.editPath == null) {
            this.editPath = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
        }
        this.currentPath = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (this.thisEditor.justEdited) {
            this.updateAfterEdit((DefaultMutableTreeNode)this.editPath.getLastPathComponent());
            this.mainFr.doSave();
            if (this.currentPath != null) {
                this.setSelectionPath(this.currentPath);
            }
            this.thisEditor.justEdited = false;
        }
        this.editPath = this.currentPath;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    void updateAfterEdit(DefaultMutableTreeNode selected) {
        NotecardModel m = null;
        if (this.mainFr.notecards.get(selected) != null) {
            m = (NotecardModel)this.mainFr.notecards.get(selected);
            m.setTitle((String)selected.getUserObject());
            this.mainFr.notecards.remove(selected);
            this.mainFr.notecards.put(selected, m);
            MainFrame.equalizer.setMainFr(this.mainFr);
            MainFrame.equalizer.setModifiedNotecardModel(m);
            MainFrame.equalizer.setModifiedInfomlType((InfomlType)this.mainFr.infocards.get(m));
            MainFrame.equalizer.equalizeNotecards();
            MainFrame.equalizer.run();
        } else if (this.mainFr.uniqueContent.get(selected) != null) {
            m = (UniqueContentModel)this.mainFr.uniqueContent.get(selected);
            m.setTitle((String)selected.getUserObject());
            this.mainFr.uniqueContent.remove(selected);
            this.mainFr.uniqueContent.put(selected, m);
            MainFrame.equalizer.setMainFr(this.mainFr);
            MainFrame.equalizer.setModifiedInfomlType((InfomlType)this.mainFr.infocards.get(m));
            MainFrame.equalizer.setModifiedContentcardModel((UniqueContentModel)m);
            MainFrame.equalizer.equalizeContentcards();
            MainFrame.equalizer.run();
        }
        InfomlType infocard = (InfomlType)this.mainFr.infocards.get(m);
        try {
            SimpleRichTextType srt = InfocardBuilder.objFactory.createSimpleRichTextType();
            srt.getContent().add(m.getTitle());
            infocard.getData().setTitle(srt);
        }
        catch (Exception excep) {
            excep.printStackTrace();
        }
        this.mainFr.infocards.remove(m);
        this.mainFr.infocards.put(m, infocard);
        int index = this.mainFr.infomlFile.if1.getInfoml().indexOf(infocard);
        this.mainFr.infomlFile.if1.getInfoml().remove(index);
        this.mainFr.infomlFile.if1.getInfoml().add(index, infocard);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.getSelectionPath() != null) {
            DefaultMutableTreeNode selected;
            if (e.getKeyCode() == 127 && this.mainFr.infoWindow.tree.getSelectionPath() != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
                this.mainFr.infoWindow.removeNode();
            }
            if (e.getKeyCode() == 10) {
                selected = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
                if (((String)selected.getUserObject()).compareTo("") == 0) {
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(selected);
                    return;
                }
                this.updateAfterEdit(selected);
                this.mainFr.doSave();
            }
            if (e.getKeyCode() == 32) {
                this.mainFr.doSave();
                selected = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
                int index = selected.getParent().getIndex(selected);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("");
                ((DefaultTreeModel)this.getModel()).insertNodeInto(newNode, (DefaultMutableTreeNode)selected.getParent(), index + 1);
                this.scrollPathToVisible(new TreePath(newNode.getPath()));
                NotecardModel pModel = (NotecardModel)this.mainFr.notecards.get((DefaultMutableTreeNode)selected.getParent());
                if (pModel == null) {
                    pModel = (NotecardModel)this.mainFr.uniqueContent.get((DefaultMutableTreeNode)selected.getParent());
                }
                NotecardModel model = new NotecardModel();
                model.setTitle("");
                InfocardBuilder infocardBuilder = new InfocardBuilder(this.mainFr.infomlFile, model);
                infocardBuilder.generateCardId();
                MainFrame.setupModel.increaseSequenceNumber("Space released");
                MainFrame.serializator.run();
                infocardBuilder.setStandardInfocard();
                infocardBuilder.setCardId();
                infocardBuilder.setCreator(MainFrame.setupModel);
                infocardBuilder.setDateCreated();
                this.mainFr.infomlFile.if1.getInfoml().add(infocardBuilder.infocard);
                this.mainFr.infomlFile.hasChanged = true;
                this.mainFr.notecards.put(newNode, model);
                this.mainFr.infocards.put(model, infocardBuilder.infocard);
                this.startEditingAtPath(new TreePath(newNode.getPath()));
                this.scrollPathToVisible(new TreePath(newNode.getPreviousSibling().getPath()));
                this.editPath = this.getEditingPath();
            }
            if (e.getKeyCode() == 27) {
                Enumeration<TreeNode> nodes = this.root.preorderEnumeration();
                while (nodes.hasMoreElements()) {
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodes.nextElement();
                    if (!((String)currentNode.getUserObject()).equals("")) continue;
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(currentNode);
                    NotecardModel model = (NotecardModel)this.mainFr.notecards.get(currentNode);
                    InfomlType infocard = (InfomlType)this.mainFr.infocards.get(model);
                    this.mainFr.notecards.remove(currentNode);
                    this.mainFr.infocards.remove(model);
                    this.mainFr.infomlFile.if1.getInfoml().remove(infocard);
                    this.mainFr.infomlFile.hasChanged = true;
                }
            }
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (this.getPathForLocation(e.getDragOrigin().x, e.getDragOrigin().y) != null && this.getSelectionPath() != null) {
            DefaultMutableTreeNode node;
            this.celery = node = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
            TransferableNode transferable = new TransferableNode();
            transferable.node = node;
            int number = 0;
            Enumeration<TreeNode> enu = ((DefaultMutableTreeNode)node.getRoot()).preorderEnumeration();
            while (enu.hasMoreElements()) {
                enu.nextElement();
                ++number;
            }
            transferable.identifier3 = number;
            transferable.identifier4 = this.mainFr.getBounds();
            Enumeration<TreeNode> enumer = node.preorderEnumeration();
            while (enumer.hasMoreElements()) {
                DefaultMutableTreeNode elem = (DefaultMutableTreeNode)enumer.nextElement();
                NotecardModel m2 = (NotecardModel)this.mainFr.notecards.get(elem);
                if (m2 != null) {
                    transferable.models.put(elem, m2);
                    transferable.modelTypes.put(m2, "notecard");
                } else {
                    m2 = (NotecardModel)this.mainFr.uniqueContent.get(elem);
                    transferable.models.put(elem, m2);
                    transferable.modelTypes.put(m2, "contentcard");
                }
                transferable.cardIds.addElement(m2.getCardId());
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            TreeNode[] nodeArray = model.getPathToRoot(node);
            transferable.nodeIndex = new int[nodeArray.length];
            transferable.nodeIndex[0] = 0;
            for (int i = 1; i < nodeArray.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodeArray[i];
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)currentNode.getParent();
                transferable.nodeIndex[i] = model.getIndexOfChild(parent, currentNode);
            }
            transferable.identifier1 = this.root.getFirstChild().toString();
            transferable.identifier2 = this.root.getLastChild().toString();
            NotecardModel transferModel = null;
            transferModel = (NotecardModel)this.mainFr.notecards.get(node);
            transferable.transferModelType = "notecard";
            if (transferModel == null) {
                transferModel = (NotecardModel)this.mainFr.uniqueContent.get(node);
                transferable.transferModelType = "contentcard";
            }
            transferable.transferModel = transferModel;
            transferable.cardId = transferModel.cardId;
            Cursor cursor = this.selectCursor(e.getDragAction());
            this.dragSource.startDrag(e, cursor, transferable, this);
            this.repaint();
        }
    }

    private Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        DragSourceContext backUpContext = e.getDragSourceContext();
        if (backUpContext != null) {
            context = e.getDragSourceContext();
        }
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        context = e.getDragSourceContext();
        context.setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        DragSourceContext backUpContext = e.getDragSourceContext();
        if (backUpContext != null) {
            context = e.getDragSourceContext();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.mainFr.setDropStatusText("   ...");
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        JComponent dropTargetComp = (JComponent)((DropTarget)dtde.getSource()).getComponent();
        Transferable transferable = dtde.getTransferable();
        TransferableNode transfer = null;
        try {
            transfer = (TransferableNode)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultMutableTreeNode draggedNode = null;
        if (transferable != null) {
            draggedNode = transfer.node;
        }
        Point loc = dtde.getLocation();
        TreePath path = this.getPathForLocation(loc.x, loc.y);
        Rectangle rect = this.getPathBounds(path);
        if (path == null) {
            context.setCursor(DragSource.DefaultMoveDrop);
            this.mainFr.setDropStatusText("Drop as last node");
        } else {
            DefaultMutableTreeNode nodeAtLoc = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.destinationNodeInDropNodeFamily(nodeAtLoc, draggedNode, transfer.cardIds)) {
                this.mainFr.setDropStatusText("Destination node in drop node branch or Drop node in destination node branch - Not allowed - ");
                context.setCursor(DragSource.DefaultMoveNoDrop);
            } else if (nodeAtLoc.equals(this.root.getFirstChild()) && loc.y < rect.height / 2) {
                this.mainFr.setDropStatusText("drop as first node in the window");
            } else if (loc.x < rect.x + 23) {
                this.mainFr.setDropStatusText("Drop as sibling of : " + (String)nodeAtLoc.getUserObject());
                context.setCursor(DragSource.DefaultLinkDrop);
            } else {
                this.mainFr.setDropStatusText("Drop as child of : " + (String)nodeAtLoc.getUserObject());
                context.setCursor(DragSource.DefaultLinkDrop);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public boolean destinationNodeInDropNodeFamily(DefaultMutableTreeNode destination, DefaultMutableTreeNode droped, Vector dropedIds) {
        Vector<String> destIds = new Vector<String>();
        NotecardModel m = null;
        for (DefaultMutableTreeNode link = destination; link != null; link = (DefaultMutableTreeNode)link.getParent()) {
            m = (NotecardModel)this.mainFr.uniqueContent.get(link);
            if (m != null) {
                destIds.addElement(m.getCardId());
                continue;
            }
            m = (NotecardModel)this.mainFr.notecards.get(link);
            if (m == null) continue;
            destIds.addElement(m.getCardId());
        }
        Enumeration<TreeNode> e = destination.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            m = (NotecardModel)this.mainFr.uniqueContent.get(node);
            if (m != null) {
                destIds.addElement(m.getCardId());
                continue;
            }
            m = (NotecardModel)this.mainFr.notecards.get(node);
            destIds.addElement(m.getCardId());
        }
        for (int i = 0; i < dropedIds.size(); ++i) {
            for (int j = 0; j < destIds.size(); ++j) {
                if (((String)dropedIds.elementAt(i)).compareTo((String)destIds.elementAt(j)) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void modifySubTreeInStructures(DefaultMutableTreeNode node, DefaultMutableTreeNode transferNode) {
        Enumeration<TreeNode> transfer = transferNode.preorderEnumeration();
        Enumeration<TreeNode> enumer = node.preorderEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            Object notecardTrue = this.mainFr.notecards.remove(node);
            Object contentcardTrue = this.mainFr.uniqueContent.remove(node);
            if (notecardTrue != null) {
                this.mainFr.notecards.put(transfer.nextElement(), notecardTrue);
                this.mainFr.stateSaver.models.add(notecardTrue);
                continue;
            }
            if (contentcardTrue == null) continue;
            this.mainFr.uniqueContent.put(transfer.nextElement(), contentcardTrue);
            this.mainFr.stateSaver.models.add(contentcardTrue);
        }
    }

    public void addSubTreeToStructures(TransferableNode transfer) {
        Enumeration<TreeNode> enumer = transfer.node.preorderEnumeration();
        while (enumer.hasMoreElements()) {
            String type = null;
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumer.nextElement();
            NotecardModel currentModel = (NotecardModel)transfer.models.get(currentNode);
            type = (String)transfer.modelTypes.get(currentModel);
            if (type.compareTo("notecard") == 0) {
                this.mainFr.notecards.put(currentNode, currentModel);
                type = "notecard";
                this.mainFr.stateSaver.models.add(currentModel);
            }
            if (type.compareTo("contentcard") == 0) {
                currentModel = (UniqueContentModel)transfer.models.get(currentNode);
                UniqueContentModel uniqueModel = (UniqueContentModel)currentModel;
                this.mainFr.uniqueContent.put(currentNode, currentModel);
                type = "contentcard";
                MainFrame.sharedContent.put(uniqueModel.shared.getNickname(), uniqueModel.shared);
                this.mainFr.quickContentCardAction.setEnabled(true);
                this.mainFr.stateSaver.models.add(currentModel);
            }
            InfocardBuilder infocardBuilder = new InfocardBuilder(this.mainFr.infomlFile, currentModel);
            infocardBuilder.setStandardInfocard();
            infocardBuilder.infocard.setCardId(currentModel.cardId);
            infocardBuilder.setContent();
            infocardBuilder.setTitle();
            infocardBuilder.setSelectors();
            infocardBuilder.setNotes1();
            infocardBuilder.setNotes2();
            infocardBuilder.setCreator(MainFrame.setupModel);
            infocardBuilder.setDateCreated();
            if (type.compareTo("notecard") == 0) {
                this.mainFr.infocards.put(currentModel, infocardBuilder.infocard);
            }
            if (type.compareTo("contentcard") != 0) continue;
            this.model2 = new UniqueContentModel();
            this.shared = new SharedContentModel();
            this.model2.setShared(this.shared);
            this.model2.setTitle(currentModel.getTitle());
            this.model2.setContentString(currentModel.getContentString());
            this.model2.setContentList(this.model2.getContentString());
            this.model2.setSelectorsString(currentModel.getSelectorsString());
            this.model2.setSelectorsList(this.model2.getSelectorsString());
            this.model2.setNotes1String(currentModel.getNotes1String());
            this.model2.setNotes1List(this.model2.getNotes1String());
            this.model2.setNotes2String(currentModel.getNotes2String());
            this.model2.setNotes2List(this.model2.getNotes2String());
            infocardBuilder.setExactQuotation();
            infocardBuilder.setPages();
            infocardBuilder.setContainerNamePart1();
            infocardBuilder.setContainerNamePart2();
            infocardBuilder.setContainerDate();
            infocardBuilder.setAgentX(this.model2.shared.getAgent1());
            infocardBuilder.agentType = null;
            infocardBuilder.setAgentX(this.model2.shared.getAgent2());
            infocardBuilder.agentType = null;
            infocardBuilder.setAgentX(this.model2.shared.getAgent3());
            infocardBuilder.agentType = null;
            infocardBuilder.setAgentX(this.model2.shared.getAgent4());
            infocardBuilder.agentType = null;
            infocardBuilder.setEnclosingAgentX(this.model2.shared.getAgent5());
            infocardBuilder.agentType = null;
            infocardBuilder.setEnclosingAgentX(this.model2.shared.getAgent6());
            infocardBuilder.agentType = null;
            infocardBuilder.setEnclosingContainerVolumeIssue();
            infocardBuilder.setEnclosingContainerTitle();
            infocardBuilder.setCorporateAgent();
            this.mainFr.infocards.put(this.model2, infocardBuilder.infocard);
        }
    }

    public int getNr() {
        int number = 0;
        Enumeration<TreeNode> enu = this.root.preorderEnumeration();
        while (enu.hasMoreElements()) {
            enu.nextElement();
            ++number;
        }
        return number;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DefaultMutableTreeNode currentNode;
        this.mainFr.setDropStatusText("   ...");
        this.mainFr.infomlFile.hasChanged = true;
        Transferable transferable = dtde.getTransferable();
        DropTarget dropTarget = (DropTarget)dtde.getSource();
        DragAndDropTree dropTree = (DragAndDropTree)dropTarget.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)dropTree.getModel();
        Point loc = dtde.getLocation();
        TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
        Rectangle rect = this.getPathBounds(destinationPath);
        DefaultMutableTreeNode destinationNode = null;
        if (destinationPath != null) {
            destinationNode = (DefaultMutableTreeNode)destinationPath.getLastPathComponent();
        }
        TransferableNode transfer = null;
        try {
            transfer = (TransferableNode)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (destinationNode != null && !this.destinationNodeInDropNodeFamily(destinationNode, transfer.node, transfer.cardIds)) {
            if (this.root.getFirstChild().toString().compareTo(transfer.identifier1) == 0 && this.root.getLastChild().toString().compareTo(transfer.identifier2) == 0 && this.getNr() == transfer.identifier3 && this.mainFr.getBounds().equals(transfer.identifier4)) {
                currentNode = this.root;
                for (int i = 1; i < transfer.nodeIndex.length; ++i) {
                    currentNode = (DefaultMutableTreeNode)currentNode.getFirstChild();
                    for (int k = 0; k < transfer.nodeIndex[i]; ++k) {
                        currentNode = currentNode.getNextSibling();
                    }
                }
                if (destinationNode.equals(this.celery)) {
                    return;
                }
                Object notecardTrue = this.mainFr.notecards.get(currentNode);
                Object contentcardTrue = this.mainFr.uniqueContent.get(currentNode);
                if (notecardTrue != null) {
                    this.mainFr.stateSaver.saveState(currentNode, (NotecardModel)notecardTrue, "d&d", transfer.node, (DefaultMutableTreeNode)currentNode.getParent(), ((DefaultMutableTreeNode)currentNode.getParent()).getIndex(currentNode));
                } else {
                    this.mainFr.stateSaver.saveState(currentNode, (NotecardModel)contentcardTrue, "d&d", transfer.node, (DefaultMutableTreeNode)currentNode.getParent(), ((DefaultMutableTreeNode)currentNode.getParent()).getIndex(currentNode));
                }
                this.mainFr.stateSaver.models = new Vector();
                model.removeNodeFromParent(currentNode);
                this.modifySubTreeInStructures(currentNode, transfer.node);
                if (destinationNode.equals(this.root.getFirstChild()) && loc.y < rect.height / 2) {
                    model.insertNodeInto(transfer.node, this.root, 0);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                } else if (loc.x < rect.x + 23) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)destinationNode.getParent();
                    int index = parent.getIndex(destinationNode);
                    model.insertNodeInto(transfer.node, parent, index + 1);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                } else {
                    model.insertNodeInto(transfer.node, destinationNode, 0);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                }
                this.mainFr.infomlFile.rearangeElements();
            } else {
                this.mainFr.stateSaver.saveState(null, null, "d&d", transfer.node, null, -1);
                if (destinationNode.equals(this.root.getFirstChild()) && loc.y < rect.height / 2) {
                    model.insertNodeInto(transfer.node, this.root, 0);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                } else if (loc.x < rect.x + 23) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)destinationNode.getParent();
                    int index = parent.getIndex(destinationNode);
                    model.insertNodeInto(transfer.node, parent, index + 1);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                } else {
                    model.insertNodeInto(transfer.node, destinationNode, 0);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                }
                this.mainFr.stateSaver.models = new Vector();
                this.addSubTreeToStructures(transfer);
                this.mainFr.infomlFile.rearangeElements();
            }
        }
        if (destinationNode == null) {
            if (this.root.getChildCount() != 0) {
                if (this.root.getFirstChild().toString().compareTo(transfer.identifier1) == 0 && this.root.getLastChild().toString().compareTo(transfer.identifier2) == 0 && this.getNr() == transfer.identifier3 && this.mainFr.getBounds().equals(transfer.identifier4)) {
                    currentNode = this.root;
                    for (int i = 1; i < transfer.nodeIndex.length; ++i) {
                        currentNode = (DefaultMutableTreeNode)currentNode.getFirstChild();
                        for (int k = 0; k < transfer.nodeIndex[i]; ++k) {
                            currentNode = currentNode.getNextSibling();
                        }
                    }
                    Object notecardTrue = this.mainFr.notecards.get(currentNode);
                    Object contentcardTrue = this.mainFr.uniqueContent.get(currentNode);
                    if (notecardTrue != null) {
                        this.mainFr.stateSaver.saveState(currentNode, (NotecardModel)notecardTrue, "d&d", transfer.node, (DefaultMutableTreeNode)currentNode.getParent(), ((DefaultMutableTreeNode)currentNode.getParent()).getIndex(currentNode));
                    } else {
                        this.mainFr.stateSaver.saveState(currentNode, (NotecardModel)contentcardTrue, "d&d", transfer.node, (DefaultMutableTreeNode)currentNode.getParent(), ((DefaultMutableTreeNode)currentNode.getParent()).getIndex(currentNode));
                    }
                    this.mainFr.stateSaver.models = new Vector();
                    model.removeNodeFromParent(currentNode);
                    this.modifySubTreeInStructures(currentNode, transfer.node);
                    model.insertNodeInto(transfer.node, this.root, this.root.getIndex(this.root.getLastChild()) + 1);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                } else {
                    this.mainFr.stateSaver.saveState(null, null, "d&d", transfer.node, null, -1);
                    model.insertNodeInto(transfer.node, this.root, this.root.getIndex(this.root.getLastChild()) + 1);
                    this.mainFr.stateSaver.models = new Vector();
                    this.addSubTreeToStructures(transfer);
                    this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                }
            } else {
                this.mainFr.stateSaver.saveState(null, null, "d&d", transfer.node, null, -1);
                model.insertNodeInto(transfer.node, this.root, 0);
                this.scrollPathToVisible(new TreePath(transfer.node.getPath()));
                this.mainFr.stateSaver.models = new Vector();
                this.addSubTreeToStructures(transfer);
                this.mainFr.enableSave();
            }
            this.mainFr.infomlFile.rearangeElements();
        }
        this.repaint();
    }
}

