/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PNMImageEncoder
extends ImageEncoderImpl {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.jai.codecimpl.PNMImageEncoder";
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;

    public PNMImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new PNMEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        Object[] objectArray;
        ComponentSampleModel componentSampleModel;
        int n2;
        int n3 = renderedImage.getMinX();
        int n4 = renderedImage.getMinY();
        int n5 = renderedImage.getWidth();
        int n6 = renderedImage.getHeight();
        int n7 = renderedImage.getTileHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = string.getBytes();
        int n8 = sampleModel.getTransferType();
        if (n8 == 4 || n8 == 5) {
            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder0"));
        }
        int[] nArray = sampleModel.getSampleSize();
        int n9 = sampleModel.getNumBands();
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        boolean bl = false;
        if (n9 == 1) {
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                n2 = indexColorModel.getMapSize();
                if (n2 < 1 << nArray[0]) {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder1"));
                }
                if (nArray[0] == 1) {
                    this.variant = 52;
                    bl = indexColorModel.getRed(1) + indexColorModel.getGreen(1) + indexColorModel.getBlue(1) > indexColorModel.getRed(0) + indexColorModel.getGreen(0) + indexColorModel.getBlue(0);
                } else {
                    this.variant = 54;
                    byArray = new byte[n2];
                    byArray2 = new byte[n2];
                    byArray3 = new byte[n2];
                    indexColorModel.getReds(byArray);
                    indexColorModel.getGreens(byArray2);
                    indexColorModel.getBlues(byArray3);
                }
            } else {
                this.variant = nArray[0] == 1 ? 52 : (nArray[0] <= 8 ? 53 : 50);
            }
        } else if (n9 == 3) {
            this.variant = nArray[0] <= 8 && nArray[1] <= 8 && nArray[2] <= 8 ? 54 : 51;
        } else {
            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder2"));
        }
        if (((PNMEncodeParam)this.param).getRaw()) {
            if (!this.isRaw(this.variant)) {
                boolean bl2 = true;
                n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] > 8) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (bl2) {
                    this.variant += 3;
                }
            }
        } else if (this.isRaw(this.variant)) {
            this.variant -= 3;
        }
        this.maxValue = (1 << nArray[0]) - 1;
        this.output.write(80);
        this.output.write(this.variant);
        this.output.write(this.lineSeparator);
        this.output.write(COMMENT.getBytes());
        this.output.write(this.lineSeparator);
        this.writeInteger(this.output, n5);
        this.output.write(32);
        this.writeInteger(this.output, n6);
        if (this.variant != 52 && this.variant != 49) {
            this.output.write(this.lineSeparator);
            this.writeInteger(this.output, this.maxValue);
        }
        if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
            this.output.write(10);
        }
        boolean bl3 = false;
        if (this.variant == 52 && sampleModel.getTransferType() == 0 && sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            if (multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                bl3 = true;
            }
        } else if ((this.variant == 53 || this.variant == 54) && sampleModel instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && (componentSampleModel = (ComponentSampleModel)sampleModel).getPixelStride() == n9) {
            bl3 = true;
            if (this.variant == 54) {
                objectArray = componentSampleModel.getBandOffsets();
                n = 0;
                while (n < n9) {
                    if (objectArray[n] != n) {
                        bl3 = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        if (bl3) {
            int n10 = this.variant == 52 ? (n5 + 7) / 8 : n5 * sampleModel.getNumBands();
            int n11 = renderedImage.getNumYTiles();
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getTileHeight());
            byte[] byArray4 = null;
            if (bl) {
                byArray4 = new byte[n10];
            }
            int n12 = 0;
            while (n12 < n11) {
                int n13;
                if (n12 == n11 - 1) {
                    rectangle.height = renderedImage.getHeight() - rectangle.y;
                }
                Raster raster = renderedImage.getData(rectangle);
                byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n14 = n13 = this.variant == 52 ? ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride() : ((ComponentSampleModel)sampleModel).getScanlineStride();
                if (n13 == n10 && !bl) {
                    this.output.write(byArray5, 0, byArray5.length);
                } else {
                    int n15 = 0;
                    int n16 = 0;
                    while (n16 < n7) {
                        if (bl) {
                            int n17 = 0;
                            while (n17 < n10) {
                                byArray4[n17] = (byte)(~(byArray5[n15 + n17] & 0xFF));
                                ++n17;
                            }
                            this.output.write(byArray4, 0, n10);
                        } else {
                            this.output.write(byArray5, n15, n10);
                        }
                        n15 += n13;
                        ++n16;
                    }
                }
                rectangle.y += n7;
                ++n12;
            }
            this.output.flush();
            return;
        }
        int[] nArray2 = new int[8 * n5 * n9];
        objectArray = byArray == null ? new byte[8 * n5 * n9] : new byte[8 * n5 * 3];
        n = 0;
        int n18 = n4 + n6;
        int n19 = n4;
        while (n19 < n18) {
            int n20;
            int n21 = Math.min(8, n18 - n19);
            int n22 = n21 * n5 * n9;
            Raster raster = renderedImage.getData(new Rectangle(n3, n19, n5, n21));
            raster.getPixels(n3, n19, n5, n21, nArray2);
            if (bl) {
                n20 = 0;
                while (n20 < n22) {
                    int n23 = n20++;
                    nArray2[n23] = nArray2[n23] ^ 1;
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    n20 = 0;
                    while (n20 < n22) {
                        if (n++ % 16 == 0) {
                            this.output.write(this.lineSeparator);
                        } else {
                            this.output.write(32);
                        }
                        this.writeInteger(this.output, nArray2[n20]);
                        ++n20;
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 51: {
                    int n24;
                    if (byArray == null) {
                        n24 = 0;
                        while (n24 < n22) {
                            if (n++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, nArray2[n24]);
                            ++n24;
                        }
                    } else {
                        n24 = 0;
                        while (n24 < n22) {
                            if (n++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, byArray[nArray2[n24]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray2[nArray2[n24]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray3[nArray2[n24]] & 0xFF);
                            ++n24;
                        }
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 52: {
                    int n25;
                    int n26;
                    int n24 = 0;
                    int n27 = 0;
                    int n28 = 0;
                    while (n28 < n22 / 8) {
                        n26 = nArray2[n27++] << 7 | nArray2[n27++] << 6 | nArray2[n27++] << 5 | nArray2[n27++] << 4 | nArray2[n27++] << 3 | nArray2[n27++] << 2 | nArray2[n27++] << 1 | nArray2[n27++];
                        objectArray[n24++] = (byte)n26;
                        ++n28;
                    }
                    if (n22 % 8 > 0) {
                        n26 = 0;
                        n25 = 0;
                        while (n25 < n22 % 8) {
                            n26 |= nArray2[n22 + n25] << 7 - n25;
                            ++n25;
                        }
                        objectArray[n24++] = (byte)n26;
                    }
                    this.output.write((byte[])objectArray, 0, (n22 + 7) / 8);
                    break;
                }
                case 53: {
                    int n26 = 0;
                    while (n26 < n22) {
                        objectArray[n26] = (byte)nArray2[n26];
                        ++n26;
                    }
                    this.output.write((byte[])objectArray, 0, n22);
                    break;
                }
                case 54: {
                    int n25;
                    if (byArray == null) {
                        n25 = 0;
                        while (n25 < n22) {
                            objectArray[n25] = (byte)(nArray2[n25] & 0xFF);
                            ++n25;
                        }
                    } else {
                        n25 = 0;
                        int n29 = 0;
                        while (n25 < n22) {
                            objectArray[n29++] = byArray[nArray2[n25]];
                            objectArray[n29++] = byArray2[nArray2[n25]];
                            objectArray[n29++] = byArray3[nArray2[n25]];
                            ++n25;
                        }
                    }
                    this.output.write((byte[])objectArray, 0, objectArray.length);
                }
            }
            n19 += 8;
        }
        this.output.flush();
    }

    private void writeInteger(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }

    private void writeByte(OutputStream outputStream, byte by) throws IOException {
        outputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }
}

