/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import java.math.BigInteger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SICBlockCipher
implements BlockCipher {
    private BlockCipher cipher = null;
    private int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private boolean encrypting;
    private final BigInteger ONE = BigInteger.valueOf(1L);

    public SICBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.encrypting = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            this.reset();
            this.cipher.init(true, parametersWithIV.getParameters());
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        int n3 = 0;
        while (n3 < this.counterOut.length) {
            byArray2[n2 + n3] = (byte)(this.counterOut[n3] ^ byArray[n + n3]);
            ++n3;
        }
        BigInteger bigInteger = new BigInteger(this.counter);
        bigInteger.add(this.ONE);
        this.counter = bigInteger.toByteArray();
        return this.counter.length;
    }

    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
    }
}

