/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.Messages;

public class GUI {
    public GUIButton first;
    public GUIButton fback;
    public GUIButton back;
    public GUIButton forward;
    public GUIButton fforward;
    public GUIButton end;
    public GUIButton singleButton;
    public GUIButton continuousButton;
    public GUIButton continuousFacingButton;
    public GUIButton facingButton;
    private final String[] annotTypes = new String[]{"Other", "Text", "FileAttachment"};
    private final Color[] annotColors = new Color[]{Color.RED, Color.BLUE, Color.BLUE};
    private int dpi = 96;
    protected PdfDecoder decode_pdf;
    protected static final int thumbLocation = 200;
    protected static final int minimumScreenWidth = 700;
    protected HashMap pagesDecoded = new HashMap();
    protected GUIButton snapshotButton;
    private Rectangle currentRectangle = null;
    public int cropX;
    public int cropW;
    public int cropH;
    protected int mediaX;
    protected int mediaY;
    public int mediaW;
    public int cropY;
    public int mediaH;
    protected boolean hasOutlinesDrawn = false;
    protected GUIOutline tree = new SwingOutline();
    private boolean allowScrolling = true;
    protected int divLocation = 170;
    protected boolean showOutlines = true;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static final int inset = 25;
    protected int rotation = 0;
    protected final String[] rotationValues = new String[]{"0", "90", "180", "270"};
    protected GUICombo rotationBox;
    protected GUICombo scalingBox;
    protected static final int defaultSelection = 0;
    protected String titleMessage = null;
    protected Values commonValues;
    protected GUIThumbnailPanel thumbnails;
    protected PropertiesFile properties;

    public void setPreferences(int n, int n2, int n3, boolean bl) {
        PdfDecoder.CURRENT_BORDER_STYLE = n3;
        this.properties.setValue("borderType", String.valueOf(n3));
        this.allowScrolling = bl;
        this.properties.setValue("autoScroll", String.valueOf(bl));
        this.dpi = n;
        this.properties.setValue("DPI", String.valueOf(n));
        this.decode_pdf.repaint();
        if (!this.properties.getValue("searchWindowType").equals(String.valueOf(n2))) {
            JOptionPane.showMessageDialog(null, Messages.getMessage("PageLayoutViewMenu.ResetSearch"));
        }
        this.properties.setValue("searchWindowType", String.valueOf(n2));
    }

    public float convertToCorrectedScaling(float f) {
        return f * (float)(this.dpi / 72);
    }

    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    public String[] getAnnotTypes() {
        return this.annotTypes;
    }

    public void setNoPagesDecoded() {
        this.pagesDecoded.clear();
    }

    public void setScalingToDefault() {
        this.scaling = PdfDecoder.isRunningOnWindows ? 1.53f : 1.0f;
        this.scalingBox.setSelectedIndex(0);
    }

    public void setRectangle(Rectangle rectangle) {
        this.currentRectangle = rectangle;
    }

    public Rectangle getRectangle() {
        return this.currentRectangle;
    }

    public void setAutoScrolling(boolean bl) {
        this.allowScrolling = bl;
    }

    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setScaling(float f) {
        this.scaling = f;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public int getPDFDisplayInset() {
        return 25;
    }

    public void createUniqueAnnotationIcons() {
        int n = this.commonValues.getCurrentPage();
        PdfAnnots pdfAnnots = this.decode_pdf.getPdfAnnotsData(null);
        if (pdfAnnots != null) {
            int n2 = pdfAnnots.getAnnotCount();
            for (int i = 0; i < this.annotTypes.length; ++i) {
                int n3 = 0;
                for (int j = 0; j < n2; ++j) {
                    if (!pdfAnnots.getAnnotSubType(j).equals(this.annotTypes[i])) continue;
                    ++n3;
                }
                Image[] imageArray = new Image[n3];
                for (int j = 0; j < n3; ++j) {
                    imageArray[j] = new BufferedImage(16, 16, 2);
                    Graphics2D graphics2D = (Graphics2D)imageArray[j].getGraphics();
                    graphics2D.setColor(this.annotColors[i]);
                    graphics2D.fill(new Rectangle(0, 0, 16, 16));
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.draw(new Rectangle(0, 0, 15, 15));
                    graphics2D.setColor(Color.white);
                    graphics2D.drawString(j + 1 + " ", 2, 12);
                }
                if (n3 <= 0) continue;
                this.decode_pdf.addUserIconsForAnnotations(n, this.annotTypes[i], imageArray);
            }
        }
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int n) {
        this.dpi = n;
    }
}

