/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.examples.simpleviewer.gui.SignaturesTreeCellRenderer;
import org.jpedal.examples.simpleviewer.gui.VTextIcon;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.CommandListener;
import org.jpedal.examples.simpleviewer.gui.swing.FrameCloser;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingCombo;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMenuItem;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Node;

public class SwingGUI
extends GUI
implements GUIFactory {
    boolean finishedDecoding = false;
    static final int startSize = 30;
    static final int expandedSize = 190;
    String pageTitle;
    String bookmarksTitle;
    String signaturesTitle;
    boolean hasListener = false;
    private boolean isSetup = false;
    int lastTabSelected = -1;
    public boolean messageShown = false;
    ButtonGroup layoutGroup = new ButtonGroup();
    ButtonGroup searchLayoutGroup = new ButtonGroup();
    ButtonGroup borderGroup = new ButtonGroup();
    private CommandListener currentCommandListener;
    private JToolBar topButtons = new JToolBar();
    private JToolBar comboBar = new JToolBar();
    private JToolBar bottomNavButtons = new JToolBar();
    private JMenuBar currentMenu = new JMenuBar();
    private boolean firstTimeFormMessage = true;
    private JLabel coords = new JLabel();
    private JFrame frame = new JFrame();
    private JTabbedPane navOptionsPanel = new JTabbedPane();
    private JSplitPane displayPane;
    private JScrollPane scrollPane = new JScrollPane();
    private final Font headFont = new Font("SansSerif", 1, 14);
    private final Font textFont = new Font("Serif", 0, 12);
    private StatusBar statusBar = new StatusBar(Color.orange);
    public JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3;
    private JLabel optimizationLabel;
    private JTree signaturesTree = new JTree();
    private String user_dir = System.getProperty("user.dir");
    private boolean tabsNotInitialised = true;
    private JToolBar navToolBar = new JToolBar();
    private JToolBar pagesToolBar = new JToolBar();
    public GUIButton nextSearch;
    public GUIButton previousSearch;
    GUISearchWindow searchFrame = null;
    boolean addSearchTab = false;
    boolean searchInMenu = false;
    JTextField searchText = null;
    SearchList results = null;

    public SwingGUI(PdfDecoder pdfDecoder, Values values, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile) {
        this.decode_pdf = pdfDecoder;
        this.commonValues = values;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
        if (values.isContentExtractor()) {
            this.titleMessage = "IDRsolutions Extraction Solution 3.22b14STD ";
            this.showOutlines = false;
        }
        SignaturesTreeCellRenderer signaturesTreeCellRenderer = new SignaturesTreeCellRenderer();
        this.signaturesTree.setCellRenderer(signaturesTreeCellRenderer);
    }

    public JComponent getDisplayPane() {
        return this.displayPane;
    }

    public int AdjustForAlignment(int n) {
        if (this.decode_pdf.getPageAlignment() == 2) {
            int n2 = this.decode_pdf.getBounds().width;
            int n3 = this.decode_pdf.getPDFWidth();
            if (this.decode_pdf.getDisplayView() != 1) {
                n3 = (int)this.decode_pdf.getMaximumSize().getWidth();
            }
            if (n2 > n3) {
                n -= (n2 - n3) / 2;
            }
        }
        return n;
    }

    public String getBookmark(String string) {
        return this.tree.getPage(string);
    }

    public void reinitialiseTabs() {
        this.displayPane.setDividerLocation(30);
        this.lastTabSelected = -1;
        if (this.commonValues.isContentExtractor()) {
            this.navOptionsPanel.removeAll();
            this.displayPane.setDividerLocation(0);
        } else if (!this.commonValues.isPDF()) {
            this.navOptionsPanel.setVisible(false);
        } else {
            Object object;
            int n;
            this.navOptionsPanel.setVisible(true);
            if (!this.decode_pdf.hasOutline()) {
                int n2;
                n = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object = "";
                    for (n2 = 0; n2 < this.navOptionsPanel.getTabCount(); ++n2) {
                        if (!this.navOptionsPanel.getTitleAt(n2).equals(this.bookmarksTitle)) continue;
                        n = n2;
                    }
                } else {
                    object = "";
                    for (n2 = 0; n2 < this.navOptionsPanel.getTabCount(); ++n2) {
                        if (!this.navOptionsPanel.getIconAt(n2).toString().equals(this.bookmarksTitle)) continue;
                        n = n2;
                    }
                }
                if (n != -1) {
                    this.navOptionsPanel.remove(n);
                }
            } else {
                n = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.bookmarksTitle)) continue;
                        n = i;
                    }
                    if (n == -1) {
                        this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                    }
                } else {
                    object = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.bookmarksTitle)) continue;
                        n = i;
                    }
                    if (n == -1) {
                        VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                        this.navOptionsPanel.addTab(null, vTextIcon, (SwingOutline)this.tree);
                    }
                }
            }
            AcroRenderer acroRenderer = this.decode_pdf.getCurrentFormRenderer();
            object = acroRenderer.getSignatureObjects();
            if (object != null) {
                Object object2;
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Signatures");
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("The following people have digitally counter-signed this document");
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("The following signature fields are not signed");
                while (object.hasNext()) {
                    Object object3;
                    FormObject formObject = (FormObject)object.next();
                    object2 = acroRenderer.getSignatureObject(formObject.getPDFRef());
                    if (object2 == null) {
                        if (!defaultMutableTreeNode3.isNodeChild(defaultMutableTreeNode)) {
                            defaultMutableTreeNode.add(defaultMutableTreeNode3);
                        }
                        object3 = new DefaultMutableTreeNode(formObject.getFieldName() + " on page " + formObject.getPageNumber());
                        defaultMutableTreeNode3.add((MutableTreeNode)object3);
                        continue;
                    }
                    if (!defaultMutableTreeNode2.isNodeChild(defaultMutableTreeNode)) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    }
                    object3 = (String)object2.get("Name");
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Signed by " + (String)object3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                    DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Type");
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    String string = (String)object2.get("Filter");
                    DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Filter: " + string.substring(1, string.length()));
                    defaultMutableTreeNode5.add(defaultMutableTreeNode6);
                    String string2 = (String)object2.get("SubFilter");
                    DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Sub Filter: " + string2.substring(1, string2.length()));
                    defaultMutableTreeNode5.add(defaultMutableTreeNode7);
                    DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Details");
                    defaultMutableTreeNode4.add(defaultMutableTreeNode8);
                    StringBuffer stringBuffer = new StringBuffer((String)object2.get("M"));
                    stringBuffer.delete(0, 2);
                    stringBuffer.insert(4, '/');
                    stringBuffer.insert(7, '/');
                    stringBuffer.insert(10, ' ');
                    stringBuffer.insert(13, ':');
                    stringBuffer.insert(16, ':');
                    stringBuffer.insert(19, ' ');
                    DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Time: " + stringBuffer);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode9);
                    String string3 = (String)object2.get("Reason");
                    DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("Reason: " + string3);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode10);
                    String string4 = (String)object2.get("Location");
                    DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("Location: " + string4);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode11);
                    DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("Field: " + formObject.getFieldName() + " on page " + formObject.getPageNumber());
                    defaultMutableTreeNode8.add(defaultMutableTreeNode12);
                }
                ((DefaultTreeModel)this.signaturesTree.getModel()).setRoot(defaultMutableTreeNode);
                int n3 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object2 = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle)) continue;
                        n3 = i;
                    }
                    if (n3 == -1) {
                        this.navOptionsPanel.addTab(this.signaturesTitle, this.signaturesTree);
                    }
                } else {
                    object2 = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle)) continue;
                        n3 = i;
                    }
                    if (n3 == -1) {
                        VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, this.signaturesTitle, 2);
                        this.navOptionsPanel.addTab(null, vTextIcon, this.signaturesTree);
                    }
                }
            } else {
                int n4 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    String string = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle)) continue;
                        n4 = i;
                    }
                } else {
                    String string = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle)) continue;
                        n4 = i;
                    }
                }
                if (n4 != -1) {
                    this.navOptionsPanel.remove(n4);
                }
            }
            this.setBookmarks(false);
        }
    }

    public void stopThumbnails() {
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    public void reinitThumbnails() {
        this.isSetup = false;
    }

    public void resetNavBar() {
        this.displayPane.setDividerLocation(30);
        this.tabsNotInitialised = true;
    }

    public void alignLayoutMenuOption(int n) {
        Enumeration<AbstractButton> enumeration = this.layoutGroup.getElements();
        for (int i = 1; enumeration.hasMoreElements() && i != n; ++i) {
            enumeration.nextElement();
        }
        ((JMenuItem)enumeration.nextElement()).setSelected(true);
    }

    private JScrollPane getFontsAliasesInfoBox() {
        Object object;
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = FontMappings.fontSubstitutionAliasTable.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append(object);
            stringBuffer.append(" ==> ");
            stringBuffer.append(FontMappings.fontSubstitutionAliasTable.get(object));
            stringBuffer.append('\n');
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 0) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setText((String)object);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return jScrollPane;
    }

    private JScrollPane getFontsFoundInfoBox() {
        Object object;
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = FontMappings.fontSubstitutionTable.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append(object);
            stringBuffer.append(" = ");
            stringBuffer.append(FontMappings.fontSubstitutionLocation.get(object));
            stringBuffer.append('\n');
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 0) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setText((String)object);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return jScrollPane;
    }

    private JScrollPane getFontInfoBox() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        String string = this.decode_pdf.getFontsInFile();
        if (string.length() > 0) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setText(string);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return jScrollPane;
    }

    public void getInfoBox() {
        Accessible accessible;
        final JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(400, 260));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        jLabel.setOpaque(false);
        jLabel.setFont(this.headFont);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        String string = Messages.getMessage("PdfViewerInfo1") + Messages.getMessage("PdfViewerInfo2");
        if (string.length() > 0) {
            accessible = new JTextArea();
            ((JComponent)((Object)accessible)).setOpaque(false);
            ((JTextComponent)accessible).setText(string + "\n\nVersion: " + "3.22b14STD");
            ((JTextArea)accessible).setLineWrap(true);
            ((JTextArea)accessible).setWrapStyleWord(true);
            ((JTextComponent)accessible).setEditable(false);
            jPanel.add((Component)((Object)accessible));
            ((JComponent)((Object)accessible)).setAlignmentX(0.5f);
        }
        accessible = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/logo.gif"));
        jPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        JLabel jLabel2 = new JLabel((Icon)((Object)accessible));
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel2);
        final JLabel jLabel3 = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
        jLabel3.setForeground(Color.blue);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setAlignmentX(0.5f);
        jLabel3.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(12));
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(0));
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (IOException iOException) {
                    SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(jLabel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.showMessageDialog(jPanel, Messages.getMessage("PdfViewerInfo3"), -1);
    }

    public void resetRotationBox() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    private JScrollPane getPropertiesBox(String string, String string2, String string3, long l, int n, int n2) {
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        if (pdfFileInformation != null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(true);
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            jLabel.setFont(this.headFont);
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerFileName") + string);
            jLabel2.setFont(this.textFont);
            jLabel2.setOpaque(false);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerFilePath") + string2);
            jLabel3.setFont(this.textFont);
            jLabel3.setOpaque(false);
            jPanel.add(jLabel3);
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + string3);
            jLabel4.setFont(this.textFont);
            jLabel4.setOpaque(false);
            jPanel.add(jLabel4);
            JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerFileSize") + l + " K");
            jLabel5.setFont(this.textFont);
            jLabel5.setOpaque(false);
            jPanel.add(jLabel5);
            JLabel jLabel6 = new JLabel(Messages.getMessage("PdfViewerPageCount") + n);
            jLabel6.setOpaque(false);
            jLabel6.setFont(this.textFont);
            jPanel.add(jLabel6);
            JLabel jLabel7 = new JLabel("PDF " + this.decode_pdf.getPDFVersion());
            jLabel7.setOpaque(false);
            jLabel7.setFont(this.textFont);
            jPanel.add(jLabel7);
            jPanel.add(Box.createVerticalStrut(10));
            JLabel jLabel8 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            jLabel8.setFont(this.headFont);
            jLabel8.setOpaque(false);
            jPanel.add(jLabel8);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            int n3 = stringArray2.length;
            JLabel[] jLabelArray = new JLabel[n3];
            for (int i = 0; i < n3; ++i) {
                if (stringArray[i].length() <= 0) continue;
                jLabelArray[i] = new JLabel(stringArray2[i] + " = " + stringArray[i]);
                jLabelArray[i].setFont(this.textFont);
                jLabelArray[i].setOpaque(false);
                jPanel.add(jLabelArray[i]);
            }
            jPanel.add(Box.createVerticalStrut(10));
            PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
            if (pdfPageData != null) {
                JLabel jLabel9 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                jLabel9.setFont(this.headFont);
                jPanel.add(jLabel9);
                JLabel jLabel10 = new JLabel(Messages.getMessage("PdfViewermediaBox.text") + pdfPageData.getMediaValue(n2));
                jLabel10.setFont(this.textFont);
                jPanel.add(jLabel10);
                JLabel jLabel11 = new JLabel(Messages.getMessage("PdfViewercropBox.text") + pdfPageData.getCropValue(n2));
                jLabel11.setFont(this.textFont);
                jPanel.add(jLabel11);
                JLabel jLabel12 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation") + pdfPageData.getRotation(n2));
                jLabel4.setFont(this.textFont);
                jPanel.add(jLabel12);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return jScrollPane;
        }
        return new JScrollPane();
    }

    private JScrollPane getXMLInfoBox(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jTextArea.setColumns(15);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string);
        jPanel.add(new JScrollPane(jTextArea));
        jTextArea.setCaretPosition(0);
        jTextArea.setOpaque(true);
        jTextArea.setBackground(Color.white);
        return jScrollPane;
    }

    public void showDocumentProperties(String string, String string2, long l, int n, int n2) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (string == null) {
            this.showMessageDialog(Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
        } else {
            String string3 = string;
            int n3 = string3.lastIndexOf(92);
            if (n3 == -1) {
                n3 = string3.lastIndexOf(47);
            }
            String string4 = string3.substring(n3 + 1, string3.length());
            String string5 = string3.substring(0, n3 + 1);
            jTabbedPane.add(this.getPropertiesBox(string4, string5, this.user_dir, l, n, n2));
            jTabbedPane.setTitleAt(0, Messages.getMessage("PdfViewerTab.Properties"));
            jTabbedPane.add(this.getFontInfoBox());
            jTabbedPane.setTitleAt(1, Messages.getMessage("PdfViewerTab.Fonts"));
            jTabbedPane.add(this.getFontsFoundInfoBox());
            jTabbedPane.setTitleAt(2, "Available");
            jTabbedPane.add(this.getFontsAliasesInfoBox());
            jTabbedPane.setTitleAt(3, "Aliases");
            PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
            String string6 = pdfFileInformation.getFileXMLMetaData();
            if (string6.length() > 0) {
                jTabbedPane.add(this.getXMLInfoBox(string6));
                jTabbedPane.setTitleAt(4, "XML");
            }
            this.showMessageDialog(jTabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
        }
    }

    public void searchInTab(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        if (PdfDecoder.isRunningOnMac) {
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab("Search", gUISearchWindow.getContentPanel());
            }
        } else {
            VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, "Search", 2);
            this.navOptionsPanel.addTab(null, vTextIcon, gUISearchWindow.getContentPanel());
        }
        this.addSearchTab = true;
    }

    public void searchInMenu(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        this.searchInMenu = true;
        gUISearchWindow.find();
        this.searchText.setPreferredSize(new Dimension(150, 20));
        this.topButtons.add(this.searchText);
        this.addButton(0, "Previous Search Result", "/org/jpedal/examples/simpleviewer/res/search_previous.gif", 18);
        this.addButton(0, "Next Search Result", "/org/jpedal/examples/simpleviewer/res/search_next.gif", 19);
        this.nextSearch.setVisible(false);
        this.previousSearch.setVisible(false);
    }

    public void init(String[] stringArray, final Object object, Object object2) {
        Object object3;
        Object object4;
        this.currentCommandListener = new CommandListener((Commands)object);
        this.setViewerTitle(Messages.getMessage("PdfViewerEnhanced.titlebar") + "  " + "3.22b14STD");
        this.decode_pdf.setInset(25, 25);
        this.decode_pdf.setBackground(new Color(190, 190, 190));
        this.scalingBox = new SwingCombo(stringArray);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(0);
        this.rotationBox = new SwingCombo(this.rotationValues);
        this.rotationBox.setBackground(Color.white);
        this.rotationBox.setSelectedIndex(0);
        this.scrollPane.getViewport().add(this.decode_pdf);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.bottomNavButtons.setBorder(BorderFactory.createEmptyBorder());
        this.bottomNavButtons.setLayout(new FlowLayout(3));
        this.bottomNavButtons.setFloatable(false);
        this.bottomNavButtons.setFont(new Font("SansSerif", 0, 8));
        this.navOptionsPanel.setTabPlacement(2);
        this.navOptionsPanel.setOpaque(true);
        this.navOptionsPanel.setMinimumSize(new Dimension(0, 100));
        this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
        this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
        this.signaturesTitle = "Signatures";
        this.displayPane = new JSplitPane(1, this.navOptionsPanel, this.scrollPane);
        this.displayPane.setOneTouchExpandable(true);
        if (!this.commonValues.isContentExtractor()) {
            if (PdfDecoder.isRunningOnMac) {
                if (this.thumbnails.isShownOnscreen()) {
                    this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                }
                this.navOptionsPanel.addTab(this.pageTitle, (Component)((Object)this.thumbnails));
            } else {
                object4 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                this.navOptionsPanel.addTab(null, (Icon)object4, (SwingOutline)this.tree);
                if (this.thumbnails.isShownOnscreen()) {
                    object3 = new VTextIcon(this.navOptionsPanel, this.pageTitle, 2);
                    this.navOptionsPanel.addTab(null, (Icon)object3, (Component)((Object)this.thumbnails));
                }
            }
            this.displayPane.setDividerLocation(30);
        } else {
            this.displayPane.setDividerLocation(0);
        }
        this.frame.getContentPane().add((Component)this.displayPane, "Center");
        if (!this.hasListener) {
            this.hasListener = true;
            this.navOptionsPanel.addMouseListener(new MouseListener(){

                public void focusLost(FocusEvent focusEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    SwingGUI.this.handleTabbedPanes();
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        if (!this.commonValues.isContentExtractor()) {
            this.first = new SwingButton();
            this.fback = new SwingButton();
            this.back = new SwingButton();
            this.forward = new SwingButton();
            this.fforward = new SwingButton();
            this.end = new SwingButton();
        }
        this.snapshotButton = new SwingButton();
        this.singleButton = new SwingButton();
        this.continuousButton = new SwingButton();
        this.continuousFacingButton = new SwingButton();
        this.facingButton = new SwingButton();
        this.previousSearch = new SwingButton();
        this.nextSearch = new SwingButton();
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Messages.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SwingGUI.this.pageCounter2.getText().trim();
                ((Commands)object).gotoPage(string);
            }
        });
        this.pageCounter3 = new JLabel(Messages.getMessage("PdfViewerOfLabel.text") + ' ');
        this.pageCounter3.setOpaque(false);
        object4 = new JPanel();
        ((Container)object4).setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)object4, "North");
        this.navToolBar.setLayout(new BoxLayout(this.navToolBar, 2));
        this.navToolBar.setFloatable(false);
        this.pagesToolBar.setFloatable(false);
        this.comboBar.setBorder(BorderFactory.createEmptyBorder());
        this.comboBar.setLayout(new BorderLayout());
        this.comboBar.setFloatable(false);
        this.comboBar.setPreferredSize(new Dimension(5, 24));
        this.frame.getContentPane().add((Component)this.comboBar, "South");
        ((Container)object4).add((Component)this.currentMenu, "North");
        this.topButtons.setBorder(BorderFactory.createEmptyBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
        ((Container)object4).add((Component)this.topButtons, "Center");
        ((Container)object4).add((Component)this.bottomNavButtons, "South");
        this.createNavbar();
        if (this.commonValues.getModeOfOperation() != 1) {
            object3 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = ((Dimension)object3).width / 2;
            int n2 = ((Dimension)object3).height / 2;
            if (n < 700) {
                n = 700;
            }
            this.frame.setSize(n, n2);
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new FrameCloser((Commands)object, this, this.decode_pdf, (Printer)object2, this.thumbnails, this.commonValues));
            this.frame.setVisible(true);
        }
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int n = this.displayPane.getDividerLocation();
        int n2 = this.navOptionsPanel.getSelectedIndex();
        if (n2 == -1) {
            return;
        }
        if (n == 30) {
            String string = "";
            string = PdfDecoder.isRunningOnMac ? this.navOptionsPanel.getTitleAt(n2) : this.navOptionsPanel.getIconAt(n2).toString();
            this.setupThumbnailPanel();
            this.setBookmarks(true);
            if (this.searchFrame != null) {
                this.searchFrame.find();
            }
            this.displayPane.setDividerLocation(190);
        } else if (n2 == this.lastTabSelected) {
            this.displayPane.setDividerLocation(30);
        }
        this.lastTabSelected = n2;
    }

    public void addCursor() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setLayout(new FlowLayout(3));
        jToolBar.setFloatable(false);
        jToolBar.setFont(new Font("SansSerif", 2, 10));
        jToolBar.add(new JLabel(Messages.getMessage("PdfViewerToolbarCursorLoc.text")));
        jToolBar.add(this.initCoordBox());
        jToolBar.setPreferredSize(new Dimension(170, 32));
        this.topButtons.add(jToolBar);
    }

    private void setKeyAccelerators(int n, JMenuItem jMenuItem) {
        switch (n) {
            case 12: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
                break;
            }
            case 5: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
                break;
            }
            case 6: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
                break;
            }
            case 7: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
                break;
            }
            case 9: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                break;
            }
            case 10: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
                break;
            }
            case 14: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
                break;
            }
            case 16: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
                break;
            }
            case 17: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
                break;
            }
            case 50: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(36, 2));
                break;
            }
            case 52: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
                break;
            }
            case 53: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
                break;
            }
            case 55: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(35, 2));
                break;
            }
            case 56: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
            }
        }
    }

    public void addButton(int n, String string, String string2, int n2) {
        GUIButton gUIButton = new SwingButton();
        switch (n2) {
            case 50: {
                gUIButton = this.first;
                break;
            }
            case 51: {
                gUIButton = this.fback;
                break;
            }
            case 52: {
                gUIButton = this.back;
                break;
            }
            case 53: {
                gUIButton = this.forward;
                break;
            }
            case 54: {
                gUIButton = this.fforward;
                break;
            }
            case 55: {
                gUIButton = this.end;
                break;
            }
            case 13: {
                gUIButton = this.snapshotButton;
                break;
            }
            case 57: {
                gUIButton = this.singleButton;
                break;
            }
            case 58: {
                gUIButton = this.continuousButton;
                break;
            }
            case 59: {
                gUIButton = this.continuousFacingButton;
                break;
            }
            case 60: {
                gUIButton = this.facingButton;
                break;
            }
            case 18: {
                gUIButton = this.previousSearch;
                break;
            }
            case 19: {
                gUIButton = this.nextSearch;
            }
        }
        if (n2 == 10) {
            gUIButton.setName("open");
        }
        gUIButton.init(string2, n2, string);
        ((AbstractButton)((Object)gUIButton)).addActionListener(this.currentCommandListener);
        if (n == 0) {
            this.topButtons.add((AbstractButton)((Object)gUIButton));
            this.topButtons.add(Box.createHorizontalGlue());
        } else if (n == 1) {
            this.navToolBar.add((AbstractButton)((Object)gUIButton));
        } else if (n == 2) {
            this.pagesToolBar.add((Component)((AbstractButton)((Object)gUIButton)), "Center");
        }
    }

    public void addMenuItem(JMenu jMenu, String string, String string2, int n) {
        SwingMenuItem swingMenuItem = new SwingMenuItem(string);
        if (string2.length() > 0) {
            swingMenuItem.setToolTipText(string2);
        }
        swingMenuItem.setID(n);
        this.setKeyAccelerators(n, swingMenuItem);
        swingMenuItem.addActionListener(this.currentCommandListener);
        jMenu.add(swingMenuItem);
    }

    public void addCombo(String string, String string2, int n) {
        GUICombo gUICombo = null;
        switch (n) {
            case 252: {
                gUICombo = this.scalingBox;
                break;
            }
            case 251: {
                gUICombo = this.rotationBox;
            }
        }
        gUICombo.setID(n);
        this.optimizationLabel = new JLabel(string);
        if (string2.length() > 0) {
            gUICombo.setToolTipText(string2);
        }
        this.bottomNavButtons.add(this.optimizationLabel);
        this.bottomNavButtons.add((SwingCombo)gUICombo);
        ((SwingCombo)gUICombo).addActionListener(this.currentCommandListener);
    }

    public void setViewerTitle(String string) {
        if (string != null) {
            this.frame.setTitle(string);
        } else {
            String string2 = "";
            string2 = this.titleMessage == null ? Messages.getMessage("PdfViewerEnhanced.titlebar") + "3.22b14STD" + ' ' + this.commonValues.getSelectedFile() : this.titleMessage + this.commonValues.getSelectedFile();
            if (this.commonValues.isFormsChanged()) {
                string2 = "* " + string2;
            }
            this.frame.setTitle(string2);
        }
    }

    public void resetComboBoxes(boolean bl) {
        this.scalingBox.setEnabled(bl);
        this.rotationBox.setEnabled(bl);
    }

    public final JScrollPane createPane(JTextPane jTextPane, String string, boolean bl) throws BadLocationException {
        Object object;
        jTextPane.setEditable(true);
        jTextPane.setFont(new Font("Lucida", 0, 14));
        jTextPane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document document = jTextPane.getDocument();
        jTextPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        jTextPane.setForeground(Color.black);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setForeground(simpleAttributeSet2, Color.black);
        StyleConstants.setForeground(simpleAttributeSet3, Color.black);
        int n = 0;
        if (bl && string != null) {
            object = new StringTokenizer(string, "<>", true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("<") && ((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = string2 + ((StringTokenizer)object).nextToken() + ((StringTokenizer)object).nextToken();
                    document.insertString(n, string3, simpleAttributeSet);
                    n += string3.length();
                    continue;
                }
                document.insertString(n, string2, simpleAttributeSet2);
                n += string2.length();
            }
        } else {
            document.insertString(n, string, simpleAttributeSet3);
        }
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jTextPane);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        return object;
    }

    public int getSelectedComboIndex(int n) {
        switch (n) {
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int n, int n2) {
        switch (n) {
            case 252: {
                this.scalingBox.setSelectedIndex(n2);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(n2);
            }
        }
    }

    public void setSelectedComboItem(int n, String string) {
        switch (n) {
            case 252: {
                this.scalingBox.setSelectedItem(string);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(string);
            }
        }
    }

    public Object getSelectedComboItem(int n) {
        switch (n) {
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    public void zoom(boolean bl) {
        float f = this.scrollPane.getViewport().getWidth() - 25 - 25;
        float f2 = this.scrollPane.getViewport().getHeight() - 25 - 25;
        if (this.decode_pdf != null) {
            int n;
            Object object;
            int n2 = this.getSelectedComboIndex(252);
            if (n2 == -1) {
                object = (String)this.getSelectedComboItem(252);
                float f3 = -1.0f;
                if (object != null && ((String)object).length() > 0) {
                    block25: {
                        try {
                            f3 = Float.parseFloat((String)object);
                        }
                        catch (Exception exception) {
                            char c;
                            int n3;
                            f3 = -1.0f;
                            n = ((String)object).length();
                            for (n3 = 0; n3 < n && ((c = ((String)object).charAt(n3)) >= '0' && c <= '9') | c == '.'; ++n3) {
                            }
                            if (n3 > 0) {
                                object = ((String)object).substring(0, n3);
                            }
                            if (f3 != -1.0f) break block25;
                            try {
                                f3 = Float.parseFloat((String)object);
                            }
                            catch (Exception exception2) {
                                f3 = -1.0f;
                            }
                        }
                    }
                    if (f3 > 1000.0f) {
                        f3 = 1000.0f;
                    }
                }
                if (f3 == -1.0f) {
                    n2 = 0;
                    this.setSelectedComboIndex(252, n2);
                } else {
                    this.scaling = this.convertToCorrectedScaling(f3 / 100.0f);
                    this.setSelectedComboItem(252, String.valueOf(f3));
                }
            }
            if (n2 != -1) {
                if (n2 < 3) {
                    int n4;
                    int n5;
                    object = this.decode_pdf.getPdfPageData();
                    n = ((PdfPageData)object).getRotation(this.commonValues.getCurrentPage());
                    if (this.rotation == 90 || this.rotation == 270) {
                        n5 = ((PdfPageData)object).getCropBoxHeight(this.commonValues.getCurrentPage());
                        n4 = ((PdfPageData)object).getCropBoxWidth(this.commonValues.getCurrentPage());
                    } else {
                        n5 = ((PdfPageData)object).getCropBoxWidth(this.commonValues.getCurrentPage());
                        n4 = ((PdfPageData)object).getCropBoxHeight(this.commonValues.getCurrentPage());
                    }
                    if (this.displayPane != null) {
                        f -= (float)this.displayPane.getDividerSize();
                    }
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    f4 = f / (float)n5;
                    f5 = f2 / (float)n4;
                    if (n2 == 0) {
                        this.scaling = f4 < f5 ? f4 : f5;
                    } else if (n2 == 1) {
                        this.scaling = f5;
                    } else if (n2 == 2) {
                        this.scaling = f4;
                    }
                } else {
                    this.scaling = this.convertToCorrectedScaling(this.scalingFloatValues[n2]);
                }
            }
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            this.decode_pdf.invalidate();
            this.decode_pdf.updateUI();
            this.decode_pdf.validate();
            this.scrollPane.invalidate();
            this.scrollPane.updateUI();
            this.scrollPane.validate();
            if (bl) {
                // empty if block
            }
            if (this.commonValues.isPDF()) {
                this.scrollToPage(this.commonValues.getCurrentPage());
            }
        }
        this.scrollPane.updateUI();
    }

    private float convertToCorrectedScaling2(float f) {
        if (PdfDecoder.isRunningOnWindows) {
            return f * 1.533f;
        }
        return f;
    }

    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.zoom(true);
        this.decode_pdf.updateUI();
    }

    public void scrollToPage(int n) {
        this.commonValues.setCurrentPage(n);
        if (this.commonValues.getCurrentPage() > 0) {
            int n2 = 0;
            int n3 = 0;
            if (this.decode_pdf.getDisplayView() != 1) {
                n2 = this.decode_pdf.getYCordForPage(this.commonValues.getCurrentPage(), this.scaling);
                n3 = this.decode_pdf.getXDisplacement();
            }
            PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
            int n4 = (int)((float)pdfPageData.getCropBoxHeight(this.commonValues.getCurrentPage()) * this.scaling);
            int n5 = (int)((float)pdfPageData.getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling);
            int n6 = n3 + (n5 - this.scrollPane.getHorizontalScrollBar().getVisibleAmount()) / 2;
            int n7 = n2 + (n4 - this.scrollPane.getVerticalScrollBar().getVisibleAmount()) / 2;
            this.scrollPane.getHorizontalScrollBar().setValue(n6);
            this.scrollPane.getVerticalScrollBar().setValue(n7);
        }
    }

    public void decodePage(boolean bl) {
        if (this.decode_pdf.getHighlightImage() != null) {
            this.commonValues.toggleExtractImageOnSelection();
            this.toggleSnapshotButton();
        }
        this.decode_pdf.setHighlightedImage(null);
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.setupThumbnailPanel();
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            this.pageCounter2.setForeground(Color.black);
            this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
        }
        this.tabsNotInitialised = false;
        boolean bl2 = this.commonValues.isContentExtractor();
        this.decode_pdf.unsetScaling();
        if (bl2) {
            this.decode_pdf.setExtractionMode(1);
        } else {
            this.decode_pdf.setExtractionMode(65);
        }
        this.decode_pdf.setFoundTextArea(null);
        this.decode_pdf.setFoundTextAreas(null);
        this.decode_pdf.setHighlightedAreas(null);
        this.setRectangle(null);
        if (this.decode_pdf.getDisplayView() == 3) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            this.decode_pdf.decodeOtherPages(this.commonValues.getPageCount());
            return;
        }
        if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            return;
        }
        this.resetComboBoxes(false);
        if (!this.commonValues.isContentExtractor()) {
            this.commonValues.setProcessing(true);
        }
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Object object;
                    SwingGUI.this.statusBar.updateStatus("Decoding Page", 0);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        SwingGUI.this.decode_pdf.decodePage(SwingGUI.this.commonValues.getCurrentPage());
                        if (!SwingGUI.this.decode_pdf.hasAllImages()) {
                            object = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                            SwingGUI.this.showMessageDialog(object);
                        }
                        object = SwingGUI.this.decode_pdf.getPdfPageData();
                        SwingGUI.this.mediaW = ((PdfPageData)object).getMediaBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaH = ((PdfPageData)object).getMediaBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaX = ((PdfPageData)object).getMediaBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaY = ((PdfPageData)object).getMediaBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropX = ((PdfPageData)object).getCropBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropY = ((PdfPageData)object).getCropBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropW = ((PdfPageData)object).getCropBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropH = ((PdfPageData)object).getCropBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.resetRotationBox();
                        SwingGUI.this.commonValues.setPageAnnotations(SwingGUI.this.decode_pdf.getPdfAnnotsData(null));
                        if (!SwingGUI.this.decode_pdf.showAnnotations) {
                            SwingGUI.this.createUniqueAnnotationIcons();
                        }
                        SwingGUI.this.statusBar.updateStatus("Displaying Page", 0);
                    }
                    catch (Exception exception) {
                        System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                        exception.printStackTrace();
                        SwingGUI.this.commonValues.setProcessing(false);
                    }
                    object = SwingGUI.this.decode_pdf.getPageDecodeReport();
                    if (((String)object).indexOf("java.lang.OutOfMemoryError") != -1 && PdfDecoder.showErrorMessages) {
                        object = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                        SwingGUI.this.showMessageDialog(object);
                    }
                    if (SwingGUI.this.decode_pdf.getPageDecodeReport().indexOf("JBIG") != -1) {
                        object = "This File Contains a JBIG image. \n\nSupport for JBIG images is currently in development";
                        SwingGUI.this.showMessageDialog(object);
                    }
                    if (SwingGUI.this.thumbnails != null && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.addDisplayedPageAsThumbnail(SwingGUI.this.commonValues.getCurrentPage(), null);
                    }
                    SwingGUI.this.commonValues.setProcessing(false);
                    SwingGUI.this.setViewerTitle(null);
                    if (SwingGUI.this.thumbnails.isShownOnscreen() && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                catch (Exception exception) {
                    SwingGUI.this.setViewerTitle(null);
                }
                SwingGUI.this.selectBookmark();
                SwingGUI.this.statusBar.setProgress(100);
                SwingGUI.this.resetComboBoxes(true);
                SwingGUI.this.addFormsListeners();
                SwingGUI.this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
                SwingGUI.this.decode_pdf.disableBorderForPrinting();
                SwingGUI.this.zoom(false);
                SwingGUI.this.reinitialiseTabs();
                SwingGUI.this.finishedDecoding = true;
                return null;
            }
        };
        swingWorker.start();
    }

    public void addFormsListeners() {
        Serializable serializable;
        Object object;
        Object object2;
        AcroRenderer acroRenderer;
        this.commonValues.setFormsChanged(false);
        boolean bl = false;
        String string = System.getProperty("listenForms");
        if (string != null) {
            bl = true;
        }
        if ((acroRenderer = this.decode_pdf.getCurrentFormRenderer()) == null) {
            return;
        }
        List list = null;
        try {
            list = acroRenderer.getComponentNameList(this.commonValues.getCurrentPage());
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception " + pdfException + " reading component list");
        }
        if (list == null) {
            if (bl) {
                this.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
            }
            return;
        }
        int n = list.size();
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JLabel jLabel = new JLabel("This page contains " + n + " form objects");
            jLabel.setFont(this.headFont);
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            object2 = new JTextPane();
            ((JComponent)object2).setPreferredSize(new Dimension(450, 180));
            ((JTextComponent)object2).setEditable(false);
            ((JEditorPane)object2).setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.simpleviewer.SimpleViewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            ((JComponent)object2).setFont(this.textFont);
            jPanel.add((Component)object2);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        for (int i = 0; i < n; ++i) {
            object2 = (String)list.get(i);
            object = (Component[])acroRenderer.getComponentsByName((String)object2);
            serializable = new Integer(i);
            if (object == null || this.pagesDecoded.get(serializable) != null) continue;
            this.pagesDecoded.put(serializable, "x");
            int n2 = ((Component[])object).length;
            for (int j = 0; j < n2; ++j) {
                Object object3;
                if (bl && j == 0) {
                    object3 = new JLabel();
                    JLabel jLabel = new JLabel("Form name=" + (String)object2);
                    String string2 = "type=" + object[j].getClass();
                    if (n2 > 1) {
                        string2 = "Group of " + n2 + " Objects, type=" + object[j].getClass();
                        ((JComponent)object3).setForeground(Color.red);
                    }
                    ((JLabel)object3).setText(string2);
                    jLabel.setFont(this.headFont);
                    ((JComponent)object3).setFont(this.textFont);
                    jPanel.add(jLabel);
                    jPanel.add((Component)object3);
                    jPanel.add(new JLabel(" "));
                }
                object3 = new FormActionListener((String)object2 + j, this.frame, bl);
                if (object[j] instanceof JComboBox) {
                    ((JComboBox)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (object[j] instanceof JCheckBox) {
                    ((JCheckBox)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (object[j] instanceof JRadioButton) {
                    ((JRadioButton)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (!(object[j] instanceof JTextField)) continue;
                ((JTextField)object[j]).addActionListener((ActionListener)object3);
            }
        }
        if (bl) {
            final JDialog jDialog = new JDialog((Frame)this.frame, true);
            if (this.commonValues.getModeOfOperation() != 1) {
                jDialog.setLocationRelativeTo(null);
                jDialog.setLocation(this.frame.getLocationOnScreen().x + 10, this.frame.getLocationOnScreen().y + 10);
            }
            object2 = new JScrollPane();
            ((JScrollPane)object2).getViewport().add(jPanel);
            ((JScrollPane)object2).setHorizontalScrollBarPolicy(30);
            ((JScrollPane)object2).setVerticalScrollBarPolicy(20);
            jDialog.setSize(500, 500);
            jDialog.setTitle("List of forms on this page");
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)object2, "Center");
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)object, "South");
            serializable = new JButton(Messages.getMessage("PdfViewerButton.Close"));
            ((JComponent)serializable).setFont(new Font("SansSerif", 0, 12));
            ((Container)object).add((Component)serializable, "East");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.setVisible(true);
        }
    }

    private void createOutlinePanels() {
        this.setupThumbnailPanel();
        this.setBookmarks(false);
    }

    private void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (!this.commonValues.isContentExtractor() && this.thumbnails.isShownOnscreen()) {
            int n = this.decode_pdf.getPageCount();
            this.thumbnails.setupThumbnails(n, this.textFont, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Object[] objectArray = this.thumbnails.getButtons();
            for (int i = 0; i < n; ++i) {
                ((JButton)objectArray[i]).addActionListener(new PageChanger(i));
            }
            this.thumbnails.addComponentListener();
        }
    }

    public void setBookmarks(boolean bl) {
        int n = this.displayPane.getDividerLocation();
        if (n == 30 && !bl) {
            return;
        }
        boolean bl2 = true;
        org.w3c.dom.Document document = this.decode_pdf.getOutlineAsXML();
        Node node = null;
        if (document != null) {
            node = document.getFirstChild();
        }
        if (node != null) {
            this.tree.reset(node);
            ((JTree)this.tree.getTree()).addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (SwingGUI.this.tree.isIgnoreAlteredBookmark()) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = SwingGUI.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    Object object = defaultMutableTreeNode.getUserObject();
                    String string = (String)defaultMutableTreeNode.getUserObject();
                    String string2 = SwingGUI.this.tree.getPage(string);
                    if (string2 != null && string2.length() > 0) {
                        Point point;
                        int n = Integer.parseInt(string2);
                        if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != n) {
                            SwingGUI.this.commonValues.setCurrentPage(n);
                            SwingGUI.this.setScalingToDefault();
                            SwingGUI.this.decode_pdf.setPageParameters(SwingGUI.this.getScaling(), SwingGUI.this.commonValues.getCurrentPage());
                            SwingGUI.this.decodePage(false);
                        }
                        if ((point = SwingGUI.this.tree.getPoint(string)) != null) {
                            SwingGUI.this.decode_pdf.ensurePointIsVisible(point);
                        }
                    } else {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewerError.NoBookmarkLink") + string);
                        System.out.println("No dest page set for " + string);
                    }
                }
            });
        } else {
            bl2 = false;
            this.tree.reset(null);
        }
    }

    private void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    public void initStatus() {
        this.decode_pdf.setStatusBarObject(this.statusBar);
        this.resetStatus();
    }

    public void resetStatus() {
        this.statusBar.setColorForSubroutines(Color.blue);
        this.bottomNavButtons.add(this.statusBar.getStatusObject());
    }

    public void initThumbnails(int n, Vector_Int vector_Int) {
        this.navOptionsPanel.removeAll();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(n - 1, vector_Int.get(), this.commonValues.getPageCount());
        }
        if (PdfDecoder.isRunningOnMac) {
            this.navOptionsPanel.add((Component)((Object)this.thumbnails), "Extracted items");
        } else {
            VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, "Extracted items", 2);
            this.navOptionsPanel.addTab(null, vTextIcon, (Component)((Object)this.thumbnails));
        }
        this.displayPane.setDividerLocation(150);
    }

    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    private JLabel initCoordBox() {
        this.coords.setBackground(Color.white);
        this.coords.setOpaque(true);
        this.coords.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.coords.setText("  X:  Y:   ");
        this.coords.setPreferredSize(new Dimension(90, 20));
        return this.coords;
    }

    public void toggleSnapshotButton() {
        if (!this.commonValues.isExtractImageOnSelection()) {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshotX.gif")));
        } else {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshot.gif")));
        }
    }

    public void setPageNumber() {
        this.pageCounter2.setForeground(Color.black);
        this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
        this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
    }

    private void createNavbar() {
        this.comboBar.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerPageLabel.text"));
        jLabel.setOpaque(false);
        this.navToolBar.add(Box.createHorizontalGlue());
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "/org/jpedal/examples/simpleviewer/res/start.gif", 50);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "/org/jpedal/examples/simpleviewer/res/fback.gif", 51);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "/org/jpedal/examples/simpleviewer/res/back.gif", 52);
        this.navToolBar.add(jLabel);
        this.pageCounter2.setMaximumSize(new Dimension(5, 50));
        this.navToolBar.add(this.pageCounter2);
        this.navToolBar.add(this.pageCounter3);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "/org/jpedal/examples/simpleviewer/res/forward.gif", 53);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "/org/jpedal/examples/simpleviewer/res/fforward.gif", 54);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "/org/jpedal/examples/simpleviewer/res/end.gif", 55);
        this.navToolBar.add(Box.createHorizontalGlue());
        this.comboBar.add((Component)this.navToolBar, "Center");
        this.comboBar.add((Component)this.pagesToolBar, "East");
        Dimension dimension = this.pagesToolBar.getPreferredSize();
        final JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setPreferredSize(dimension);
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                int n2 = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (SwingGUI.this.finishedDecoding) {
                    SwingGUI.this.finishedDecoding = false;
                }
                jProgressBar.setMaximum(n2);
                jProgressBar.setValue(n2 - n);
                jProgressBar.setStringPainted(true);
                jProgressBar.setString(n2 - n + "M of " + n2 + 'M');
            }
        });
        timer.start();
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.comboBar.add((Component)jProgressBar, "West");
    }

    public void setPage(int n) {
        this.commonValues.setCurrentPage(n);
        this.pageCounter2.setText(String.valueOf(n));
        this.setThumbnails();
    }

    public void setRotation() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        this.rotation = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        System.out.println("rotation ==" + this.rotation + '<');
        this.rotation += this.getSelectedComboIndex(251) * 90;
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void addToMainMenu(JMenu jMenu) {
        this.currentMenu.add(jMenu);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JToolBar getTopButtonBar() {
        return this.topButtons;
    }

    public void showMessageDialog(Object object) {
        JOptionPane.showMessageDialog(this.frame, object);
    }

    public void showMessageDialog(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this.frame, object, string, n);
    }

    public String showInputDialog(Object object, String string, int n) {
        return JOptionPane.showInputDialog(this.frame, object, string, n);
    }

    public String showInputDialog(String string) {
        return JOptionPane.showInputDialog(this.frame, (Object)string);
    }

    public int showOptionDialog(Object object, String string, int n, int n2, Object object2, Object[] objectArray, Object object3) {
        return JOptionPane.showOptionDialog(this.frame, object, string, n, n2, (Icon)object2, objectArray, object3);
    }

    public int showConfirmDialog(String string, String string2, int n) {
        return JOptionPane.showConfirmDialog(this.frame, string, string2, n);
    }

    public int showOverwriteDialog(String string, boolean bl) {
        int n = -1;
        if (bl) {
            Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            n = JOptionPane.showOptionDialog(this.frame, string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, objectArray, objectArray[0]);
        } else {
            n = JOptionPane.showOptionDialog(this.frame, string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), 0, 3, null, null, null);
        }
        return n;
    }

    public void showMessageDialog(JTextArea jTextArea) {
        JOptionPane.showMessageDialog(this.frame, jTextArea);
    }

    public void showItextPopup() {
        JEditorPane jEditorPane = new JEditorPane("text/html", "Itext is not on the classpath.<BR>JPedal includes code to take advantage of itext and<BR>provide additional functionality with options<BR>to spilt pdf files, and resave forms data<BR>\nItext website - <a href=http://www.lowagie.com/iText/>http://www.lowagie.com/iText/</a>");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL("http://www.lowagie.com/iText/");
                    }
                    catch (IOException iOException) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
        });
        this.showMessageDialog(jEditorPane);
    }

    public void showFirstTimePopup() {
        try {
            final JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/objects/acroforms/ceo.jpg")));
            jPanel.add((Component)jLabel, "North");
            final JLabel jLabel2 = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            jLabel2.setHorizontalAlignment(0);
            jLabel2.setForeground(Color.blue);
            jLabel2.setFont(new Font("Lucida", 0, 16));
            jLabel2.addMouseListener(new MouseListener(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    jPanel.setCursor(new Cursor(12));
                    jLabel2.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jPanel.setCursor(new Cursor(0));
                    jLabel2.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    }
                    catch (IOException iOException) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            jPanel.add((Component)jLabel2, "Center");
            jPanel.setPreferredSize(new Dimension(300, 240));
            Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerButton.RunSoftware")};
            int n = JOptionPane.showOptionDialog(this.frame, jPanel, Messages.getMessage("PdfViewerTitle.RunningFirstTime"), -1, -1, null, objectArray, objectArray[0]);
        }
        catch (Exception exception) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
        catch (Error error) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
    }

    public void showConfirmDialog(Object object, String string, int n, int n2) {
        JOptionPane.showConfirmDialog(this.frame, object, string, n, n2);
    }

    public void updateStatusMessage(String string) {
        this.statusBar.updateStatus(string, 0);
    }

    public void resetStatusMessage(String string) {
        this.statusBar.resetStatus(string);
    }

    public void setStatusProgress(int n) {
        this.statusBar.setProgress(n);
    }

    public boolean isPDFOutlineVisible() {
        return this.navOptionsPanel.isVisible();
    }

    public void setPDFOutlineVisible(boolean bl) {
        this.navOptionsPanel.setVisible(bl);
    }

    public void setSplitDividerLocation(int n) {
        this.displayPane.setDividerLocation(n);
    }

    public void setQualityBoxVisible(boolean bl) {
    }

    private void setThumbnails() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                    SwingGUI.this.setupThumbnailPanel();
                    if (SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                return null;
            }
        };
        swingWorker.start();
    }

    public void setSearchText(JTextField jTextField) {
        this.searchText = jTextField;
    }

    public void setResults(SearchList searchList) {
        this.results = searchList;
    }

    public SearchList getResults() {
        return this.results;
    }

    public JToolBar getComboBar() {
        return this.comboBar;
    }

    public ButtonGroup getSearchLayoutGroup() {
        return this.searchLayoutGroup;
    }

    public void setSearchFrame(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
    }

    class FormActionListener
    implements ActionListener {
        private Container c;
        private String formName;
        boolean showMessage;

        public FormActionListener(String string, Container container, boolean bl) {
            this.c = container;
            this.formName = string;
            this.showMessage = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Object object2 = null;
            if (object instanceof JComboBox) {
                object2 = ((JComboBox)object).getSelectedItem();
            } else if (object instanceof JCheckBox) {
                object2 = String.valueOf(((JCheckBox)object).isSelected());
            } else if (object instanceof JRadioButton) {
                object2 = String.valueOf(((JRadioButton)object).isSelected());
            } else if (object instanceof JTextField) {
                object2 = ((JTextField)object).getText();
            }
            boolean bl = SwingGUI.this.properties.getValue("showsaveformsmessage").equals("true");
            if (bl && SwingGUI.this.firstTimeFormMessage && !SwingGUI.this.commonValues.isFormsChanged()) {
                SwingGUI.this.firstTimeFormMessage = false;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                String string = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValue");
                if (!SwingGUI.this.commonValues.isItextOnClasspath()) {
                    string = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValueNoItext");
                }
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
                Font font = jCheckBox.getFont();
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setOpaque(false);
                jTextArea.setFont(font);
                gridBagConstraints.ipady = 20;
                jPanel.add((Component)jTextArea, gridBagConstraints);
                gridBagConstraints.ipady = 0;
                gridBagConstraints.gridy = 1;
                jPanel.add((Component)jCheckBox, gridBagConstraints);
                JOptionPane.showMessageDialog(this.c, jPanel);
                if (jCheckBox.isSelected()) {
                    SwingGUI.this.properties.setValue("showsaveformsmessage", "false");
                }
            }
            SwingGUI.this.commonValues.setFormsChanged(true);
            SwingGUI.this.setViewerTitle(null);
            if (this.showMessage) {
                JOptionPane.showMessageDialog(this.c, "FormName >>" + this.formName + "<<. Value changed to " + object2);
            }
        }
    }

    private class PageChanger
    implements ActionListener {
        int page;

        public PageChanger(int n) {
            this.page = ++n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != this.page) {
                SwingGUI.this.commonValues.setCurrentPage(this.page);
                SwingGUI.this.statusBar.resetStatus("");
                SwingGUI.this.decodePage(false);
            }
        }
    }
}

