/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwingOutline
extends JScrollPane
implements GUIOutline {
    private boolean ignoreAlteredBookmark = false;
    private HashMap pageLookupTable = new HashMap();
    private Map pointLookupTable = new HashMap();
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;

    public SwingOutline() {
        this.getViewport().add(new JLabel("No outline"));
    }

    public void reset(Node node) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        if (node != null) {
            this.readChildNodes(node, this.top);
        }
        this.tree = new JTree(this.top);
        if (node != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void walk(TreeModel treeModel, Object object, int n) {
        int n2 = treeModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                String string = (String)defaultMutableTreeNode.getUserObject();
                String string2 = (String)this.pageLookupTable.get(string);
                if (string2.length() <= 0) continue;
                try {
                    if (Integer.parseInt(string2) != n) continue;
                    this.ignoreAlteredBookmark = true;
                    this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                    this.ignoreAlteredBookmark = false;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("bad page number: " + string2);
                    this.ignoreAlteredBookmark = false;
                }
                continue;
            }
            this.walk(treeModel, object2, n);
        }
    }

    private void traverse(int n) {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            this.walk(treeModel, treeModel.getRoot(), n);
        }
    }

    private void createLookupTable(TreeModel treeModel, Object object, int n) {
        int n2 = treeModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                String string = (String)defaultMutableTreeNode.getUserObject();
                String string2 = (String)this.pageLookupTable.get(string);
                try {
                    if (Integer.parseInt(string2) != n) continue;
                    this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("bad page number: " + string2);
                }
                continue;
            }
            this.walk(treeModel, object2, n);
        }
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void readChildNodes(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.top;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            Element element = (Element)node2;
            String string = element.getAttribute("title");
            String string2 = element.getAttribute("page");
            String string3 = element.getAttribute("Dest");
            this.pageLookupTable.put(string, string2);
            if (string3 != null && string3.indexOf("/XYZ") != -1) {
                String string4;
                object = new StringTokenizer(string3 = string3.substring(string3.indexOf("/XYZ") + 4), "[] ");
                String string5 = ((StringTokenizer)object).nextToken();
                if (string5.equals("null")) {
                    string5 = "0";
                }
                if ((string4 = ((StringTokenizer)object).nextToken()).equals("null")) {
                    string4 = "0";
                }
                this.pointLookupTable.put(string, new Point((int)Float.parseFloat(string5), (int)Float.parseFloat(string4)));
            }
            object = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add((MutableTreeNode)object);
            if (!node2.hasChildNodes()) continue;
            this.readChildNodes(node2, (DefaultMutableTreeNode)object);
        }
    }

    public boolean isIgnoreAlteredBookmark() {
        return this.ignoreAlteredBookmark;
    }

    public String getPage(String string) {
        return (String)this.pageLookupTable.get(string);
    }

    public void selectBookmark() {
    }

    public Point getPoint(String string) {
        return (Point)this.pointLookupTable.get(string);
    }

    public Object getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

